/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.ban;

import java.net.InetAddress;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.class_3320;
import net.minecraft.class_3336;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.ban.Ban;
import org.spongepowered.api.service.ban.BanType;
import org.spongepowered.api.service.ban.BanTypes;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.util.BanUtil;

public final class SpongeBanBuilder
implements Ban.Builder {
    private GameProfile profile;
    private InetAddress address;
    private BanType banType;
    private @Nullable Component reason;
    private Instant start = Instant.now();
    private @Nullable Instant end;
    private @Nullable Component source;

    public Ban.Builder profile(GameProfile profile) {
        Objects.requireNonNull(profile, "Profile cannot be null!");
        if (this.banType != BanTypes.PROFILE.get()) {
            throw new IllegalStateException("Cannot set a GameProfile if the BanType is not BanTypes.PROFILE!");
        }
        this.profile = profile;
        return this;
    }

    public Ban.Builder address(InetAddress address) {
        Objects.requireNonNull(address, "Address cannot be null!");
        if (this.banType != BanTypes.IP.get()) {
            throw new IllegalStateException("Cannot set an InetAddress if the BanType is not BanTypes.IP!");
        }
        this.address = address;
        return this;
    }

    public Ban.Builder type(BanType type) {
        Objects.requireNonNull(type, "BanType cannot be null!");
        if (type == BanTypes.IP.get()) {
            this.profile = null;
        } else {
            this.address = null;
        }
        this.banType = type;
        return this;
    }

    public Ban.Builder reason(@Nullable Component reason) {
        this.reason = reason;
        return this;
    }

    public Ban.Builder startDate(Instant instant) {
        Objects.requireNonNull(instant, "Start date cannot be null!");
        this.start = instant;
        return this;
    }

    public Ban.Builder expirationDate(@Nullable Instant instant) {
        this.end = instant;
        return this;
    }

    public Ban.Builder source(@Nullable Component source) {
        this.source = source;
        return this;
    }

    public Ban build() {
        String reason;
        if (this.banType == null) {
            throw new IllegalStateException("BanType cannot be null!");
        }
        LegacyComponentSerializer lcs = LegacyComponentSerializer.legacySection();
        String sourceName = this.source != null ? lcs.serialize(this.source) : null;
        String string = reason = this.reason != null ? lcs.serialize(this.reason) : null;
        if (this.banType == BanTypes.PROFILE.get()) {
            if (this.profile == null) {
                throw new IllegalStateException("User cannot be null");
            }
            return (Ban)new class_3336(SpongeGameProfile.toMcProfile(this.profile.withoutProperties()), Date.from(this.start), sourceName, this.toDate(this.end), reason);
        }
        if (this.address == null) {
            throw new IllegalStateException("Address cannot be null!");
        }
        return (Ban)new class_3320(BanUtil.addressToBanCompatibleString(this.address), Date.from(this.start), sourceName, this.toDate(this.end), reason);
    }

    private Date toDate(Instant instant) {
        return instant == null ? null : Date.from(instant);
    }

    public Ban.Builder from(Ban ban) {
        this.reset();
        this.banType = ban.type();
        if (this.banType.equals(BanTypes.PROFILE.get())) {
            this.profile = ((Ban.Profile)ban).profile();
        } else {
            this.address = ((Ban.IP)ban).address();
        }
        this.reason = ban.reason().orElse(null);
        this.start = ban.creationDate();
        this.end = ban.expirationDate().orElse(null);
        this.source = ban.banSource().orElse(null);
        return this;
    }

    public Ban.Builder reset() {
        this.profile = null;
        this.address = null;
        this.banType = null;
        this.reason = null;
        this.start = Instant.now();
        this.end = null;
        this.source = null;
        return this;
    }
}

