/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.block.entity.BlockEntityType;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.entity.SpongeBlockEntityArchetypeBuilder;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.data.DataContainerHolder;
import org.spongepowered.common.data.holder.SpongeImmutableDataHolder;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.provider.nbt.NBTDataType;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DataUtil;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeBlockSnapshot
implements BlockSnapshot,
SpongeImmutableDataHolder<BlockSnapshot>,
DataContainerHolder.Immutable<BlockSnapshot>,
DataCompoundHolder {
    private final BlockState blockState;
    private final ResourceKey worldKey;
    private final Vector3i pos;
    final @Nullable class_2487 compound;
    private final class_2338 blockPos;
    private final SpongeBlockChangeFlag changeFlag;
    @Nullable WeakReference<class_3218> world;
    public @MonotonicNonNull BlockChange blockChange;

    SpongeBlockSnapshot(BuilderImpl builder, boolean copyCompound) {
        this.blockState = Objects.requireNonNull(builder.blockState);
        this.worldKey = Objects.requireNonNull(builder.worldKey);
        this.pos = Objects.requireNonNull(builder.coordinates);
        this.blockPos = VecHelper.toBlockPos(this.pos);
        this.compound = copyCompound ? (builder.compound == null ? null : builder.compound.method_10553()) : builder.compound;
        this.changeFlag = builder.flag;
        this.world = builder.worldRef;
        builder.worldRef = null;
    }

    SpongeBlockSnapshot() {
        this.blockState = (BlockState)class_2246.field_10124.method_9564();
        this.worldKey = Constants.World.INVALID_WORLD_KEY;
        this.pos = Vector3i.ZERO;
        this.blockPos = class_2338.field_10980;
        this.compound = null;
        this.changeFlag = null;
    }

    public BlockState state() {
        return this.blockState;
    }

    public class_2680 nativeState() {
        return (class_2680)this.blockState;
    }

    public BlockSnapshot withState(BlockState blockState) {
        return this.createBuilder().blockState(blockState).build();
    }

    public BlockSnapshot withContainer(DataContainer container) {
        return (BlockSnapshot)BuilderImpl.pooled().build((DataView)container).get();
    }

    public ResourceKey world() {
        return this.worldKey;
    }

    public Vector3i position() {
        return this.pos;
    }

    public Optional<ServerLocation> location() {
        return this.getServerWorld().map(world -> ServerLocation.of((ServerWorld)((ServerWorld)world), (Vector3i)this.pos));
    }

    public BlockSnapshot withLocation(ServerLocation location) {
        return BuilderImpl.pooled().from(this).position(location.blockPosition()).world(location.worldKey()).build();
    }

    public boolean restore(boolean force, BlockChangeFlag flag) {
        Optional<class_3218> optionalWorld = this.getServerWorld();
        if (!optionalWorld.isPresent()) {
            return false;
        }
        class_3218 world = optionalWorld.get();
        try (Object context = BlockPhase.State.RESTORING_BLOCKS.createPhaseContext(PhaseTracker.getWorldInstance(world));){
            ((PhaseContext)context).buildAndSwitch();
            class_2338 pos = VecHelper.toBlockPos(this.pos);
            if (!world.method_24794(pos)) {
                boolean bl = false;
                return bl;
            }
            class_2680 current = world.method_8320(pos);
            class_2680 replaced = (class_2680)this.blockState;
            if (!(force || current.method_26204() == replaced.method_26204() && current == replaced)) {
                boolean bl = false;
                return bl;
            }
            if (!current.method_27852(((class_2680)this.blockState).method_26204())) {
                world.method_8544(pos);
            }
            world.method_8652(pos, replaced, BlockChangeFlagManager.andNotifyClients(flag).getRawFlag());
            if (this.compound != null) {
                @Nullable class_2586 te = world.method_8321(pos);
                if (te != null) {
                    te.method_31664((class_2680)this.blockState);
                    te.method_58690(this.compound, (class_7225.class_7874)world.method_30349());
                } else {
                    try {
                        te = class_2586.method_11005((class_2338)pos, (class_2680)((class_2680)this.blockState), (class_2487)this.compound, (class_7225.class_7874)world.method_30349());
                        if (te != null) {
                            world.method_22350(pos).method_12007(te);
                        }
                    }
                    catch (Exception e) {
                        PrettyPrinter printer = new PrettyPrinter(60).add("Unable to restore").centre().hr().add("A mod is not correctly deserializing a TileEntity that is being restored. ").addWrapped(60, "Note that this is not the fault of Sponge. Sponge is understanding that a block is supposed to have a TileEntity, but the mod is breaking the contracton how to re-create the tile entity. Please open an issue with the offending mod.", new Object[0]).add("Here's the provided compound:");
                        printer.add();
                        try {
                            printer.addWrapped(80, "%s : %s", "This compound", this.compound);
                        }
                        catch (Throwable error) {
                            printer.addWrapped(80, "Unable to get the string of this compound. Printing out some of the entries to better assist", new Object[0]);
                        }
                        printer.add().add("Desired World: " + String.valueOf(this.worldKey)).add("Position: " + String.valueOf(this.pos)).add("Desired BlockState: " + String.valueOf(this.blockState));
                        printer.add();
                        printer.log(SpongeCommon.logger(), Level.ERROR);
                        boolean bl = true;
                        if (context != null) {
                            ((PhaseContext)context).close();
                        }
                        return bl;
                    }
                }
                if (te != null) {
                    te.method_5431();
                }
            }
            world.method_14178().method_14128(pos);
            boolean bl = true;
            return bl;
        }
    }

    public Optional<UUID> creator() {
        return Optional.empty();
    }

    public Optional<UUID> notifier() {
        return Optional.empty();
    }

    public Optional<BlockEntityArchetype> createArchetype() {
        if (this.compound == null) {
            return Optional.empty();
        }
        String blockEntityId = this.compound.method_10558("id");
        class_2487 compound = this.compound.method_10553();
        compound.method_10551("x");
        compound.method_10551("y");
        compound.method_10551("z");
        compound.method_10551("id");
        return Optional.of(SpongeBlockEntityArchetypeBuilder.pooled().state(this.state()).blockEntity((BlockEntityType)SpongeCommon.vanillaRegistry(class_7924.field_41255).method_17966(class_2960.method_12829((String)blockEntityId)).orElse(null)).blockEntityData((DataView)NBTTranslator.INSTANCE.translate(compound)).build());
    }

    public BlockSnapshot withRawData(DataView container) throws InvalidDataException {
        return BuilderImpl.pooled().buildContent(container).orElseThrow(InvalidDataException::new);
    }

    public boolean validateRawData(DataView container) {
        return BuilderImpl.pooled().buildContent(container).isPresent();
    }

    public BlockSnapshot copy() {
        return this;
    }

    public int contentVersion() {
        return 1;
    }

    public DataContainer toContainer() {
        DataContainer container = DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.NO_DATA_CLONED).set(Queries.CONTENT_VERSION, (Object)this.contentVersion()).set(Queries.WORLD_KEY, (Object)this.worldKey.asString()).createView(Constants.Sponge.SNAPSHOT_WORLD_POSITION).set(Queries.POSITION_X, (Object)this.pos.x()).set(Queries.POSITION_Y, (Object)this.pos.y()).set(Queries.POSITION_Z, (Object)this.pos.z()).container().set(Constants.Block.BLOCK_STATE, (Object)this.blockState);
        if (this.compound != null) {
            container.set(Constants.Sponge.UNSAFE_NBT, (Object)NBTTranslator.INSTANCE.translateFrom(this.compound));
        }
        return container;
    }

    public Optional<class_3218> getServerWorld() {
        class_3218 world;
        class_3218 class_32182 = world = this.world != null ? (class_3218)this.world.get() : null;
        if (world == null && (world = (class_3218)Sponge.server().worldManager().world(this.worldKey).orElse(null)) != null) {
            this.world = new WeakReference<class_3218>(world);
        }
        return Optional.ofNullable(world);
    }

    public Optional<class_2487> getCompound() {
        return this.compound == null ? Optional.empty() : Optional.of(this.compound.method_10553());
    }

    public BuilderImpl createBuilder() {
        BuilderImpl builder = BuilderImpl.pooled();
        builder.blockState(this.blockState).position(this.pos);
        Optional<class_3218> optionalWorld = this.getServerWorld();
        if (optionalWorld.isPresent()) {
            builder.world(optionalWorld.get());
        } else {
            builder.world(this.worldKey);
        }
        if (this.compound != null) {
            builder.addUnsafeCompound(this.compound);
        }
        return builder;
    }

    @Override
    public DataContainer data$getDataContainer() {
        if (this.compound == null) {
            return DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.NO_DATA_CLONED);
        }
        return NBTTranslator.INSTANCE.translate(this.compound);
    }

    @Override
    public BlockSnapshot data$withDataContainer(DataContainer container) {
        BuilderImpl builder = this.createBuilder();
        builder.compound = NBTTranslator.INSTANCE.translate((DataView)container);
        return builder.build();
    }

    @Override
    public class_2487 data$getCompound() {
        return this.compound == null ? new class_2487() : this.compound.method_10553();
    }

    @Override
    public void data$setCompound(class_2487 nbt) {
    }

    @Override
    public List<DataHolder> impl$delegateDataHolder() {
        return Arrays.asList(this, this.state(), this.state().type());
    }

    @Override
    public NBTDataType data$getNBTDataType() {
        return NBTDataTypes.BLOCK_ENTITY;
    }

    public SpongeBlockChangeFlag getChangeFlag() {
        return this.changeFlag;
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeBlockSnapshot that = (SpongeBlockSnapshot)o;
        return this.blockState.equals((Object)that.blockState) && this.changeFlag == that.changeFlag && Objects.equals(this.worldKey, that.worldKey) && Objects.equals(this.pos, that.pos) && Objects.equals(this.compound, that.compound);
    }

    public int hashCode() {
        return Objects.hash(this.blockState, this.worldKey, this.pos, this.changeFlag, this.compound);
    }

    public String toString() {
        return new StringJoiner(", ", SpongeBlockSnapshot.class.getSimpleName() + "[", "]").add("world=" + String.valueOf(this.worldKey)).add("position=" + String.valueOf(this.blockPos)).add("blockState=" + String.valueOf(this.blockState)).toString();
    }

    public static final class BuilderImpl
    extends AbstractDataBuilder<BlockSnapshot>
    implements BlockSnapshot.Builder {
        private static final Deque<BuilderImpl> pool = new ConcurrentLinkedDeque<BuilderImpl>();
        BlockState blockState;
        ResourceKey worldKey;
        @Nullable UUID creatorUniqueId;
        @Nullable UUID notifierUniqueId;
        Vector3i coordinates;
        @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
        DataManipulator.Immutable> manipulators;
        @Nullable class_2487 compound;
        SpongeBlockChangeFlag flag = (SpongeBlockChangeFlag)BlockChangeFlags.ALL;
        @Nullable WeakReference<class_3218> worldRef;
        private final boolean pooled;

        public static BuilderImpl unpooled() {
            return new BuilderImpl(false);
        }

        public static BuilderImpl pooled() {
            BuilderImpl builder = pool.pollFirst();
            if (builder != null) {
                return builder.reset();
            }
            return new BuilderImpl(true);
        }

        private BuilderImpl(boolean pooled) {
            super(BlockSnapshot.class, 1);
            this.pooled = pooled;
        }

        public @NonNull BuilderImpl world(@NonNull ServerWorldProperties worldProperties) {
            this.worldKey = Objects.requireNonNull(worldProperties).key();
            this.worldRef = null;
            return this;
        }

        public BuilderImpl world(ResourceKey key) {
            this.worldKey = Objects.requireNonNull(key);
            this.worldRef = null;
            return this;
        }

        public BuilderImpl world(class_3218 world) {
            this.worldKey = ((ServerWorld)Objects.requireNonNull(world)).key();
            this.worldRef = new WeakReference<class_3218>(world);
            return this;
        }

        public @NonNull BuilderImpl blockState(@NonNull BlockState blockState) {
            this.blockState = Objects.requireNonNull(blockState);
            return this;
        }

        public BuilderImpl blockState(class_2680 blockState) {
            this.blockState = Objects.requireNonNull((BlockState)blockState);
            return this;
        }

        public @NonNull BuilderImpl position(@NonNull Vector3i position) {
            this.coordinates = Objects.requireNonNull(position);
            if (this.compound != null) {
                this.compound.method_10569("x", position.x());
                this.compound.method_10569("y", position.y());
                this.compound.method_10569("z", position.z());
            }
            return this;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull BlockSnapshot.Builder from(@NonNull ServerLocation location) {
            return this.from(location.createSnapshot());
        }

        public @NonNull BuilderImpl creator(UUID uuid) {
            this.creatorUniqueId = Objects.requireNonNull(uuid);
            return this;
        }

        public @NonNull BuilderImpl notifier(UUID uuid) {
            this.notifierUniqueId = Objects.requireNonNull(uuid);
            return this;
        }

        public <V> // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull BlockSnapshot.Builder add(@NonNull Key<@NonNull ? extends Value<V>> key, @NonNull V value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            this.blockState = (BlockState)this.blockState.with(key, value).orElseThrow(() -> new IllegalArgumentException(String.format("Key %s is not supported for block state %s", key.key().asString(), this.blockState.toString())));
            return this;
        }

        public @NonNull BuilderImpl from(BlockSnapshot holder) {
            Objects.requireNonNull(holder);
            this.blockState = holder.state();
            this.worldKey = holder.world();
            if (holder.creator().isPresent()) {
                this.creatorUniqueId = (UUID)holder.creator().get();
            }
            if (holder.notifier().isPresent()) {
                this.notifierUniqueId = (UUID)holder.notifier().get();
            }
            this.coordinates = holder.position();
            return this;
        }

        public BuilderImpl from(SpongeBlockSnapshot snapshot) {
            Objects.requireNonNull(snapshot);
            this.blockState = snapshot.state();
            this.worldKey = snapshot.world();
            this.worldRef = snapshot.world;
            this.compound = snapshot.compound != null ? snapshot.compound.method_10553() : null;
            this.coordinates = snapshot.position();
            this.flag = snapshot.getChangeFlag();
            return this;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        public ResourceKey getWorldKey() {
            return this.worldKey;
        }

        public @Nullable UUID getCreatorUniqueId() {
            return this.creatorUniqueId;
        }

        public Vector3i getCoordinates() {
            return this.coordinates;
        }

        public @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
        DataManipulator.Immutable> getManipulators() {
            return this.manipulators;
        }

        public @Nullable class_2487 getCompound() {
            return this.compound;
        }

        public SpongeBlockChangeFlag getFlag() {
            return this.flag;
        }

        public @NonNull BuilderImpl reset() {
            this.blockState = (BlockState)class_2246.field_10124.method_9564();
            this.worldKey = Constants.World.INVALID_WORLD_KEY;
            this.creatorUniqueId = null;
            this.notifierUniqueId = null;
            this.coordinates = null;
            this.manipulators = null;
            this.compound = null;
            this.flag = null;
            return this;
        }

        public @NonNull SpongeBlockSnapshot build() {
            Objects.requireNonNull(this.blockState, "BlockState cannot be null!");
            SpongeBlockSnapshot spongeBlockSnapshot = new SpongeBlockSnapshot(this, !this.pooled);
            this.reset();
            if (this.pooled) {
                pool.push(this);
            }
            return spongeBlockSnapshot;
        }

        protected @NonNull Optional<BlockSnapshot> buildContent(DataView container) throws InvalidDataException {
            if (!container.contains(Constants.Block.BLOCK_STATE, new DataQuery[]{Constants.Sponge.SNAPSHOT_WORLD_POSITION})) {
                return Optional.empty();
            }
            if (!container.contains(Queries.WORLD_KEY)) {
                if (!container.contains(Constants.Sponge.BlockSnapshot.WORLD_UUID)) {
                    return Optional.empty();
                }
                UUID uuid = UUID.fromString((String)container.getString(Constants.Sponge.BlockSnapshot.WORLD_UUID).get());
                Sponge.server().worldManager().worldKey(uuid).ifPresent(worldKey -> container.set(Queries.WORLD_KEY, worldKey));
            }
            DataUtil.checkDataExists(container, Constants.Block.BLOCK_STATE);
            DataUtil.checkDataExists(container, Queries.WORLD_KEY);
            BuilderImpl builder = BuilderImpl.pooled();
            ResourceKey worldKey2 = (ResourceKey)container.getResourceKey(Queries.WORLD_KEY).get();
            Vector3i coordinate = DataUtil.getPosition3i(container);
            Optional creatorUuid = container.getString(Queries.CREATOR_ID);
            Optional notifierUuid = container.getString(Queries.NOTIFIER_ID);
            BlockState blockState = (BlockState)container.getSerializable(Constants.Block.BLOCK_STATE, BlockState.class).get();
            builder.blockState(blockState).world(worldKey2).position(coordinate);
            creatorUuid.ifPresent(s -> builder.creator(UUID.fromString(s)));
            notifierUuid.ifPresent(s -> builder.notifier(UUID.fromString(s)));
            container.getView(Constants.Sponge.UNSAFE_NBT).map(dataView -> NBTTranslator.INSTANCE.translate((DataView)dataView)).ifPresent(builder::addUnsafeCompound);
            return Optional.of(builder.build());
        }

        public BuilderImpl addUnsafeCompound(class_2487 compound) {
            Objects.requireNonNull(compound);
            this.compound = compound.method_10553();
            return this;
        }

        public BuilderImpl flag(BlockChangeFlag flag) {
            this.flag = (SpongeBlockChangeFlag)flag;
            return this;
        }

        public BuilderImpl tileEntity(class_2586 added) {
            this.compound = added.method_38242((class_7225.class_7874)added.method_10997().method_30349());
            return this;
        }
    }

    public static final class FactoryImpl
    implements BlockSnapshot.Factory {
        public BlockSnapshot empty() {
            return Holder.EMPTY;
        }

        static final class Holder {
            static final SpongeBlockSnapshot EMPTY = new SpongeBlockSnapshot();

            Holder() {
            }
        }
    }
}

