/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block;

import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.block.BlockStateSerializerDeserializer;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DataUtil;

public class SpongeBlockStateBuilder
extends AbstractDataBuilder<BlockState>
implements BlockState.Builder {
    private BlockState blockState;

    public SpongeBlockStateBuilder() {
        super(BlockState.class, 1);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BlockState.Builder blockType(@NonNull BlockType blockType) {
        this.blockState = (BlockState)Objects.requireNonNull(blockType).defaultState();
        return this;
    }

    public <V> @NonNull SpongeBlockStateBuilder add(@NonNull Key<@NonNull ? extends Value<V>> key, @NonNull V value) {
        Objects.requireNonNull(key, "key");
        this.blockState = this.blockState.with(key, value).orElse(this.blockState);
        return this;
    }

    public @NonNull SpongeBlockStateBuilder from(@NonNull BlockState holder) {
        this.blockState = holder;
        return this;
    }

    public @NonNull SpongeBlockStateBuilder reset() {
        this.blockState = null;
        return this;
    }

    public @NonNull BlockState build() {
        return this.blockState;
    }

    protected @NonNull Optional<BlockState> buildContent(DataView container) throws InvalidDataException {
        if (!container.contains(Constants.Block.BLOCK_STATE)) {
            return Optional.empty();
        }
        DataUtil.checkDataExists(container, Constants.Block.BLOCK_STATE);
        try {
            return container.getString(Constants.Block.BLOCK_STATE).flatMap(BlockStateSerializerDeserializer::deserialize);
        }
        catch (Exception e) {
            throw new InvalidDataException("Could not retrieve a blockstate!", (Throwable)e);
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BlockState.Builder fromString(@NonNull String id) {
        this.blockState = BlockStateSerializerDeserializer.deserialize(id).orElseThrow(() -> new IllegalArgumentException("The provided state is not valid."));
        return this;
    }
}

