/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block.entity;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.block.entity.BlockEntityType;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.entity.SpongeBlockEntityArchetypeBuilder;
import org.spongepowered.common.data.AbstractArchetype;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.nbt.validation.RawDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.nbt.validation.ValidationTypes;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.provider.DataProviderLookup;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;

public final class SpongeBlockEntityArchetype
extends AbstractArchetype<BlockEntityType, BlockSnapshot, BlockEntity>
implements BlockEntityArchetype {
    final BlockState blockState;
    public static final ImmutableList<RawDataValidator> VALIDATORS = ImmutableList.of();
    private static final DataProviderLookup lookup = SpongeDataManager.getProviderRegistry().getProviderLookup(SpongeBlockEntityArchetype.class);
    private @Nullable class_2586 cachedBlockEntity;

    SpongeBlockEntityArchetype(SpongeBlockEntityArchetypeBuilder builder) {
        super(builder.type, NBTTranslator.INSTANCE.translate((DataView)builder.data));
        this.blockState = builder.blockState;
    }

    public BlockState state() {
        return this.blockState;
    }

    public BlockEntityType blockEntityType() {
        return (BlockEntityType)this.type;
    }

    public DataContainer blockEntityData() {
        return NBTTranslator.INSTANCE.translateFrom(this.compound);
    }

    public Optional<BlockEntity> apply(ServerLocation location) {
        BlockState currentState = location.block();
        class_2248 currentBlock = ((class_2680)currentState).method_26204();
        class_2248 newBlock = ((class_2680)this.blockState).method_26204();
        class_1937 minecraftWorld = (class_1937)location.world();
        class_2338 blockpos = VecHelper.toBlockPos(location);
        if (currentBlock != newBlock) {
            ((World)minecraftWorld).setBlock(blockpos.method_10263(), blockpos.method_10264(), blockpos.method_10260(), this.blockState, BlockChangeFlags.ALL);
        }
        class_2487 compound = this.compound.method_10553();
        @Nullable class_2586 tileEntity = minecraftWorld.method_8321(blockpos);
        if (tileEntity == null) {
            return Optional.empty();
        }
        compound.method_10569("x", blockpos.method_10263());
        compound.method_10569("y", blockpos.method_10264());
        compound.method_10569("z", blockpos.method_10260());
        tileEntity.method_31664((class_2680)currentState);
        tileEntity.method_58690(compound, (class_7225.class_7874)minecraftWorld.method_30349());
        return Optional.of((BlockEntity)tileEntity);
    }

    public BlockSnapshot toSnapshot(ServerLocation location) {
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled();
        return builder.blockState(this.blockState).addUnsafeCompound(this.compound.method_10553()).world(location.worldKey()).position(location.blockPosition()).build();
    }

    public int contentVersion() {
        return 1;
    }

    public DataContainer toContainer() {
        return DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.NO_DATA_CLONED).set(Queries.CONTENT_VERSION, (Object)this.contentVersion()).set(Constants.Sponge.BlockEntityArchetype.BLOCK_ENTITY_TYPE, this.type).set(Constants.Sponge.BlockEntityArchetype.BLOCK_STATE, (Object)this.blockState).set(Constants.Sponge.BlockEntityArchetype.BLOCK_ENTITY_DATA, (Object)this.blockEntityData());
    }

    @Override
    public DataProviderLookup getLookup() {
        return lookup;
    }

    @Override
    protected ValidationType getValidationType() {
        return (ValidationType)ValidationTypes.BLOCK_ENTITY.get();
    }

    public SpongeBlockEntityArchetype copy() {
        SpongeBlockEntityArchetypeBuilder builder = SpongeBlockEntityArchetypeBuilder.pooled();
        builder.type = (BlockEntityType)this.type;
        builder.data = NBTTranslator.INSTANCE.translate(this.compound);
        builder.blockState = this.blockState;
        return builder.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockEntityArchetype that = (SpongeBlockEntityArchetype)o;
        return this.blockState.equals((Object)that.blockState);
    }

    @Override
    protected ImmutableList<RawDataValidator> getValidators() {
        return VALIDATORS;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.blockState);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", SpongeBlockEntityArchetype.class.getSimpleName() + "[", "]").add("type=" + String.valueOf(this.type)).add("state=" + String.valueOf(this.blockState)).add("data=" + String.valueOf(this.compound)).toString();
    }

    @Override
    public List<DataHolder> impl$delegateDataHolder() {
        if (this.cachedBlockEntity == null) {
            class_2487 compound = this.compound.method_10553();
            compound.method_10582("id", SpongeCommon.vanillaRegistry(class_7924.field_41255).method_10221((Object)((class_2591)this.type)).toString());
            this.cachedBlockEntity = class_2586.method_11005((class_2338)new class_2338(0, 0, 0), (class_2680)((class_2680)this.blockState), (class_2487)compound, (class_7225.class_7874)SpongeCommon.vanillaRegistryAccess());
        }
        return Arrays.asList(this, (DataHolder)this.cachedBlockEntity);
    }
}

