/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.bridge.data;

import java.util.Optional;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.data.DataUtil;

public final class DataHolderProcessor {
    public static <E> Optional<E> bridge$get(SpongeDataHolderBridge bridge, Key<? extends Value<E>> key) {
        return bridge.bridge$getManipulator().get(key);
    }

    public static <E> DataTransactionResult bridge$offer(SpongeDataHolderBridge bridge, Key<? extends Value<E>> key, E value) {
        DataManipulator.Mutable manipulator = bridge.bridge$getManipulator();
        Value.Immutable immutableValue = manipulator.getValue(key).map(Value::asImmutable).orElse(null);
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        if (immutableValue != null) {
            builder.replace(immutableValue);
        }
        manipulator.set(key, value);
        builder.success(((Value)manipulator.getValue(key).get()).asImmutable());
        DataUtil.syncDataToTag(bridge);
        return builder.result(DataTransactionResult.Type.SUCCESS).build();
    }

    public static <E> DataTransactionResult bridge$remove(SpongeDataHolderBridge bridge, Key<? extends Value<E>> key) {
        DataManipulator.Mutable manipulator = bridge.bridge$getManipulator();
        Optional value = manipulator.getValue(key);
        if (value.isPresent()) {
            manipulator.remove(key);
        }
        DataUtil.syncDataToTag(bridge);
        return value.map(Value::asImmutable).map(DataTransactionResult::successRemove).orElseGet(DataTransactionResult::successNoData);
    }

    private DataHolderProcessor() {
    }
}

