/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.bridge.world.level.storage;

import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.class_2596;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_4273;
import net.minecraft.class_5217;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.world.server.SpongeServerLevelData;
import org.spongepowered.common.world.server.SpongeWorldManager;

public interface ServerLevelDataBridge {
    public static final Map<ServerLevelDataBridge, SpongeServerLevelData> spongeDataMap = new MapMaker().weakKeys().makeMap();

    default public SpongeServerLevelData bridge$spongeData() {
        return spongeDataMap.computeIfAbsent(this, k -> new SpongeServerLevelData());
    }

    default public boolean bridge$valid() {
        return this.bridge$spongeData().key() != null;
    }

    default public @Nullable class_3218 bridge$level() {
        if (!Sponge.isServerAvailable()) {
            return null;
        }
        ResourceKey key = this.bridge$spongeData().key();
        if (key == null) {
            return null;
        }
        class_3218 level = SpongeCommon.server().method_3847(SpongeWorldManager.createRegistryKey(key));
        if (level == null) {
            return null;
        }
        class_5217 levelData = level.method_8401();
        if (levelData != this) {
            throw new IllegalStateException(String.format("The reference for the data for key '%s' does not match this object. This object is stale.", key));
        }
        return level;
    }

    default public @Nullable class_2874 bridge$dimensionType() {
        return null;
    }

    default public boolean bridge$customDifficulty() {
        return false;
    }

    default public boolean bridge$customGameType() {
        return false;
    }

    default public boolean bridge$customSpawnPosition() {
        return false;
    }

    default public Optional<Boolean> bridge$pvp() {
        return Optional.empty();
    }

    default public boolean bridge$loadOnStartup() {
        return false;
    }

    default public boolean bridge$performsSpawnLogic() {
        return true;
    }

    default public Optional<SerializationBehavior> bridge$serializationBehavior() {
        return Optional.empty();
    }

    default public Optional<Component> bridge$displayName() {
        return Optional.empty();
    }

    default public Optional<Integer> bridge$viewDistance() {
        return Optional.empty();
    }

    default public void bridge$triggerViewDistanceLogic() {
        class_3218 level = this.bridge$level();
        if (level != null) {
            int distance = this.bridge$viewDistance().orElseGet(() -> level.method_8503().method_3760().method_14568());
            level.method_14178().method_14144(distance);
            class_4273 packet = new class_4273(distance);
            level.method_18456().forEach(p -> p.field_13987.method_14364((class_2596)packet));
        }
    }
}

