/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import com.mojang.brigadier.suggestion.Suggestion;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.common.adventure.SpongeAdventure;

public final class SpongeCommandCompletion
implements CommandCompletion {
    final String completion;
    final @Nullable Component tooltip;

    public static SpongeCommandCompletion from(@NonNull Suggestion suggestion) {
        @Nullable Component tooltip = null;
        if (suggestion.getTooltip() != null) {
            tooltip = SpongeAdventure.asAdventure(suggestion.getTooltip());
        }
        return new SpongeCommandCompletion(suggestion.getText(), tooltip);
    }

    public SpongeCommandCompletion(String completion) {
        this(completion, null);
    }

    public SpongeCommandCompletion(String completion, @Nullable Component tooltip) {
        this.completion = completion;
        this.tooltip = tooltip;
    }

    public String completion() {
        return this.completion;
    }

    public Optional<Component> tooltip() {
        return Optional.ofNullable(this.tooltip);
    }
}

