/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;

public final class SpongeImmutableArgumentReader
implements ArgumentReader.Immutable,
ImmutableStringReader {
    private final String input;
    private final int cursor;
    private final int length;
    private final int remaining;

    SpongeImmutableArgumentReader(String input, int cursor) {
        this.input = input;
        this.cursor = cursor;
        this.length = this.input.length();
        this.remaining = this.length - cursor;
    }

    public String getString() {
        return this.input;
    }

    public int getRemainingLength() {
        return this.remainingLength();
    }

    public int getTotalLength() {
        return this.totalLength();
    }

    public int getCursor() {
        return this.cursor;
    }

    public String getRead() {
        return this.parsed();
    }

    public String getRemaining() {
        return this.remaining();
    }

    public @NonNull String input() {
        return this.input;
    }

    public int remainingLength() {
        return this.remaining;
    }

    public int totalLength() {
        return this.length;
    }

    public int cursor() {
        return this.cursor;
    }

    public @NonNull String parsed() {
        if (this.cursor == 0) {
            return "";
        }
        return this.input.substring(0, this.cursor);
    }

    public @NonNull String remaining() {
        return this.input.substring(this.cursor);
    }

    public boolean canRead(int length) {
        return this.cursor + length <= this.length;
    }

    public boolean canRead() {
        return this.canRead(1);
    }

    public char peekCharacter() {
        if (this.canRead()) {
            return this.input.charAt(this.cursor);
        }
        throw new IllegalStateException("Cannot read past the end of a string!");
    }

    public @NonNull ArgumentParseException createException(@NonNull Component errorMessage) {
        return new ArgumentParseException(errorMessage, this.input(), this.cursor());
    }

    public char peek() {
        return this.peek(0);
    }

    public char peek(int offset) {
        return this.input.charAt(this.cursor + offset);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ArgumentReader.Mutable mutable() {
        StringReader reader = new StringReader(this.input);
        reader.setCursor(this.cursor);
        return (ArgumentReader.Mutable)reader;
    }
}

