/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.kyori.adventure.text.Component;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.command.brigadier.SpongeImmutableArgumentReader;
import org.spongepowered.common.data.persistence.NBTTranslator;

public final class SpongeStringReader
extends StringReader
implements ArgumentReader.Mutable {
    private static final char SYNTAX_QUOTE = '\"';

    public SpongeStringReader(String string) {
        super(string);
    }

    public SpongeStringReader(StringReader other) {
        super(other);
    }

    public void unskipWhitespace() {
        if (this.getRemainingLength() >= 0 && this.peek(-1) == ' ') {
            this.setCursor(this.getCursor() - 1);
        }
    }

    public @NonNull String input() {
        return this.getString();
    }

    public int remainingLength() {
        return this.getRemainingLength();
    }

    public int totalLength() {
        return this.getTotalLength();
    }

    public int cursor() {
        return this.getCursor();
    }

    public String parsed() {
        int cursor = this.getCursor();
        if (cursor == 0) {
            return "";
        }
        return this.getString().substring(0, cursor);
    }

    public String remaining() {
        return this.getRemaining();
    }

    public char peekCharacter() {
        if (this.canRead()) {
            char read = this.read();
            this.setCursor(this.getCursor() - 1);
            return read;
        }
        throw new IllegalStateException("Cannot get character when at the end of the string.");
    }

    public char parseChar() {
        return this.read();
    }

    public int parseInt() throws ArgumentParseException {
        try {
            return this.readInt();
        }
        catch (CommandSyntaxException e) {
            throw new ArgumentParseException((Component)Component.text((String)"Could not parse an integer"), (Throwable)e, this.getString(), this.getCursor());
        }
    }

    public double parseDouble() throws ArgumentParseException {
        try {
            return this.readDouble();
        }
        catch (CommandSyntaxException e) {
            throw new ArgumentParseException((Component)Component.text((String)"Could not parse a double"), (Throwable)e, this.getString(), this.getCursor());
        }
    }

    public float parseFloat() throws ArgumentParseException {
        try {
            return this.readFloat();
        }
        catch (CommandSyntaxException e) {
            throw new ArgumentParseException((Component)Component.text((String)"Could not parse a float"), (Throwable)e, this.getString(), this.getCursor());
        }
    }

    public ResourceKey parseResourceKey() throws ArgumentParseException {
        return this.readResourceLocation(null);
    }

    public ResourceKey parseResourceKey(@NonNull String defaultNamespace) throws ArgumentParseException {
        return this.readResourceLocation(defaultNamespace);
    }

    public @NonNull String parseUnquotedString() {
        int start = this.getCursor();
        while (this.canRead() && !Character.isWhitespace(this.peek())) {
            this.skip();
        }
        return this.getString().substring(start, this.getCursor());
    }

    public @NonNull String parseString() throws ArgumentParseException {
        try {
            if (this.canRead() && this.peek() == '\"') {
                return this.readQuotedString();
            }
            return this.readUnquotedString();
        }
        catch (CommandSyntaxException e) {
            throw new ArgumentParseException((Component)Component.text((String)"Could not parse string"), (Throwable)e, this.getString(), this.getCursor());
        }
    }

    public String peekString() throws ArgumentParseException {
        int currentCursor = this.getCursor();
        String peek = this.parseString();
        this.setCursor(currentCursor);
        return peek;
    }

    public boolean parseBoolean() throws ArgumentParseException {
        try {
            return this.readBoolean();
        }
        catch (CommandSyntaxException e) {
            throw new ArgumentParseException((Component)Component.text((String)"Could not parse a boolean"), (Throwable)e, this.getString(), this.getCursor());
        }
    }

    public String parseNBTString() throws ArgumentParseException {
        int startCursor = this.getCursor();
        try {
            new class_2522((StringReader)this).method_10727();
        }
        catch (CommandSyntaxException ex) {
            this.setCursor(startCursor);
            throw new ArgumentParseException(SpongeAdventure.asAdventure(ex.getRawMessage()), ex.getInput(), ex.getCursor());
        }
        int endCursor = this.getCursor();
        return this.input().substring(startCursor, endCursor);
    }

    public DataContainer parseDataContainer() throws ArgumentParseException {
        try {
            return NBTTranslator.INSTANCE.translate(new class_2522((StringReader)this).method_10727());
        }
        catch (CommandSyntaxException e) {
            throw this.createException(SpongeAdventure.asAdventure(e.getRawMessage()));
        }
    }

    public @NonNull SpongeImmutableArgumentReader immutable() {
        return new SpongeImmutableArgumentReader(this.getString(), this.getCursor());
    }

    public void setState(@NonNull ArgumentReader state) throws IllegalArgumentException {
        if (!state.input().equals(this.getString())) {
            throw new IllegalArgumentException("The provided ArgumentReader does not match this ArgumentReader");
        }
        this.setCursor(state.cursor());
    }

    public @NonNull ArgumentParseException createException(@Nullable Component errorMessage) {
        return new ArgumentParseException(errorMessage, this.input(), this.getCursor());
    }

    public @NonNull ArgumentParseException createException(@Nullable Component errorMessage, @NonNull Throwable inner) {
        return new ArgumentParseException(errorMessage, inner, this.input(), this.getCursor());
    }

    private ResourceKey readResourceLocation(@Nullable String defaultNamespace) throws ArgumentParseException {
        int i = this.getCursor();
        while (this.canRead() && class_2960.method_12831((char)this.peek())) {
            this.skip();
        }
        String s = this.getString().substring(i, this.getCursor());
        if (s.contains(":")) {
            return ResourceKey.resolve((String)s);
        }
        if (defaultNamespace == null) {
            this.setCursor(i);
            throw this.createException((Component)Component.translatable((String)"argument.id.invalid"));
        }
        return ResourceKey.of((String)defaultNamespace, (String)s);
    }
}

