/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueCompleter;
import org.spongepowered.api.command.parameter.managed.ValueParameterModifier;
import org.spongepowered.api.command.parameter.managed.ValueParser;
import org.spongepowered.api.command.parameter.managed.clientcompletion.ClientCompletionTypes;
import org.spongepowered.common.command.brigadier.SpongeImmutableArgumentReader;
import org.spongepowered.common.command.brigadier.SpongeStringReader;
import org.spongepowered.common.command.brigadier.argument.ArgumentParser;
import org.spongepowered.common.command.brigadier.argument.StandardArgumentParser;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContext;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContextBuilder;
import org.spongepowered.common.command.parameter.managed.clientcompletion.SpongeClientCompletionType;
import org.spongepowered.common.util.CommandUtil;
import org.spongepowered.common.util.Constants;

public final class CustomArgumentParser<T>
implements ArgumentParser<T>,
SuggestionProvider<class_2168> {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("\\d+");
    private final List<ArgumentType<?>> types;
    private final Collection<ValueParser<? extends T>> parsers;
    private final ValueCompleter completer;
    private final boolean doesNotRead;

    public CustomArgumentParser(Collection<ValueParser<? extends T>> parsers, ValueCompleter completer, boolean doesNotRead) {
        ValueParser<? extends T> parser;
        this.parsers = parsers;
        this.completer = completer;
        boolean bl = this.doesNotRead = doesNotRead || parsers.stream().allMatch(x -> x.clientCompletionType().contains(ClientCompletionTypes.NONE.get()));
        this.types = this.parsers.size() == 1 ? ((parser = this.parsers.iterator().next()) instanceof StandardArgumentParser ? Collections.unmodifiableList(((StandardArgumentParser)parser).getClientCompletionArgumentType()) : (this.doesNotRead ? Collections.singletonList(Constants.Command.STANDARD_STRING_ARGUMENT_TYPE) : parser.clientCompletionType().stream().map(x -> ((SpongeClientCompletionType)x).getType()).filter(Objects::nonNull).collect(Collectors.toList()))) : Collections.singletonList(Constants.Command.STANDARD_STRING_ARGUMENT_TYPE);
    }

    @Override
    public final T parse(Parameter.Key<? super T> key, SpongeCommandContextBuilder contextBuilder, SpongeStringReader reader, ValueParameterModifier<T> modifier) throws CommandSyntaxException {
        ArrayList<Throwable> exceptions = null;
        SpongeImmutableArgumentReader state = reader.immutable();
        for (ValueParser<? extends T> valueParser : this.parsers) {
            CommandContext.Builder.Transaction transaction = contextBuilder.startTransaction();
            try {
                Object value = this.modifyResult(key, contextBuilder, reader, modifier, valueParser.parseValue(key, (ArgumentReader.Mutable)reader, (CommandContext.Builder)contextBuilder).orElse(null));
                if (modifier != null) {
                    value = modifier.modifyResult(key, (ArgumentReader.Immutable)reader.immutable(), (CommandContext.Builder)contextBuilder, value).orElse(null);
                }
                contextBuilder.commit(transaction);
                return value;
            }
            catch (Exception e) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Throwable>();
                }
                if (e instanceof ArgumentParseException) {
                    exceptions.add(this.modifyExceptionMessage(reader, (ArgumentParseException)((Object)e), modifier));
                } else {
                    exceptions.add(e);
                }
                reader.setState((ArgumentReader)state);
                contextBuilder.rollback(transaction);
            }
        }
        if (exceptions != null) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, exceptions);
        }
        return null;
    }

    @Override
    public CompletableFuture<Suggestions> listSuggestions(CommandContext<?> context, SuggestionsBuilder builder) {
        List completions = this.completer.complete((org.spongepowered.api.command.parameter.CommandContext)((SpongeCommandContext)context), builder.getRemaining());
        return CommandUtil.buildSuggestionsFromCompletions(completions, builder);
    }

    @Override
    public boolean doesNotRead() {
        return this.doesNotRead;
    }

    @Override
    public Collection<String> getExamples() {
        return Collections.emptyList();
    }

    @Override
    public List<ArgumentType<?>> getClientCompletionArgumentType() {
        return this.types;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return this.listSuggestions(context, builder);
    }
}

