/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.command.parameter.managed.ValueParameterModifier;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.command.SpongeCommandCompletion;
import org.spongepowered.common.command.brigadier.SpongeImmutableArgumentReader;
import org.spongepowered.common.command.brigadier.SpongeStringReader;
import org.spongepowered.common.command.brigadier.argument.ArgumentParser;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContextBuilder;

public class StandardArgumentParser<S, T>
implements ArgumentParser<T>,
ValueParameter.Simple<T> {
    private final ArgumentType<S> type;
    private final Converter<S, T> converter;

    public static <T> StandardArgumentParser<T, T> createIdentity(ArgumentType<T> type) {
        return new StandardArgumentParser<Object, Object>(type, Converter.IDENTITY);
    }

    public static <S, T> StandardArgumentParser<S, T> createConverter(ArgumentType<S> type, Converter<S, T> converter) {
        return new StandardArgumentParser<S, T>(type, converter);
    }

    protected StandardArgumentParser(ArgumentType<S> type, Converter<S, T> converter) {
        this.type = type;
        this.converter = converter;
    }

    @Override
    public final T parse(Parameter.Key<? super T> key, SpongeCommandContextBuilder contextBuilder, SpongeStringReader reader, @Nullable ValueParameterModifier<T> modifier) throws CommandSyntaxException {
        SpongeImmutableArgumentReader state = reader.immutable();
        CommandContext.Builder.Transaction transaction = contextBuilder.startTransaction();
        try {
            T value = this.modifyResult(key, contextBuilder, reader, modifier, this.converter.convert(reader, contextBuilder.cause(), this.type.parse((StringReader)reader)));
            contextBuilder.commit(transaction);
            return value;
        }
        catch (ArgumentParseException e) {
            ArgumentParseException e2 = this.modifyExceptionMessage(reader, e, modifier);
            reader.setState((ArgumentReader)state);
            contextBuilder.rollback(transaction);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)e2);
        }
    }

    @Override
    public CompletableFuture<Suggestions> listSuggestions(CommandContext<?> context, SuggestionsBuilder builder) {
        return this.type.listSuggestions(context, builder);
    }

    @Override
    public Collection<String> getExamples() {
        return this.type.getExamples();
    }

    @Override
    public List<ArgumentType<?>> getClientCompletionArgumentType() {
        return Collections.singletonList(this.type);
    }

    @Override
    public boolean doesNotRead() {
        return false;
    }

    public List<CommandCompletion> complete(@NonNull CommandCause context, @NonNull String currentInput) {
        SuggestionsBuilder suggestionsBuilder = new SuggestionsBuilder(currentInput, 0);
        this.listSuggestions(new SpongeCommandContextBuilder(null, (class_2168)context, (CommandNode<class_2168>)new RootCommandNode(), 0).build(currentInput), suggestionsBuilder);
        return suggestionsBuilder.build().getList().stream().map(SpongeCommandCompletion::from).collect(Collectors.toList());
    }

    public @NonNull Optional<? extends T> parseValue(@NonNull CommandCause cause, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ArgumentReader.Mutable reader) throws ArgumentParseException {
        try {
            return Optional.of(this.converter.convert((StringReader)reader, cause, this.type.parse((StringReader)reader)));
        }
        catch (CommandSyntaxException e) {
            throw new ArgumentParseException(SpongeAdventure.asAdventure(e.getRawMessage()), (Throwable)e, e.getInput(), e.getCursor());
        }
    }

    @FunctionalInterface
    public static interface Converter<S, T> {
        public static final Converter<Object, Object> IDENTITY = (reader, cause, input) -> input;

        public T convert(StringReader var1, CommandCause var2, S var3) throws CommandSyntaxException;
    }
}

