/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.context;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.context.SuggestionContext;
import com.mojang.brigadier.tree.CommandNode;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.class_2168;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.Flag;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContext;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContextBuilderTransaction;
import org.spongepowered.common.command.brigadier.tree.SpongeArgumentCommandNode;
import org.spongepowered.common.command.parameter.SpongeParameterKey;

public final class SpongeCommandContextBuilder
extends CommandContextBuilder<class_2168>
implements CommandContext.Builder {
    private final boolean isTransactionCopy;
    private final Object2IntOpenHashMap<String> flagMap = new Object2IntOpenHashMap();
    private final Map<Parameter.Key<?>, Collection<?>> arguments = new HashMap();
    private RedirectModifier<class_2168> modifier;
    private boolean forks;
    private Deque<SpongeCommandContextBuilderTransaction> transaction = null;
    private Command.Parameterized currentTargetCommand = null;
    private @Nullable String[] nonBrigCommand = null;

    public SpongeCommandContextBuilder(CommandDispatcher<class_2168> dispatcher, class_2168 source, CommandNode<class_2168> root, int start) {
        super(dispatcher, (Object)source, root, start);
        this.isTransactionCopy = false;
    }

    public SpongeCommandContextBuilder(SpongeCommandContextBuilder original) {
        this(original, false);
    }

    public SpongeCommandContextBuilder(SpongeCommandContextBuilder original, boolean isTransactionCopy) {
        super(original.getDispatcher(), (Object)original.getSource(), original.getRootNode(), original.getRange().getStart());
        this.modifier = original.modifier;
        this.forks = original.forks;
        this.currentTargetCommand = original.currentTargetCommand;
        this.getNodes().addAll(original.getNodes());
        this.withChild(original.getChild());
        this.withCommand(original.getCommand());
        original.getArguments().forEach((string, parsedArgument) -> this.withArgument((String)string, (ParsedArgument)parsedArgument));
        for (Map.Entry<Parameter.Key<?>, Collection<?>> arg : original.arguments.entrySet()) {
            this.arguments.put(arg.getKey(), new ArrayList(arg.getValue()));
        }
        original.flagMap.object2IntEntrySet().fastForEach(x -> this.flagMap.put((Object)((String)x.getKey()), x.getIntValue()));
        this.isTransactionCopy = isTransactionCopy;
    }

    public void applySpongeElementsTo(SpongeCommandContextBuilder builder, boolean clear) {
        if (clear) {
            this.flagMap.clear();
            this.arguments.clear();
        }
        this.flagMap.object2IntEntrySet().fastForEach(x -> builder.flagMap.put((Object)((String)x.getKey()), x.getIntValue()));
        this.arguments.forEach((key, values) -> builder.arguments.computeIfAbsent((Parameter.Key<?>)key, k -> new ArrayList()).addAll(values));
        this.currentTargetCommand = builder.currentTargetCommand;
    }

    public StringRange getRange() {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().getCopyBuilder().getRange();
        }
        return super.getRange();
    }

    public class_2168 getSource() {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().getCopyBuilder().getSource();
        }
        return (class_2168)super.getSource();
    }

    public Map<String, ParsedArgument<class_2168, ?>> getArguments() {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().getCopyBuilder().getArguments();
        }
        return super.getArguments();
    }

    public CommandContextBuilder<class_2168> getChild() {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().getCopyBuilder().getChild();
        }
        return super.getChild();
    }

    public CommandContextBuilder<class_2168> getLastChild() {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().getCopyBuilder().getLastChild();
        }
        return super.getLastChild();
    }

    public Command<class_2168> getCommand() {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().getCopyBuilder().getCommand();
        }
        return super.getCommand();
    }

    public List<ParsedCommandNode<class_2168>> getNodes() {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().getCopyBuilder().getNodes();
        }
        return super.getNodes();
    }

    public SuggestionContext<class_2168> findSuggestionContext(int cursor) {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().getCopyBuilder().findSuggestionContext(cursor);
        }
        if (this.getRange().getStart() <= cursor) {
            if (this.getRange().getEnd() < cursor) {
                if (this.getChild() != null) {
                    return this.getChild().findSuggestionContext(cursor);
                }
                if (!this.getNodes().isEmpty()) {
                    ParsedCommandNode<class_2168> last = this.getNodes().get(this.getNodes().size() - 1);
                    return new SuggestionContext(last.getNode(), last.getRange().getEnd() + 1);
                }
                return new SuggestionContext(this.getRootNode(), this.getRange().getStart());
            }
            CommandNode prev = this.getRootNode();
            for (ParsedCommandNode<class_2168> node : this.getNodes()) {
                StringRange nodeRange = node.getRange();
                if (SpongeCommandContextBuilder.checkNodeCannotBeEmpty((CommandNode<class_2168>)node.getNode(), nodeRange) && nodeRange.getStart() <= cursor && cursor <= nodeRange.getEnd()) {
                    return new SuggestionContext(prev, nodeRange.getStart());
                }
                prev = node.getNode();
            }
            if (prev == null) {
                throw new IllegalStateException("Can't find node before cursor");
            }
            return new SuggestionContext(prev, this.getRange().getStart());
        }
        throw new IllegalStateException("Can't find node before cursor");
    }

    public SpongeCommandContextBuilder withArgument(String name, ParsedArgument<class_2168, ?> argument) {
        return this.withArgumentInternal(name, argument, true);
    }

    public <T> SpongeCommandContextBuilder withArgumentInternal(String name, ParsedArgument<class_2168, T> argument, boolean addToSpongeMap) {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().withArgument(name, argument, addToSpongeMap);
        }
        if (addToSpongeMap) {
            SpongeParameterKey objectKey = new SpongeParameterKey(name, argument.getResult().getClass());
            this.addToArgumentMap(objectKey, argument.getResult());
        }
        super.withArgument(name, argument);
        return this;
    }

    public SpongeCommandContextBuilder withSource(class_2168 source) {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().withSource(source);
        }
        super.withSource((Object)source);
        return this;
    }

    public CommandContextBuilder<class_2168> withNode(CommandNode<class_2168> node, StringRange range) {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().withNode(node, range);
        }
        this.modifier = node.getRedirectModifier();
        this.forks = node.isFork();
        return super.withNode(node, range);
    }

    public CommandContextBuilder<class_2168> withChild(CommandContextBuilder<class_2168> child) {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().withChild(child);
        }
        return super.withChild(child);
    }

    public CommandContextBuilder<class_2168> withCommand(Command<class_2168> command) {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().withCommand(command);
        }
        return super.withCommand(command);
    }

    public SpongeCommandContextBuilder copy() {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().getCopyBuilder().copy();
        }
        return new SpongeCommandContextBuilder(this);
    }

    public @NonNull Optional<// Could not load outer class - annotation placement on inner may be incorrect
    Command.Parameterized> executedCommand() {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().getCopyBuilder().executedCommand();
        }
        return Optional.ofNullable(this.currentTargetCommand);
    }

    public @NonNull CommandCause cause() {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().getCopyBuilder().cause();
        }
        return (CommandCause)this.getSource();
    }

    public boolean hasFlag(@NonNull String flagAlias) {
        return this.flagMap.containsKey((Object)flagAlias);
    }

    public boolean hasFlag(@NonNull Flag flag) {
        return this.flagMap.containsKey(flag.unprefixedAliases().iterator().next());
    }

    public int flagInvocationCount(@NonNull String flagKey) {
        return this.flagMap.getOrDefault((Object)flagKey, 0);
    }

    public int flagInvocationCount(@NonNull Flag flag) {
        return this.flagMap.getOrDefault(flag.unprefixedAliases().iterator().next(), 0);
    }

    public boolean hasAny(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Key<?> key) {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().getCopyBuilder().hasAny(key);
        }
        return this.arguments.containsKey(key);
    }

    public <T> @NonNull Optional<T> one(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Key<T> key) {
        SpongeParameterKey<T> spongeParameterKey = SpongeParameterKey.getSpongeKey(key);
        Collection<?> collection = this.getFrom(spongeParameterKey);
        if (collection.size() > 1) {
            throw new IllegalArgumentException("More than one entry was found for " + spongeParameterKey.toString());
        }
        if (collection.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(collection.iterator().next());
    }

    public <T> @NonNull T requireOne(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Key<T> key) throws NoSuchElementException, IllegalArgumentException {
        SpongeParameterKey<T> spongeParameterKey = SpongeParameterKey.getSpongeKey(key);
        Collection<?> collection = this.getFrom(spongeParameterKey);
        if (collection.size() > 1) {
            throw new IllegalArgumentException("More than one entry was found for " + spongeParameterKey.toString());
        }
        if (collection.isEmpty()) {
            throw new NoSuchElementException("No entry was found for " + spongeParameterKey.toString());
        }
        return (T)collection.iterator().next();
    }

    public <T> @NonNull Collection<? extends T> all(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Key<T> key) {
        return this.getFrom(SpongeParameterKey.getSpongeKey(key));
    }

    public boolean hasAny(Parameter.Value<?> parameter) {
        return this.hasAny(parameter.key());
    }

    public <T> Optional<T> one(Parameter.Value<T> parameter) throws IllegalArgumentException {
        return this.one(parameter.key());
    }

    public <T> T requireOne(Parameter.Value<T> parameter) throws NoSuchElementException, IllegalArgumentException {
        return this.requireOne(parameter.key());
    }

    public <T> Collection<? extends T> all(Parameter.Value<T> parameter) {
        return this.all(parameter.key());
    }

    public void sendMessage(@NonNull Component message) {
        this.cause().sendMessage(message);
    }

    public void sendMessage(@NonNull Identified identity, @NonNull Component message) {
        this.cause().sendMessage(identity, message);
    }

    public void sendMessage(@NonNull Identity identity, @NonNull Component message) {
        this.cause().sendMessage(identity, message);
    }

    Collection<?> getFrom(SpongeParameterKey<?> key) {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            return this.transaction.peek().getCopyBuilder().getFrom(key);
        }
        Collection<?> collection = this.arguments.get(key);
        if (collection == null) {
            return ImmutableSet.of();
        }
        return collection;
    }

    void addFlagInvocation(@NonNull String key, int count) {
        this.flagMap.addTo((Object)key, count);
    }

    public void addFlagInvocation(@NonNull Flag flag) {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            this.transaction.peek().addFlagInvocation(flag);
        } else {
            flag.unprefixedAliases().forEach(x -> this.flagMap.addTo(x, 1));
        }
    }

    public <T> void putEntry(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Key<T> key, @NonNull T object) {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            this.transaction.peek().putEntry(key, object);
        } else {
            this.addToArgumentMap(SpongeParameterKey.getSpongeKey(key), object);
        }
    }

    public void setCurrentTargetCommand(Command.Parameterized command) {
        if (this.transaction != null && !this.transaction.isEmpty()) {
            this.transaction.peek().setCurrentTargetCommand(command);
        } else {
            this.currentTargetCommand = command;
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CommandContext.Builder.Transaction startTransaction() {
        if (this.isTransactionCopy) {
            throw new IllegalStateException("Cannot start a transaction on a transaction!");
        }
        if (this.transaction == null) {
            this.transaction = new ArrayDeque<SpongeCommandContextBuilderTransaction>();
        }
        SpongeCommandContextBuilderTransaction transaction = SpongeCommandContextBuilderTransaction.getTransactionFromPool(this);
        this.transaction.addFirst(transaction);
        return transaction;
    }

    public @NonNull SpongeCommandContext build(@NonNull String input) {
        while (this.transaction != null && !this.transaction.isEmpty()) {
            this.commit(this.transaction.peek());
        }
        CommandContextBuilder<class_2168> child = this.getChild();
        return new SpongeCommandContext(this.getSource(), input, this.getArguments(), (Map<Parameter.Key<?>, Collection<?>>)ImmutableMap.copyOf(this.arguments), (CommandNode<class_2168>)this.getRootNode(), this.flagMap, this.getCommand(), this.getNodes(), this.getRange(), (CommandContext<class_2168>)(child == null ? null : child.build(input)), this.modifier, this.forks, this.currentTargetCommand);
    }

    public void commit(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CommandContext.Builder.Transaction transaction) throws IllegalArgumentException {
        if (this.transaction == null || this.transaction.peek() != transaction) {
            throw new IllegalArgumentException("The supplied transaction is not the current transaction for this builder!");
        }
        ((SpongeCommandContextBuilderTransaction)transaction).commit();
        this.removeTransaction(transaction);
    }

    public void rollback(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CommandContext.Builder.Transaction transaction) throws IllegalArgumentException {
        if (this.transaction == null || this.transaction.peek() != transaction) {
            throw new IllegalArgumentException("The supplied transaction is not the current transaction for this builder!");
        }
        ((SpongeCommandContextBuilderTransaction)transaction).rollback();
        this.removeTransaction(transaction);
    }

    private void removeTransaction(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CommandContext.Builder.Transaction transaction) {
        if (this.transaction != null && this.transaction.peek() == transaction) {
            this.transaction.pop();
        }
    }

    private <T> void addToArgumentMap(Parameter.Key<T> key, T value) {
        ((List)this.arguments.computeIfAbsent(key, k -> new ArrayList())).add(value);
    }

    private static boolean checkNodeCannotBeEmpty(CommandNode<class_2168> node, StringRange range) {
        if (range.getStart() == range.getEnd()) {
            return !(node instanceof SpongeArgumentCommandNode) || !((SpongeArgumentCommandNode)node).getParser().doesNotRead();
        }
        return true;
    }

    public Subject subject() {
        return this.cause().subject();
    }

    public Cause contextCause() {
        return this.cause().cause();
    }

    public void setNonBrigCommand(String[] nonBrigCommand) {
        this.nonBrigCommand = nonBrigCommand;
    }

    public String[] nonBrigCommand() {
        return this.nonBrigCommand;
    }

    public boolean representsNonBrigCommand() {
        return this.nonBrigCommand != null;
    }
}

