/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.tree;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2321;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueCompleter;
import org.spongepowered.api.command.parameter.managed.ValueParameterModifier;
import org.spongepowered.api.command.parameter.managed.ValueUsage;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.commands.arguments.CompletionsArgumentTypeBridge;
import org.spongepowered.common.command.SpongeCommandCompletion;
import org.spongepowered.common.command.brigadier.SpongeStringReader;
import org.spongepowered.common.command.brigadier.argument.ArgumentParser;
import org.spongepowered.common.command.brigadier.argument.ComplexSuggestionNodeProvider;
import org.spongepowered.common.command.brigadier.argument.ResourceKeyedArgumentValueParser;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContextBuilder;
import org.spongepowered.common.command.brigadier.tree.SpongeNode;
import org.spongepowered.common.command.brigadier.tree.UnsortedNodeHolder;
import org.spongepowered.common.util.CommandUtil;
import org.spongepowered.common.util.Constants;

public final class SpongeArgumentCommandNode<T>
extends ArgumentCommandNode<class_2168, T>
implements SpongeNode {
    private final Parameter.Key<? super T> key;
    private final ArgumentParser<T> parser;
    private final @Nullable ValueParameterModifier<T> modifier;
    private final ValueUsage usage;
    private final boolean isComplexSuggestions;
    private final boolean isOptional;
    private final UnsortedNodeHolder nodeHolder = new UnsortedNodeHolder();
    private @Nullable Command<class_2168> executor;
    private @Nullable CommandNode<class_2168> forcedRedirect;

    private static @Nullable SuggestionProvider<class_2168> createSuggestionProvider(@Nullable ValueCompleter completer) {
        if (completer == null) {
            return null;
        }
        if (completer instanceof ResourceKeyedArgumentValueParser.ClientNativeCompletions) {
            return ((ResourceKeyedArgumentValueParser.ClientNativeCompletions)completer)::listSuggestions;
        }
        return (context, builder) -> {
            List suggestions = completer.complete((org.spongepowered.api.command.parameter.CommandContext)context, builder.getRemaining());
            for (CommandCompletion suggestion : suggestions) {
                builder.suggest(suggestion.completion(), (Message)suggestion.tooltip().map(SpongeAdventure::asVanilla).orElse(null));
            }
            return builder.buildFuture();
        };
    }

    public SpongeArgumentCommandNode(Parameter.Key<? super T> key, ValueUsage usage, ArgumentParser<T> parser, @Nullable ValueCompleter valueCompleter, @Nullable Command command, Predicate<class_2168> predicate, @Nullable CommandNode<class_2168> redirect, RedirectModifier<class_2168> modifier, boolean forks, String keyName, @Nullable ValueParameterModifier<T> parameterModifier, boolean isOptional) {
        super(keyName, Constants.Command.STANDARD_STRING_ARGUMENT_TYPE, command, predicate, redirect, modifier, forks, SpongeArgumentCommandNode.createSuggestionProvider(valueCompleter));
        this.parser = parser;
        this.modifier = parameterModifier;
        this.isComplexSuggestions = this.parser instanceof ComplexSuggestionNodeProvider;
        this.key = key;
        this.usage = usage;
        this.isOptional = isOptional;
    }

    public Parameter.Key<? super T> key() {
        return this.key;
    }

    public final boolean isComplex() {
        return this.isComplexSuggestions;
    }

    public final CommandNode<class_2172> getComplexSuggestions(CommandNode<class_2172> rootSuggestionNode, Map<CommandNode<class_2168>, CommandNode<class_2172>> commandNodeToSuggestionNode, Map<CommandNode<class_2168>, List<CommandNode<class_2172>>> commandNodeListMap, boolean allowCustomSuggestionsOnTheFirstElement) {
        if (!this.isComplexSuggestions) {
            throw new IllegalStateException("The parser is not a ComplexSuggestionNodeParser");
        }
        ComplexSuggestionNodeProvider provider = (ComplexSuggestionNodeProvider)((Object)this.parser);
        return provider.createSuggestions(rootSuggestionNode, this.key.key(), this.getCommand() != null, nodeList -> commandNodeListMap.put((CommandNode<class_2168>)this, (List<CommandNode<class_2172>>)nodeList), firstNode -> commandNodeToSuggestionNode.put((CommandNode<class_2168>)this, (CommandNode<class_2172>)firstNode), allowCustomSuggestionsOnTheFirstElement);
    }

    @Override
    public final Collection<CommandNode<class_2168>> getChildrenForSuggestions() {
        return this.nodeHolder.getChildrenForSuggestions();
    }

    private ArgumentType<?> switchTypeIfRequired(ArgumentType<?> type) {
        if (type instanceof CompletionsArgumentTypeBridge) {
            return ((CompletionsArgumentTypeBridge)type).bridge$clientSideCompletionType();
        }
        return type;
    }

    public final ArgumentBuilder<class_2172, ?> createBuilderForSuggestions(CommandNode<class_2172> rootSuggestionNode, Map<CommandNode<class_2168>, CommandNode<class_2172>> commandNodeToSuggestionNode) {
        ArgumentType<?> type = this.switchTypeIfRequired(this.getType());
        ArgumentCommandNode previousNode = rootSuggestionNode;
        if (!this.parser.getClientCompletionArgumentType().isEmpty()) {
            boolean forceCustomSuggestions;
            Collection types = this.parser.getClientCompletionArgumentType().stream().filter(Objects::nonNull).collect(Collectors.toList());
            if (types.size() > 1) {
                forceCustomSuggestions = false;
                Iterator<ArgumentType<?>> clientCompletionTypeIterator = this.parser.getClientCompletionArgumentType().iterator();
                boolean isFirst = true;
                while (clientCompletionTypeIterator.hasNext()) {
                    boolean forceCustomSuggestionsInner;
                    ArgumentType<?> originalType = clientCompletionTypeIterator.next();
                    type = this.switchTypeIfRequired(originalType);
                    boolean bl = forceCustomSuggestionsInner = type != this.getType() && !CommandUtil.checkForCustomSuggestions(previousNode);
                    if (!clientCompletionTypeIterator.hasNext()) continue;
                    RequiredArgumentBuilder arg = RequiredArgumentBuilder.argument((String)this.getName(), type);
                    arg.requires(x -> true);
                    if (forceCustomSuggestionsInner || isFirst && type instanceof StringArgumentType) {
                        arg.suggests(class_2321.field_10933);
                    }
                    ArgumentCommandNode built = arg.build();
                    previousNode.addChild((CommandNode)built);
                    previousNode = built;
                    if (!isFirst) continue;
                    commandNodeToSuggestionNode.put((CommandNode<class_2168>)this, (CommandNode<class_2172>)built);
                    isFirst = false;
                }
            } else {
                ArgumentType<?> originalType = this.parser.getClientCompletionArgumentType().get(0);
                type = this.switchTypeIfRequired(originalType);
                forceCustomSuggestions = type != originalType;
            }
            RequiredArgumentBuilder toReturn = RequiredArgumentBuilder.argument((String)this.getUsageTextForClient(), type);
            if (this.getCommand() != null) {
                toReturn.executes(x -> 0);
            }
            if (this.modifier != null || forceCustomSuggestions && !CommandUtil.checkForCustomSuggestions(previousNode)) {
                toReturn.suggests(class_2321.field_10933);
            } else if (this.getCustomSuggestions() != null) {
                toReturn.suggests(this.getCustomSuggestions());
            }
            if (this.getRedirect() != null) {
                toReturn.forward(this.getRedirect(), this.getRedirectModifier(), this.isFork());
            }
            return toReturn;
        }
        RequiredArgumentBuilder builder = RequiredArgumentBuilder.argument((String)this.getUsageTextForClient(), type);
        builder.requires(this.getRequirement());
        builder.forward(this.getRedirect(), this.getRedirectModifier(), this.isFork());
        if (this.modifier != null) {
            builder.suggests(class_2321.field_10933);
        }
        if (!CommandUtil.checkForCustomSuggestions(rootSuggestionNode)) {
            if (type != this.getType()) {
                builder.suggests(class_2321.field_10933);
            } else {
                builder.suggests(this.getCustomSuggestions());
            }
        }
        if (this.getCommand() != null) {
            builder.executes(this.getCommand());
        }
        return builder;
    }

    public final ArgumentParser<? extends T> getParser() {
        return this.parser;
    }

    @Override
    public void forceExecutor(Command<class_2168> forcedExecutor) {
        this.executor = forcedExecutor;
    }

    @Override
    public boolean canForceRedirect() {
        return this.getChildren() == null || this.getChildren().isEmpty();
    }

    @Override
    public void forceRedirect(CommandNode<class_2168> forcedRedirect) {
        this.forcedRedirect = forcedRedirect;
    }

    public CommandNode<class_2168> getRedirect() {
        CommandNode redirect = super.getRedirect();
        if (redirect != null) {
            return redirect;
        }
        if (this.canForceRedirect()) {
            return this.forcedRedirect;
        }
        return null;
    }

    public Command<class_2168> getCommand() {
        Command command = super.getCommand();
        if (command != null) {
            return command;
        }
        return this.executor;
    }

    public String getUsageText() {
        if (this.usage != null) {
            return this.usage.usage(this.key.key());
        }
        return super.getUsageText();
    }

    private String getUsageTextForClient() {
        if (this.usage != null) {
            return this.usage.usage(this.key.key());
        }
        return this.getName();
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public final void parse(StringReader reader, CommandContextBuilder<class_2168> contextBuilder) throws CommandSyntaxException {
        int start = reader.getCursor();
        SpongeCommandContextBuilder builder = (SpongeCommandContextBuilder)contextBuilder;
        T result = this.parser.parse(this.key, builder, (SpongeStringReader)reader, this.modifier);
        if (result != null) {
            builder.putEntry(this.key, result);
            ParsedArgument parsed = new ParsedArgument(start, reader.getCursor(), result);
            builder.withArgumentInternal(this.getName(), parsed, false);
            builder.withNode((CommandNode<class_2168>)this, parsed.getRange());
        } else if (this.parser.doesNotRead()) {
            builder.withNode((CommandNode<class_2168>)this, StringRange.at((int)start));
        }
    }

    public final CompletableFuture<Suggestions> listSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        CompletableFuture suggestions = this.getCustomSuggestions() == null ? this.parser.listSuggestions(context, builder) : this.getCustomSuggestions().getSuggestions(context, builder);
        return this.suggestUsingModifier(context, builder, suggestions);
    }

    public final Collection<String> getExamples() {
        return this.parser.getExamples();
    }

    public void addChild(CommandNode<class_2168> node) {
        super.addChild(node);
        this.nodeHolder.add(node);
    }

    private CompletableFuture<Suggestions> suggestUsingModifier(CommandContext<?> context, SuggestionsBuilder suggestionsBuilder, CompletableFuture<Suggestions> suggestions) {
        if (this.modifier != null) {
            return suggestions.thenApply(x -> {
                List modifiedSuggestions;
                List originalSuggestions = x.getList().stream().map(SpongeCommandCompletion::from).collect(Collectors.toList());
                if (originalSuggestions.equals(modifiedSuggestions = this.modifier.modifyCompletion((org.spongepowered.api.command.parameter.CommandContext)context, suggestionsBuilder.getRemaining(), new ArrayList(originalSuggestions)))) {
                    return x;
                }
                SuggestionsBuilder newBuilder = suggestionsBuilder.restart();
                for (CommandCompletion suggestion : modifiedSuggestions) {
                    newBuilder.suggest(suggestion.completion(), (Message)suggestion.tooltip().map(SpongeAdventure::asVanilla).orElse(null));
                }
                return newBuilder.build();
            });
        }
        return suggestionsBuilder.buildFuture();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.key, this.parser, this.modifier, this.usage, this.isComplexSuggestions, this.getCustomSuggestions());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeArgumentCommandNode that = (SpongeArgumentCommandNode)o;
        return this.isComplexSuggestions == that.isComplexSuggestions && this.getRedirect() == that.getRedirect() && this.key.equals(that.key) && this.parser.equals(that.parser) && Objects.equals(this.modifier, that.modifier) && Objects.equals(this.usage, that.usage) && Objects.equals(this.getCustomSuggestions(), that.getCustomSuggestions());
    }
}

