/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.manager;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.ComponentMessageThrowable;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.manager.CommandFailedRegistrationException;
import org.spongepowered.api.command.manager.CommandManager;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.command.registrar.CommandRegistrar;
import org.spongepowered.api.command.registrar.CommandRegistrarType;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.CallbackCommand;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.commands.CommandsBridge;
import org.spongepowered.common.command.SpongeCommandCompletion;
import org.spongepowered.common.command.brigadier.dispatcher.SpongeCommandDispatcher;
import org.spongepowered.common.command.exception.SpongeCommandResultException;
import org.spongepowered.common.command.exception.SpongeCommandSyntaxException;
import org.spongepowered.common.command.manager.SpongeCommandMapping;
import org.spongepowered.common.command.registrar.BrigadierCommandRegistrar;
import org.spongepowered.common.command.registrar.SpongeParameterizedCommandRegistrar;
import org.spongepowered.common.command.registrar.tree.builder.RootCommandTreeNode;
import org.spongepowered.common.command.result.SpongeCommandResult;
import org.spongepowered.common.command.sponge.SpongeCommand;
import org.spongepowered.common.config.core.SpongeConfigs;
import org.spongepowered.common.event.lifecycle.RegisterCommandEventImpl;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.service.game.pagination.SpongePaginationService;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.plugin.PluginContainer;

public abstract class SpongeCommandManager
implements CommandManager.Mutable {
    public static final CommandResult UNKNOWN_ERROR = new SpongeCommandResult(false, 0, null);
    private static final boolean ALWAYS_PRINT_STACKTRACES = System.getProperty("sponge.command.alwaysPrintStacktraces") != null;
    private final Game game;
    private final Provider<SpongeCommand> spongeCommand;
    private final Map<String, SpongeCommandMapping> commandMappings = new HashMap<String, SpongeCommandMapping>();
    private final Multimap<SpongeCommandMapping, String> inverseCommandMappings = HashMultimap.create();
    private final Multimap<PluginContainer, SpongeCommandMapping> pluginToCommandMap = HashMultimap.create();
    private final LinkedHashMap<SpongeCommandMapping, RootCommandTreeNode> mappingToSuggestionNodes = new LinkedHashMap();
    private final Map<Class<?>, CommandRegistrar<?>> knownRegistrars = new ConcurrentHashMap();
    private BrigadierCommandRegistrar brigadierRegistrar;
    private static final DynamicCommandExceptionType ERROR_UNHANDLED_EXCEPTION = new DynamicCommandExceptionType($$0 -> (class_2561)$$0);

    public static SpongeCommandManager get(MinecraftServer server) {
        return ((CommandsBridge)server.method_3734()).bridge$commandManager();
    }

    @Inject
    public SpongeCommandManager(Game game, Provider<SpongeCommand> spongeCommand) {
        this.game = game;
        this.spongeCommand = spongeCommand;
    }

    public SpongeCommandDispatcher getDispatcher() {
        return this.brigadierRegistrar.getDispatcher();
    }

    public BrigadierCommandRegistrar getBrigadierRegistrar() {
        return this.brigadierRegistrar;
    }

    public @NonNull Set<String> knownAliases() {
        return Collections.unmodifiableSet(new HashSet<String>(this.commandMappings.keySet()));
    }

    public @NonNull Set<CommandMapping> knownMappings() {
        return Collections.unmodifiableSet(new HashSet(this.inverseCommandMappings.keySet()));
    }

    public @NonNull CommandMapping registerNamespacedAlias(@NonNull CommandRegistrar<?> registrar, @Nullable PluginContainer container, @NonNull LiteralCommandNode<class_2168> rootArgument, String ... secondaryAliases) throws CommandFailedRegistrationException {
        String namespaced = rootArgument.getLiteral();
        String notnamespaced = namespaced.split(":")[1];
        ArrayList<String> otherAliases = new ArrayList<String>();
        otherAliases.add(notnamespaced);
        otherAliases.addAll(Arrays.asList(secondaryAliases));
        return this.registerAliasWithNamespacing(registrar, container, namespaced, otherAliases, null);
    }

    public @NonNull CommandMapping registerAlias(@NonNull CommandRegistrar<?> registrar, @NonNull PluginContainer container, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CommandTreeNode.Root parameterTree, @NonNull String primaryAlias, String ... secondaryAliases) throws CommandFailedRegistrationException {
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add(primaryAlias);
        Collections.addAll(aliases, secondaryAliases);
        String namespaced = container.metadata().id() + ":" + primaryAlias.toLowerCase(Locale.ROOT);
        return this.registerAliasWithNamespacing(registrar, container, namespaced, aliases, parameterTree);
    }

    public @NonNull CommandMapping registerAliasWithNamespacing(@NonNull CommandRegistrar<?> registrar, @Nullable PluginContainer container, @NonNull String namespacedAlias, @NonNull Collection<String> otherAliases, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CommandTreeNode.Root parameterTree) throws CommandFailedRegistrationException {
        String pluginId;
        if (namespacedAlias.contains(" ") || otherAliases.stream().anyMatch(x -> x.contains(" ") || x.contains(":"))) {
            throw new CommandFailedRegistrationException("Aliases may not contain spaces or colons.");
        }
        String string = pluginId = container == null ? "unknown" : container.metadata().id();
        if (!this.knownRegistrars.containsKey(GenericTypeReflector.erase((Type)registrar.type().handledType().getType()))) {
            throw new IllegalArgumentException(String.format("Plugin '%s' is trying to register command %s with unknown registrar %s", pluginId, namespacedAlias, registrar));
        }
        if (this.commandMappings.containsKey(namespacedAlias)) {
            throw new CommandFailedRegistrationException("The command alias " + namespacedAlias + " has already been registered for this plugin");
        }
        HashSet<String> aliases = new HashSet<String>();
        aliases.add(namespacedAlias);
        for (String secondaryAlias : otherAliases) {
            aliases.add(secondaryAlias.toLowerCase(Locale.ROOT));
        }
        aliases.removeIf(this.commandMappings::containsKey);
        SpongeConfigs.getCommon().get().commands.aliases.entrySet().stream().filter(x -> !((String)x.getValue()).equalsIgnoreCase(pluginId)).filter(x -> aliases.contains(x.getKey())).forEach(x -> aliases.remove(x.getKey()));
        if (aliases.isEmpty()) {
            throw new CommandFailedRegistrationException("No aliases could be registered for the supplied command.");
        }
        SpongeCommandMapping mapping = new SpongeCommandMapping(namespacedAlias, aliases, container, registrar);
        if (container != null) {
            this.pluginToCommandMap.put((Object)container, (Object)mapping);
        }
        aliases.forEach(key -> {
            this.commandMappings.put((String)key, mapping);
            this.inverseCommandMappings.put((Object)mapping, key);
        });
        if (parameterTree instanceof RootCommandTreeNode) {
            this.mappingToSuggestionNodes.put(mapping, (RootCommandTreeNode)parameterTree);
        }
        return mapping;
    }

    public @NonNull Collection<PluginContainer> plugins() {
        return ImmutableSet.copyOf((Collection)this.pluginToCommandMap.keySet());
    }

    public @NonNull Optional<CommandMapping> commandMapping(String alias) {
        return Optional.ofNullable((CommandMapping)this.commandMappings.get(alias.toLowerCase()));
    }

    public void updateCommandTreeForPlayer(@NonNull ServerPlayer player) {
        Objects.requireNonNull(player, "player");
        SpongeCommon.server().method_3734().method_9241((class_3222)player);
    }

    public <T> @NonNull Optional<CommandRegistrar<T>> registrar(@NonNull Class<T> type) {
        Objects.requireNonNull(type, "type");
        return Optional.ofNullable(this.knownRegistrars.get(type));
    }

    public <T> @NonNull Optional<CommandRegistrar<T>> registrar(@NonNull TypeToken<T> type) {
        Objects.requireNonNull(type, "type");
        return this.registrar(GenericTypeReflector.erase((Type)type.getType()));
    }

    public @NonNull CommandResult process(@NonNull String arguments) throws CommandException {
        CommandResult commandResult;
        block8: {
            CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();
            try {
                int result = this.getDispatcher().execute(arguments, (class_2168)CommandCause.create());
                frame.addContext(EventContextKeys.COMMAND, (Object)arguments);
                commandResult = CommandResult.builder().result(result).build();
                if (frame == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (frame != null) {
                        try {
                            frame.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CommandSyntaxException cse) {
                    throw new CommandException((Component)Component.text((String)cse.getMessage()), (Throwable)cse);
                }
            }
            frame.close();
        }
        return commandResult;
    }

    public abstract CommandResult processCommand(CommandCause var1, CommandMapping var2, String var3, String var4) throws CommandException;

    public <T extends Subject & Audience> @NonNull CommandResult process(@NonNull T subjectReceiver, @NonNull String arguments) throws CommandException {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            frame.addContext(EventContextKeys.SUBJECT, subjectReceiver);
            frame.addContext(EventContextKeys.AUDIENCE, (Object)subjectReceiver);
            CommandResult commandResult = this.process(arguments);
            return commandResult;
        }
    }

    public @NonNull CommandResult process(@NonNull Subject subject, @NonNull Audience receiver, @NonNull String arguments) throws CommandException {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            frame.addContext(EventContextKeys.SUBJECT, (Object)subject);
            frame.addContext(EventContextKeys.AUDIENCE, (Object)receiver);
            CommandResult commandResult = this.process(arguments);
            return commandResult;
        }
    }

    private void postExecuteCommandPostEvent(CommandCause cause, String originalArgs, String args, String originalCommand, String command, CommandResult result) {
        this.game.eventManager().post((Event)SpongeEventFactory.createExecuteCommandEventPost((Cause)cause.cause(), (String)originalArgs, (String)args, (String)originalCommand, (String)command, (CommandCause)cause, (CommandResult)result));
    }

    private void prettyPrintThrowableError(Throwable thr, String commandNoArgs, String args, CommandCause cause) {
        Object commandString = args != null && !args.isEmpty() ? commandNoArgs + " " + args : commandNoArgs;
        SpongeCommandMapping mapping = this.commandMappings.get(commandNoArgs.toLowerCase());
        PrettyPrinter prettyPrinter = new PrettyPrinter(100).add("Unexpected error occurred while executing command '%s'", commandString).centre().hr().addWrapped("While trying to run '%s', an error occurred that the command processor was not expecting. This usually indicates an error in the plugin that owns this command. Report this error to the plugin developer first - this is usually not a Sponge error.", commandString).hr().add().add("Command: %s", commandString).add("Owning Plugin: %s", mapping.plugin().map(x -> x.metadata().id()).orElse("unknown")).add("Owning Registrar: %s", mapping.registrar().getClass().getName()).add().add("Exception Details: ");
        if (thr instanceof SpongeCommandSyntaxException) {
            prettyPrinter.add(thr.getCause());
        } else {
            prettyPrinter.add(thr);
        }
        prettyPrinter.add().add("CommandCause details: ").addWrapped(cause.cause().toString(), new Object[0]).log(SpongeCommon.logger(), Level.ERROR);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public @NonNull List<CommandCompletion> complete(@NonNull String arguments) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            frame.addContext(EventContextKeys.COMMAND, (Object)arguments);
            String[] splitArg = arguments.split(" ", 2);
            String command = splitArg[0].toLowerCase();
            if (splitArg.length == 2) {
                SpongeCommandMapping mapping = this.commandMappings.get(command);
                if (mapping == null) {
                    List<CommandCompletion> list = Collections.emptyList();
                    return list;
                }
                frame.pushCause((Object)mapping);
                List list = mapping.registrar().complete(CommandCause.create(), (CommandMapping)mapping, command, splitArg[1]);
                return list;
            }
            List<CommandCompletion> list = this.commandMappings.keySet().stream().filter(x -> x.startsWith(command)).map(SpongeCommandCompletion::new).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public <T extends Subject & Audience> @NonNull List<CommandCompletion> complete(@NonNull T subjectReceiver, @NonNull String arguments) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            frame.addContext(EventContextKeys.SUBJECT, subjectReceiver);
            frame.addContext(EventContextKeys.AUDIENCE, (Object)subjectReceiver);
            List<CommandCompletion> list = this.complete(arguments);
            return list;
        }
    }

    public @NonNull List<CommandCompletion> complete(@NonNull Subject subject, @NonNull Audience receiver, @NonNull String arguments) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            frame.addContext(EventContextKeys.SUBJECT, (Object)subject);
            frame.addContext(EventContextKeys.AUDIENCE, (Object)receiver);
            List<CommandCompletion> list = this.complete(arguments);
            return list;
        }
    }

    public void init() {
        Cause cause = PhaseTracker.getInstance().currentCause();
        HashSet usedTokens = new HashSet();
        Sponge.game().registry((RegistryType)RegistryTypes.COMMAND_REGISTRAR_TYPE).streamEntries().forEach(entry -> {
            CommandRegistrarType type = (CommandRegistrarType)entry.value();
            TypeToken handledType = type.handledType();
            if (handledType == null) {
                SpongeCommon.logger().error("Registrar '{}' did not provide a handledType, skipping...", (Object)type.getClass());
            } else if (usedTokens.add(handledType)) {
                CommandRegistrar registrar = type.create((CommandManager.Mutable)this);
                this.knownRegistrars.put(GenericTypeReflector.erase((Type)type.handledType().getType()), registrar);
                if (registrar instanceof BrigadierCommandRegistrar) {
                    this.brigadierRegistrar = (BrigadierCommandRegistrar)registrar;
                } else if (registrar instanceof SpongeParameterizedCommandRegistrar) {
                    this.registerInternalCommands((SpongeParameterizedCommandRegistrar)registrar);
                }
                this.game.eventManager().post(this.createEvent(cause, this.game, registrar));
            } else {
                SpongeCommon.logger().warn("Command type '{}' has already been collected, skipping request from {}", (Object)handledType.toString(), (Object)type.getClass());
            }
        });
        if (this.brigadierRegistrar == null) {
            throw new IllegalStateException("Brigadier registrar was not detected");
        }
    }

    private void registerInternalCommands(CommandRegistrar<Command.Parameterized> registrar) {
        try {
            registrar.register(((Launch)Launch.instance()).commonPlugin(), (Object)((SpongeCommand)this.spongeCommand.get()).createSpongeCommand(), "sponge", new String[0]);
        }
        catch (CommandFailedRegistrationException ex) {
            throw new RuntimeException("Failed to create root Sponge command!", ex);
        }
        try {
            PaginationService paginationService = Sponge.serviceProvider().paginationService();
            if (paginationService instanceof SpongePaginationService) {
                registrar.register(((Launch)Launch.instance()).commonPlugin(), (Object)((SpongePaginationService)paginationService).createPaginationCommand(), "pagination", new String[]{"page"});
            }
        }
        catch (CommandFailedRegistrationException ex) {
            throw new RuntimeException("Failed to create pagination command!", ex);
        }
        registrar.register(((Launch)Launch.instance()).commonPlugin(), (Object)CallbackCommand.INSTANCE.createCommand(), "callback", new String[0]);
    }

    public Collection<CommandNode<class_2172>> getNonBrigadierSuggestions(CommandCause cause) {
        ArrayList<CommandNode<class_2172>> suggestions = new ArrayList<CommandNode<class_2172>>();
        for (Map.Entry<SpongeCommandMapping, RootCommandTreeNode> entry : this.mappingToSuggestionNodes.entrySet()) {
            SpongeCommandMapping mapping = entry.getKey();
            CommandNode node = entry.getValue().createArgumentTree(cause, (LiteralArgumentBuilder<class_2172>)LiteralArgumentBuilder.literal((String)mapping.primaryAlias()));
            if (node == null) continue;
            Command executableCommand = node.getCommand();
            CommandNode toRedirectTo = node.getRedirect() == null ? node : node.getRedirect();
            suggestions.add((CommandNode<class_2172>)node);
            for (String alias : mapping.allAliases()) {
                if (alias.equals(mapping.primaryAlias())) continue;
                suggestions.add((CommandNode<class_2172>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alias).executes(executableCommand)).redirect(toRedirectTo)).build());
            }
        }
        return suggestions;
    }

    public Collection<String> getAliasesThatStartWithForCause(CommandCause cause, String startingText) {
        String toCompare = startingText.toLowerCase(Locale.ROOT);
        ArrayList<String> aliases = new ArrayList<String>();
        Object2BooleanOpenHashMap testedMappings = new Object2BooleanOpenHashMap();
        for (Map.Entry<String, SpongeCommandMapping> mappingEntry : this.commandMappings.entrySet()) {
            if (!mappingEntry.getKey().startsWith(toCompare) || !testedMappings.computeBooleanIfAbsent((Object)mappingEntry.getValue(), mapping -> mapping.registrar().canExecute(cause, mapping))) continue;
            aliases.add(toCompare);
        }
        return aliases;
    }

    public Collection<String> getAliasesForCause(CommandCause cause) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (SpongeCommandMapping mapping : this.inverseCommandMappings.keySet()) {
            if (!mapping.registrar().canExecute(cause, (CommandMapping)mapping)) continue;
            aliases.addAll(this.inverseCommandMappings.get((Object)mapping));
        }
        return aliases;
    }

    private <C, R extends CommandRegistrar<C>> RegisterCommandEventImpl<C, R> createEvent(Cause cause, Game game, R registrar) {
        return new RegisterCommandEventImpl(cause, game, registrar);
    }

    public int handleException(String originalCommand, String originalArgs, CommandCause cause, Throwable ex, String command, String args) throws CommandSyntaxException {
        Component text;
        if (ex instanceof SpongeCommandResultException) {
            SpongeCommandResultException scre = (SpongeCommandResultException)((Object)ex);
            CommandResult result = scre.result();
            this.postExecuteCommandPostEvent(cause, originalArgs, args, originalCommand, command, result);
            cause.sendMessage(Identity.nil(), result.errorMessage().map(x -> x.colorIfAbsent((TextColor)NamedTextColor.RED)).orElseGet(() -> ((TextComponent.Builder)Component.text().content(String.format("An empty error result was returned while executing the command \"%s\"", command)).color((TextColor)NamedTextColor.RED)).build()));
            return 0;
        }
        if (ex instanceof CommandException) {
            CommandException ce = (CommandException)ex;
            CommandResult result = CommandResult.error((Component)ce.componentMessage());
            this.postExecuteCommandPostEvent(cause, originalArgs, args, originalCommand, command, result);
            if (ALWAYS_PRINT_STACKTRACES) {
                this.prettyPrintThrowableError(ex, command, args, cause);
            }
            throw ERROR_UNHANDLED_EXCEPTION.create((Object)SpongeAdventure.asVanilla(ce.componentMessage()));
        }
        if (ex instanceof CommandSyntaxException) {
            CommandSyntaxException cse = (CommandSyntaxException)ex;
            CommandResult result = CommandResult.error((Component)SpongeAdventure.asAdventure(cse.getRawMessage()));
            this.postExecuteCommandPostEvent(cause, originalArgs, args, originalCommand, command, result);
            if (ALWAYS_PRINT_STACKTRACES) {
                this.prettyPrintThrowableError(ex, command, args, cause);
            }
            throw cse;
        }
        this.prettyPrintThrowableError(ex, command, args, cause);
        Object excBuilder = ex instanceof ComponentMessageThrowable ? ((text = ((ComponentMessageThrowable)ex).componentMessage()) == null ? Component.text((String)"null") : text) : Component.text((String)String.valueOf(ex.getMessage()));
        if (cause.hasPermission("sponge.debug.hover-stacktrace")) {
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            excBuilder = excBuilder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)writer.toString().replace("\t", "    ").replace("\r\n", "\n").replace("\r", "\n"))));
        }
        BuildableComponent error = ((TextComponent.Builder)Component.text().content("Unexpected error occurred while executing command: ").append((Component)excBuilder)).build();
        this.postExecuteCommandPostEvent(cause, originalArgs, args, originalCommand, command, CommandResult.error((Component)error));
        throw ERROR_UNHANDLED_EXCEPTION.create((Object)SpongeAdventure.asVanilla((Component)error));
    }
}

