/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueCompleter;
import org.spongepowered.api.command.parameter.managed.ValueParameterModifier;
import org.spongepowered.api.command.parameter.managed.ValueParser;
import org.spongepowered.api.command.parameter.managed.ValueUsage;
import org.spongepowered.common.command.parameter.SpongeParameterKey;
import org.spongepowered.common.command.parameter.SpongeParameterValue;
import org.spongepowered.common.util.Preconditions;

public final class SpongeParameterValueBuilder<T>
implements Parameter.Value.Builder<T> {
    private static final ValueCompleter EMPTY_COMPLETER = (context, currentInput) -> Collections.emptyList();
    private final Type typeToken;
    private final List<ValueParser<? extends T>> parsers = new ArrayList<ValueParser<? extends T>>();
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Parameter.Key<T> key;
    private @Nullable ValueCompleter completer;
    private @Nullable ValueUsage usage;
    private @Nullable Predicate<CommandCause> executionRequirements;
    private boolean consumesAll;
    private boolean isOptional;
    private boolean terminal;
    private @Nullable ValueParameterModifier<T> modifier;

    public SpongeParameterValueBuilder(@NonNull Type token) {
        this.typeToken = token;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Value.Builder<T> key(@NonNull String key) {
        return this.key(new SpongeParameterKey(key, this.typeToken));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Value.Builder<T> key(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Key<T> key) {
        Objects.requireNonNull(key, "The key cannot be null");
        this.key = key;
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Value.Builder<T> addParser(@NonNull ValueParser<? extends T> parser) {
        this.parsers.add(Objects.requireNonNull(parser, "The ValueParser may not be null"));
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Value.Builder<T> completer(@Nullable ValueCompleter completer) {
        this.completer = completer;
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Value.Builder<T> modifier(@Nullable ValueParameterModifier<T> modifier) {
        this.modifier = modifier;
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Value.Builder<T> usage(@Nullable ValueUsage usage) {
        this.usage = usage;
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Value.Builder<T> requiredPermission(@Nullable String permission) {
        if (permission == null) {
            return this.requirements(null);
        }
        return this.requirements(commandCause -> commandCause.subject().hasPermission(permission));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Value.Builder<T> requirements(@Nullable Predicate<CommandCause> executionRequirements) {
        this.executionRequirements = executionRequirements;
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Value.Builder<T> consumeAllRemaining() {
        this.consumesAll = true;
        return this.terminal();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Value.Builder<T> optional() {
        this.isOptional = true;
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Value.Builder<T> terminal() {
        this.terminal = true;
        return this;
    }

    public @NonNull SpongeParameterValue<T> build() throws IllegalStateException {
        ValueCompleter completer;
        Preconditions.checkState(this.key != null, "The command key may not be null");
        Preconditions.checkState(!this.parsers.isEmpty(), "There must be parsers");
        ImmutableList.Builder parsersBuilder = ImmutableList.builder();
        parsersBuilder.addAll(this.parsers);
        if (this.completer != null) {
            completer = this.completer;
        } else {
            ImmutableList.Builder completersBuilder = ImmutableList.builder();
            for (ValueParser<? extends T> valueParser : this.parsers) {
                if (!(valueParser instanceof ValueCompleter)) continue;
                completersBuilder.add((Object)((ValueCompleter)valueParser));
            }
            ImmutableList completers = completersBuilder.build();
            completer = completers.isEmpty() ? EMPTY_COMPLETER : (completers.size() == 1 ? (ValueCompleter)completers.get(0) : (context, currentInput) -> {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (ValueCompleter valueCompleter : completers) {
                    builder.addAll((Iterable)valueCompleter.complete(context, currentInput));
                }
                return builder.build();
            });
        }
        return new SpongeParameterValue<T>(parsersBuilder.build(), completer, this.usage, this.executionRequirements == null ? commandCause -> true : this.executionRequirements, this.key, this.isOptional, this.consumesAll, this.terminal, this.modifier);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Parameter.Value.Builder<T> reset() {
        this.key = null;
        this.parsers.clear();
        this.completer = null;
        this.usage = null;
        this.isOptional = false;
        this.consumesAll = false;
        return this;
    }
}

