/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.class_124;
import net.minecraft.class_2177;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.accessor.ChatFormattingAccessor;
import org.spongepowered.common.command.SpongeCommandCompletion;
import org.spongepowered.common.command.brigadier.argument.ResourceKeyedArgumentValueParser;
import org.spongepowered.common.util.Constants;

public final class SpongeColorValueParameter
extends ResourceKeyedArgumentValueParser<Color> {
    private static final Component EXCEPTION_MESSAGE = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("The color is not in one of the expected formats:").append((Component)Component.newline())).append((Component)Component.text((String)"* Named color (such as \"black\")"))).append((Component)Component.newline())).append((Component)Component.text((String)"* Hex encoded color consisting of six digits (such as \"000000\")"))).append((Component)Component.newline())).append((Component)Component.text((String)"* Hex encoded color, surrounded by double quotes, starting with # and consisting of six digits (such as \"#000000\")"))).append((Component)Component.newline())).append((Component)Component.text((String)"* Comma separated RGB color, surrounded by double quotes, with values from 0 to 255 (such as \"0,128,255\")"))).build();
    private static final Pattern HEX_CODE = Pattern.compile("(#?)(?<colorcode>[0-9A-Fa-f]{6})");
    private static final Collection<String> CHAT_FORMATTING_NAMES = Arrays.stream(class_124.values()).filter(x -> x.method_543()).map(x -> x.method_537().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
    private final class_2177 colorArgumentType = class_2177.method_9276();

    public SpongeColorValueParameter(ResourceKey key) {
        super(key);
    }

    @Override
    public CompletableFuture<Suggestions> listSuggestions(CommandContext<?> context, SuggestionsBuilder builder) {
        return this.colorArgumentType.listSuggestions(context, builder);
    }

    public @NonNull Optional<? extends Color> parseValue(@NonNull CommandCause cause, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ArgumentReader.Mutable reader) throws ArgumentParseException {
        ArgumentReader.Immutable state = reader.immutable();
        try {
            class_124 formatting = this.colorArgumentType.method_9279((StringReader)reader);
            Integer colorCode = ((ChatFormattingAccessor)formatting).accessor$color();
            if (colorCode != null) {
                return Optional.of(Color.ofRgb((int)colorCode));
            }
            throw reader.createException((Component)Component.text().content(String.format("%s is not a valid color", formatting.method_537())).build());
        }
        catch (CommandSyntaxException formatting) {
            Optional<Color> result;
            String[] rgb;
            reader.setState((ArgumentReader)state);
            String string = reader.parseString();
            Matcher matcher = HEX_CODE.matcher(string);
            if (matcher.matches()) {
                try {
                    return Optional.of(Color.ofRgb((int)Integer.parseInt(matcher.group("colorcode"), 16)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((rgb = string.split(",", 3)).length == 3 && (result = this.checkIntConversion(rgb)).isPresent()) {
                return result;
            }
            throw reader.createException(EXCEPTION_MESSAGE);
        }
    }

    public List<CommandCompletion> complete(CommandCause context, String currentInput) {
        return CHAT_FORMATTING_NAMES.stream().filter(x -> x.startsWith(currentInput.toLowerCase(Locale.ROOT))).map(SpongeCommandCompletion::new).collect(Collectors.toList());
    }

    private Optional<Color> checkIntConversion(String[] entry) {
        try {
            int r = Integer.parseInt(entry[0]);
            int g = Integer.parseInt(entry[1]);
            int b = Integer.parseInt(entry[2]);
            if (this.isInRange(r) && this.isInRange(g) && this.isInRange(b)) {
                return Optional.of(Color.ofRgb((int)r, (int)g, (int)b));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    private boolean isInRange(int i) {
        return i >= 0 && i <= 255;
    }

    @Override
    public List<ArgumentType<?>> getClientCompletionArgumentType() {
        return Collections.singletonList(Constants.Command.STANDARD_STRING_ARGUMENT_TYPE);
    }
}

