/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.common.command.brigadier.argument.ResourceKeyedArgumentValueParser;

public final class SpongeDateTimeValueParameter
extends ResourceKeyedArgumentValueParser<LocalDateTime> {
    public SpongeDateTimeValueParameter(ResourceKey key) {
        super(key);
    }

    public List<CommandCompletion> complete(@NonNull CommandCause context, @NonNull String currentInput) {
        return Collections.emptyList();
    }

    public @NonNull Optional<? extends LocalDateTime> parseValue(@NonNull CommandCause cause, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ArgumentReader.Mutable reader) throws ArgumentParseException {
        String date = reader.parseString();
        try {
            return Optional.of(LocalDateTime.parse(date));
        }
        catch (DateTimeParseException ex) {
            try {
                return Optional.of(LocalDateTime.of(LocalDate.now(), LocalTime.parse(date)));
            }
            catch (DateTimeParseException ex2) {
                try {
                    return Optional.of(LocalDateTime.of(LocalDate.parse(date), LocalTime.MIDNIGHT));
                }
                catch (DateTimeParseException ex3) {
                    throw reader.createException((Component)Component.text((String)"Invalid date-time!"));
                }
            }
        }
    }
}

