/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.multi;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.command.parameter.Parameter;

public abstract class SpongeMultiParameter
implements Parameter.Multi {
    private final List<Parameter> parameterCandidates;
    private final boolean isOptional;
    private final boolean isTerminal;

    protected SpongeMultiParameter(List<Parameter> parameterCandidates, boolean isOptional, boolean isTerminal) {
        this.parameterCandidates = ImmutableList.copyOf(parameterCandidates);
        this.isOptional = isOptional;
        this.isTerminal = isTerminal;
    }

    public List<Parameter> childParameters() {
        return this.parameterCandidates.stream().sorted((x1, x2) -> {
            boolean firstIs = x1 instanceof Parameter.Subcommand;
            boolean secondIs = x2 instanceof Parameter.Subcommand;
            if (firstIs != secondIs) {
                if (firstIs) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }).collect(Collectors.toList());
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isTerminal() {
        return this.isTerminal;
    }
}

