/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.registrar;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.leangen.geantyref.TypeToken;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.minecraft.class_2168;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.manager.CommandFailedRegistrationException;
import org.spongepowered.api.command.manager.CommandManager;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.command.registrar.CommandRegistrar;
import org.spongepowered.api.command.registrar.CommandRegistrarType;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.command.SpongeCommandCompletion;
import org.spongepowered.common.command.brigadier.dispatcher.SpongeCommandDispatcher;
import org.spongepowered.common.command.brigadier.tree.SpongeLiteralCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongePermissionWrappedLiteralCommandNode;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.command.registrar.BrigadierBasedRegistrar;
import org.spongepowered.common.command.registrar.SpongeCommandRegistrarType;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.plugin.PluginContainer;

public final class BrigadierCommandRegistrar
implements BrigadierBasedRegistrar<LiteralArgumentBuilder<class_2168>> {
    public static final CommandRegistrarType<LiteralArgumentBuilder<class_2168>> TYPE = new SpongeCommandRegistrarType<LiteralArgumentBuilder<class_2168>>(new TypeToken<LiteralArgumentBuilder<class_2168>>(){}, BrigadierCommandRegistrar::new);
    private final SpongeCommandManager manager;
    private SpongeCommandDispatcher dispatcher;

    public BrigadierCommandRegistrar(CommandManager.Mutable manager) {
        this.manager = (SpongeCommandManager)manager;
        this.dispatcher = new SpongeCommandDispatcher(this.manager);
    }

    @Override
    public SpongeCommandDispatcher dispatcher() {
        return this.dispatcher;
    }

    public LiteralCommandNode<class_2168> register(LiteralArgumentBuilder<class_2168> command) {
        @Nullable PluginContainer container = PhaseTracker.getInstance().currentCause().first(PluginContainer.class).orElse(null);
        return (LiteralCommandNode)this.registerInternal(this, container, this.applyNamespace(container, command, false), new String[0], true).second();
    }

    public @NonNull CommandRegistrarType<LiteralArgumentBuilder<class_2168>> type() {
        return TYPE;
    }

    public @NonNull CommandMapping register(@NonNull PluginContainer container, @NonNull LiteralArgumentBuilder<class_2168> command, @NonNull String primaryAlias, String ... secondaryAliases) throws CommandFailedRegistrationException {
        return (CommandMapping)this.register(container, command, secondaryAliases).first();
    }

    public Tuple<CommandMapping, LiteralCommandNode<class_2168>> register(PluginContainer container, LiteralArgumentBuilder<class_2168> command, String ... secondaryAliases) {
        return this.registerInternal(this, container, this.applyNamespace(container, command, true), secondaryAliases, false);
    }

    private Tuple<CommandMapping, LiteralCommandNode<class_2168>> registerInternal(CommandRegistrar<?> registrar, @Nullable PluginContainer container, LiteralCommandNode<class_2168> namespacedCommand, String[] secondaryAliases, boolean allowDuplicates) {
        String requestedAlias = namespacedCommand.getLiteral();
        Optional<CommandMapping> existingMapping = this.manager.commandMapping(requestedAlias);
        if (allowDuplicates && existingMapping.isPresent()) {
            this.dispatcher.register(namespacedCommand);
            return Tuple.of((Object)existingMapping.get(), namespacedCommand);
        }
        CommandMapping mapping = this.manager.registerNamespacedAlias(registrar, container, namespacedCommand, secondaryAliases);
        this.dispatcher.register(namespacedCommand);
        for (String alias : mapping.allAliases()) {
            if (alias.equals(namespacedCommand.getLiteral())) continue;
            LiteralArgumentBuilder redirecting = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alias).executes(namespacedCommand.getCommand())).requires(namespacedCommand.getRequirement());
            if (namespacedCommand.getRedirect() == null) {
                redirecting.redirect(namespacedCommand);
            } else {
                redirecting.forward(namespacedCommand.getRedirect(), namespacedCommand.getRedirectModifier(), namespacedCommand.isFork());
            }
            this.dispatcher.register(namespacedCommand instanceof SpongePermissionWrappedLiteralCommandNode ? new SpongePermissionWrappedLiteralCommandNode((LiteralArgumentBuilder<class_2168>)redirecting) : redirecting.build());
        }
        return Tuple.of((Object)mapping, namespacedCommand);
    }

    public @NonNull CommandResult process(@NonNull CommandCause cause, @NonNull CommandMapping mapping, @NonNull String command, @NonNull String arguments) throws CommandException {
        return this.process(cause, mapping, command, this.dispatcher.parse(this.createCommandString(command, arguments), (class_2168)cause));
    }

    @Override
    public @NonNull CommandResult process(@NonNull CommandCause cause, @NonNull CommandMapping mapping, @NonNull String command, @NonNull ParseResults<class_2168> arguments) throws CommandException {
        try {
            int result = this.dispatcher.execute(arguments);
            return CommandResult.builder().result(result).build();
        }
        catch (CommandSyntaxException e) {
            throw new CommandException((Component)Component.text((String)e.getMessage()), (Throwable)e);
        }
    }

    public List<CommandCompletion> complete(@NonNull CommandCause cause, @NonNull CommandMapping mapping, @NonNull String command, @NonNull String arguments) {
        CompletableFuture suggestionsCompletableFuture = this.dispatcher.getCompletionSuggestions(this.dispatcher.parse(this.createCommandString(command, arguments), (class_2168)cause, true));
        return ((Suggestions)suggestionsCompletableFuture.join()).getList().stream().map(SpongeCommandCompletion::from).collect(Collectors.toList());
    }

    public @NonNull Optional<Component> help(@NonNull CommandCause cause, @NonNull CommandMapping mapping) {
        CommandNode node = this.dispatcher.findNode(Collections.singletonList(mapping.primaryAlias()));
        if (node != null) {
            return Optional.of(Component.text((String)this.dispatcher.getSmartUsage(node, (class_2168)cause).toString()));
        }
        return Optional.empty();
    }

    public boolean canExecute(CommandCause cause, CommandMapping mapping) {
        return this.dispatcher.findNode(Collections.singletonList(mapping.primaryAlias())).getRequirement().test((class_2168)cause);
    }

    public SpongeCommandDispatcher getDispatcher() {
        return this.dispatcher;
    }

    private String createCommandString(String command, String argument) {
        if (argument.isEmpty()) {
            return command;
        }
        return command + " " + argument;
    }

    private LiteralCommandNode<class_2168> applyNamespace(PluginContainer pluginContainer, LiteralArgumentBuilder<class_2168> builder, boolean isSpongeAware) {
        if (builder.getLiteral().contains(":") || builder.getLiteral().contains(" ")) {
            throw new IllegalArgumentException("The literal must not contain a colon or a space.");
        }
        String modid = pluginContainer != null ? pluginContainer.metadata().id() : "unknown";
        LiteralArgumentBuilder replacementBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)(modid + ":" + builder.getLiteral())).forward(builder.getRedirect(), builder.getRedirectModifier(), builder.isFork())).executes(builder.getCommand())).requires(builder.getRequirement());
        for (CommandNode node : builder.getArguments()) {
            replacementBuilder.then(node);
        }
        if (isSpongeAware) {
            return new SpongeLiteralCommandNode((LiteralArgumentBuilder<class_2168>)replacementBuilder);
        }
        return new SpongePermissionWrappedLiteralCommandNode((LiteralArgumentBuilder<class_2168>)replacementBuilder);
    }
}

