/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.sponge;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.command.parameter.managed.clientcompletion.ClientCompletionType;
import org.spongepowered.api.command.parameter.managed.clientcompletion.ClientCompletionTypes;
import org.spongepowered.common.command.SpongeCommandCompletion;

public final class CommandAliasesParameter
implements ValueParameter<CommandMapping> {
    public List<CommandCompletion> complete(CommandContext context, String input) {
        return Sponge.game().server().commandManager().knownAliases().stream().filter(x -> x.startsWith(input)).map(SpongeCommandCompletion::new).collect(Collectors.toList());
    }

    public Optional<? extends CommandMapping> parseValue(Parameter.Key<? super CommandMapping> parameterKey, ArgumentReader.Mutable reader, CommandContext.Builder context) throws ArgumentParseException {
        Optional mapping;
        Object alias = reader.parseString().toLowerCase(Locale.ROOT);
        if (reader.canRead() && reader.peekCharacter() == ':') {
            alias = (String)alias + reader.parseChar() + reader.parseUnquotedString();
        }
        if ((mapping = Sponge.game().server().commandManager().commandMapping((String)alias)).isPresent()) {
            return mapping;
        }
        throw reader.createException((Component)Component.text((String)("A command with alias " + (String)alias + " does not exist.")));
    }

    public List<ClientCompletionType> clientCompletionType() {
        return Collections.singletonList((ClientCompletionType)ClientCompletionTypes.RESOURCE_KEY.get());
    }
}

