/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.sponge;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.common.applaunch.plugin.DummyPluginContainer;
import org.spongepowered.common.command.SpongeCommandCompletion;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;

public final class FilteredPluginContainerParameter
implements ValueParameter<PluginContainer> {
    private final Map<String, PluginContainer> validPluginContainers = FilteredPluginContainerParameter.getValidContainers();
    private final List<CommandCompletion> completions = FilteredPluginContainerParameter.createCompletions(this.validPluginContainers);

    private static Map<String, PluginContainer> getValidContainers() {
        return ((Launch)Launch.instance()).pluginManager().plugins().stream().filter(x -> !(x instanceof DummyPluginContainer)).collect(Collectors.toMap(x -> x.metadata().id(), x -> x));
    }

    private static List<CommandCompletion> createCompletions(Map<String, PluginContainer> pluginContainers) {
        return pluginContainers.entrySet().stream().map(entry -> {
            TextComponent tooltip = Component.text((String)((PluginContainer)entry.getValue()).metadata().name().orElse((String)entry.getKey()));
            return new SpongeCommandCompletion((String)entry.getKey(), (Component)tooltip);
        }).collect(Collectors.toList());
    }

    public List<CommandCompletion> complete(CommandContext context, String currentInput) {
        return this.completions.stream().filter(x -> x.completion().startsWith(currentInput.toLowerCase(Locale.ROOT))).collect(Collectors.toList());
    }

    public Optional<? extends PluginContainer> parseValue(Parameter.Key<? super PluginContainer> parameterKey, ArgumentReader.Mutable reader, CommandContext.Builder context) throws ArgumentParseException {
        String id = reader.parseString();
        PluginContainer pluginContainer = this.validPluginContainers.get(id);
        if (pluginContainer != null) {
            return Optional.of(pluginContainer);
        }
        throw reader.createException((Component)Component.text((String)("Could not find valid plugin to refresh with ID \"" + id + "\"")));
    }
}

