/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.sponge;

import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilderApplicable;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.LinearComponents;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.util.RGBLike;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_5562;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Game;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.adventure.SpongeComponents;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.CommonParameters;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueParser;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.lifecycle.RefreshGameEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.blockray.RayTrace;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.level.LevelAccessor;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.command.sponge.CommandAliasesParameter;
import org.spongepowered.common.command.sponge.FilteredPluginContainerParameter;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.core.SpongeConfigs;
import org.spongepowered.common.event.manager.SpongeEventManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.util.JvmUtil;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.plugin.metadata.model.PluginContributor;

public class SpongeCommand {
    protected static final String INDENT = "    ";
    protected static final String LONG_INDENT = "        ";
    protected static final Component INDENT_COMPONENT = Component.text((String)"    ");
    protected static final Component LONG_INDENT_COMPONENT = Component.text((String)"        ");
    protected static final DecimalFormat THREE_DECIMAL_DIGITS_FORMATTER = new DecimalFormat("########0.000");
    protected static final TextColor GREEN = TextColor.color((int)4376386);
    protected static final TextColor MINT = TextColor.color((int)6924407);
    protected static final TextColor LIGHT_BLUE = TextColor.color((int)6206426);
    protected static final TextColor YELLOW = TextColor.color((int)0xDEDE00);
    protected static final TextColor ORANGE = TextColor.color((int)14902532);
    protected static final TextColor RED = TextColor.color((int)13058626);
    private static final Component EMPTY = Component.text((String)"Empty", (TextColor)TextColor.color((RGBLike)RED));
    private final Parameter.Key<PluginContainer> pluginContainerKey = Parameter.key((String)"plugin", PluginContainer.class);
    private final Parameter.Key<CommandMapping> commandMappingKey = Parameter.key((String)"command", CommandMapping.class);
    private final Parameter.Key<ServerWorld> worldKey = Parameter.key((String)"world", ServerWorld.class);
    private @Nullable Component versionText = null;

    public Command.Parameterized createSpongeCommand() {
        Command.Parameterized auditCommand = Command.builder().permission("sponge.command.audit").shortDescription((Component)Component.text((String)"Audit mixin classes for implementation")).executor(this::auditSubcommandExecutor).build();
        Command.Parameterized chunksCommand = this.chunksSubcommand();
        Command.Parameterized heapCommand = Command.builder().permission("sponge.command.heap").shortDescription((Component)Component.text((String)"Dump live JVM heap")).executor(this::heapSubcommandExecutor).build();
        Command.Parameterized pluginsReloadCommand = Command.builder().permission("sponge.command.plugins.refresh").shortDescription((Component)Component.text((String)"Refreshes supported plugins, typically causing plugin configuration reloads.")).addParameter((Parameter)Parameter.builder(PluginContainer.class).optional().addParser((ValueParser)new FilteredPluginContainerParameter()).key(this.pluginContainerKey).build()).executor(this::pluginsRefreshSubcommandExecutor).build();
        Command.Parameterized pluginsListCommand = Command.builder().permission("sponge.command.plugins.list").shortDescription((Component)Component.text((String)"Lists all currently installed plugins.")).executor(this::pluginsListSubcommand).build();
        Command.Parameterized pluginsInfoCommand = Command.builder().permission("sponge.command.plugins.info").shortDescription((Component)Component.text((String)"Displays information about a specific plugin.")).addParameter((Parameter)Parameter.plugin().key(this.pluginContainerKey).build()).executor(this::pluginsInfoSubcommand).build();
        Command.Parameterized pluginsCommand = Command.builder().addChild(pluginsReloadCommand, new String[]{"refresh"}).addChild(pluginsListCommand, new String[]{"list"}).addChild(pluginsInfoCommand, new String[]{"info"}).build();
        Command.Parameterized tpsCommand = Command.builder().permission("sponge.command.tps").shortDescription((Component)Component.text((String)"Provides TPS (ticks per second) data for loaded worlds.")).executor(this::tpsExecutor).build();
        Command.Parameterized versionCommand = Command.builder().permission("sponge.command.version").shortDescription((Component)Component.text((String)"Display Sponge's current version")).executor(this::versionExecutor).build();
        Command.Parameterized whichCommand = Command.builder().permission("sponge.command.which").addParameter((Parameter)Parameter.builder(CommandMapping.class).key(this.commandMappingKey).addParser((ValueParser)new CommandAliasesParameter()).build()).shortDescription((Component)Component.text((String)"Find the plugin that owns a specific command")).executor(this::whichExecutor).build();
        Command.Parameterized reloadGlobalCommand = Command.builder().permission("sponge.command.reload.global").shortDescription((Component)Component.text((String)"Reload Sponge's common configuration")).executor(this::reloadGlobalExecutor).build();
        Command.Parameterized reloadWorldCommand = Command.builder().permission("sponge.command.reload.world").addParameter((Parameter)Parameter.world().key(this.worldKey).build()).shortDescription((Component)Component.text((String)"Reload Sponge's configuration for a single world")).executor(this::reloadWorldExecutor).build();
        Command.Parameterized reloadCommand = Command.builder().addChild(reloadGlobalCommand, new String[]{"global"}).addChild(reloadWorldCommand, new String[]{"world"}).build();
        Command.Parameterized infoCommand = this.infoSubcommand();
        Command.Builder commandBuilder = Command.builder().permission("sponge.command.root").executor(this::rootCommand).addChild(auditCommand, new String[]{"audit"}).addChild(chunksCommand, new String[]{"chunks"}).addChild(heapCommand, new String[]{"heap"}).addChild(pluginsCommand, new String[]{"plugins"}).addChild(tpsCommand, new String[]{"tps"}).addChild(versionCommand, new String[]{"version"}).addChild(whichCommand, new String[]{"which"}).addChild(reloadCommand, new String[]{"reload"}).addChild(infoCommand, new String[]{"info"});
        this.additionalActions(commandBuilder);
        return commandBuilder.build();
    }

    protected void additionalActions(Command.Builder builder) {
    }

    private @NonNull CommandResult rootCommand(CommandContext context) {
        String subcommands;
        PluginContainer platformPlugin = ((Launch)Launch.instance()).platformPlugin();
        PluginContainer apiPlugin = ((Launch)Launch.instance()).apiPlugin();
        PluginContainer minecraftPlugin = ((Launch)Launch.instance()).minecraftPlugin();
        context.sendMessage(Identity.nil(), (Component)((TextComponent.Builder)Component.text().append(new Component[]{Component.text((String)"SpongePowered", (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.space()), Component.text((String)("Plugin Platform (running on Minecraft " + String.valueOf(minecraftPlugin.metadata().version()) + ")")), Component.newline(), Component.text((String)((String)apiPlugin.metadata().name().get() + ": " + String.valueOf(apiPlugin.metadata().version()))), Component.newline(), Component.text((String)((String)platformPlugin.metadata().name().get() + ": " + String.valueOf(platformPlugin.metadata().version())))})).build());
        Optional parameterized = context.executedCommand();
        if (parameterized.isPresent() && !(subcommands = ((Command.Parameterized)parameterized.get()).subcommands().stream().filter(x -> x.command().canExecute(context.cause())).flatMap(x -> x.aliases().stream()).collect(Collectors.joining(", "))).isEmpty()) {
            context.sendMessage(Identity.nil(), (Component)((TextComponent.Builder)Component.text().append(new Component[]{Component.newline(), Component.text((String)"Available subcommands:"), Component.newline(), Component.text((String)subcommands)})).build());
        }
        return CommandResult.success();
    }

    private @NonNull CommandResult auditSubcommandExecutor(CommandContext context) {
        SpongeCommon.logger().info("Starting Mixin Audit");
        ((Launch)Launch.instance()).auditMixins();
        return CommandResult.success();
    }

    private CompletableFuture<Component> userIdToComponent(@Nullable UUID uuid) {
        if (uuid != null) {
            return Sponge.server().userManager().load(uuid).handleAsync((userOptional, throwable) -> {
                if (throwable != null) {
                    return EMPTY;
                }
                return userOptional.map(user -> ((Component)user.require(Keys.DISPLAY_NAME)).color(TextColor.color((RGBLike)LIGHT_BLUE)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)user.uniqueId().toString())))).orElse(EMPTY);
            }, (Executor)SpongeCommon.server());
        }
        return CompletableFuture.completedFuture(EMPTY);
    }

    private Command.Parameterized infoSubcommand() {
        Command.Parameterized blockInfoAtCommand = Command.builder().addParameter((Parameter)CommonParameters.LOCATION_ONLINE_ONLY).executor(context -> {
            ServerLocation serverLocation = (ServerLocation)context.requireOne(CommonParameters.LOCATION_ONLINE_ONLY);
            CompletableFuture<Component> creator = this.userIdToComponent(serverLocation.get(Keys.CREATOR).orElse(null));
            CompletableFuture<Component> notifier = this.userIdToComponent(serverLocation.get(Keys.NOTIFIER).orElse(null));
            CompletableFuture.allOf(creator, notifier).thenAcceptAsync(x -> context.sendMessage(Identity.nil(), (Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Block Info: ").color(TextColor.color((RGBLike)GREEN))).append(Component.text((String)serverLocation.blockPosition().toString()).hoverEvent((HoverEventSource)ItemStack.builder().fromBlockState(serverLocation.block()).build().asImmutable()))).append((Component)Component.newline())).append((Component)Component.text((String)"Creator: ", (TextColor)TextColor.color((RGBLike)MINT)))).append((Component)creator.join())).append((Component)Component.newline())).append((Component)Component.text((String)"Notifier: ", (TextColor)TextColor.color((RGBLike)MINT)))).append((Component)notifier.join())).build()), (Executor)SpongeCommon.server());
            return CommandResult.success();
        }).build();
        Command.Parameterized blockInfoLookingAt = Command.builder().executor(context -> {
            if (!(context.cause().root() instanceof Player)) {
                return CommandResult.error((Component)Component.text((String)"Player required", (TextColor)TextColor.color((RGBLike)RED)));
            }
            Player player = (Player)context.cause().root();
            return RayTrace.block().sourceEyePosition((Living)player).direction((Living)player).select(RayTrace.nonAir()).limit(10).execute().map(result -> {
                LocatableBlock locatableBlock = (LocatableBlock)result.selectedObject();
                CompletableFuture<Component> creator = this.userIdToComponent(locatableBlock.world().get(locatableBlock.blockPosition(), Keys.CREATOR).orElse(null));
                CompletableFuture<Component> notifier = this.userIdToComponent(locatableBlock.world().get(locatableBlock.blockPosition(), Keys.CREATOR).orElse(null));
                CompletableFuture.allOf(creator, notifier).thenAcceptAsync(x -> context.sendMessage(Identity.nil(), (Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Block Info: ").color(TextColor.color((RGBLike)GREEN))).append(Component.text((String)locatableBlock.blockPosition().toString()).hoverEvent((HoverEventSource)ItemStack.builder().fromBlockState(locatableBlock.blockState()).build().asImmutable()))).append((Component)Component.newline())).append((Component)Component.text((String)"Creator: ", (TextColor)TextColor.color((RGBLike)MINT)))).append((Component)creator.join())).append((Component)Component.newline())).append((Component)Component.text((String)"Notifier: ", (TextColor)TextColor.color((RGBLike)MINT)))).append((Component)notifier.join())).build()), (Executor)SpongeCommon.server());
                return CommandResult.success();
            }).orElseGet(() -> CommandResult.error((Component)Component.text((String)"Failed to find any block in range", (TextColor)NamedTextColor.RED)));
        }).build();
        Command.Parameterized entityLookingAt = Command.builder().executor(context -> {
            if (!(context.cause().root() instanceof Player)) {
                return CommandResult.error((Component)Component.text((String)"Player required", (TextColor)TextColor.color((RGBLike)RED)));
            }
            Player player = (Player)context.cause().root();
            return RayTrace.entity().sourceEyePosition((Living)player).direction((Living)player).limit(10).execute().map(result -> {
                Entity entity = (Entity)result.selectedObject();
                CompletableFuture<Component> creator = this.userIdToComponent(entity.get(Keys.CREATOR).orElse(null));
                CompletableFuture<Component> notifier = this.userIdToComponent(entity.get(Keys.NOTIFIER).orElse(null));
                CompletableFuture.allOf(creator, notifier).thenAcceptAsync(x -> context.sendMessage(Identity.nil(), (Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Entity Info: ").color(TextColor.color((RGBLike)GREEN))).append(entity.type().asComponent().hoverEvent((HoverEventSource)entity))).append((Component)Component.newline())).append((Component)Component.text((String)"Creator: ", (TextColor)TextColor.color((RGBLike)MINT)))).append((Component)creator.join())).append((Component)Component.newline())).append((Component)Component.text((String)"Notifier: ", (TextColor)TextColor.color((RGBLike)MINT)))).append((Component)notifier.join())).build()), (Executor)SpongeCommon.server());
                return CommandResult.success();
            }).orElseGet(() -> CommandResult.error((Component)Component.text((String)"Failed to find any block in range", (TextColor)NamedTextColor.RED)));
        }).build();
        return Command.builder().addChild(blockInfoAtCommand, new String[]{"blockAt"}).addChild(blockInfoLookingAt, new String[]{"block"}).addChild(entityLookingAt, new String[]{"entity"}).permission("sponge.command.info").build();
    }

    private Command.Parameterized chunksSubcommand() {
        Command.Parameterized globalCommand = Command.builder().executor(context -> {
            for (ServerWorld world : SpongeCommon.game().server().worldManager().worlds()) {
                context.sendMessage(Identity.nil(), (Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("World: ").append((Component)Component.text((String)world.key().toString(), (TextColor)NamedTextColor.GREEN))).append((Component)Component.newline())).append(this.getChunksInfo(world))).build());
            }
            return CommandResult.success();
        }).build();
        Command.Parameterized worldCommand = Command.builder().addParameter((Parameter)CommonParameters.WORLD).executor(context -> {
            ServerWorld world = (ServerWorld)context.requireOne(CommonParameters.WORLD);
            context.sendMessage(Identity.nil(), (Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("World: ").append((Component)Component.text((String)world.key().toString(), (TextColor)NamedTextColor.GREEN))).append((Component)Component.newline())).append(this.getChunksInfo(world))).build());
            return CommandResult.success();
        }).build();
        return Command.builder().addChild(globalCommand, new String[]{"global"}).addChild(worldCommand, new String[]{"world"}).permission("sponge.command.chunk").build();
    }

    private @NonNull CommandResult heapSubcommandExecutor(CommandContext context) {
        context.sendMessage((Component)Component.text((String)"Writing JVM heap data"));
        if (JvmUtil.dumpHeap()) {
            context.sendMessage((Component)Component.text((String)"Heap dump complete"));
            return CommandResult.success();
        }
        return CommandResult.error((Component)Component.text((String)"Failed to write heap dump. Check the console for more information."));
    }

    private @NonNull CommandResult pluginsListSubcommand(CommandContext context) {
        Collection plugins = ((Launch)Launch.instance()).pluginManager().plugins();
        context.sendMessage(Identity.nil(), this.title("Plugins (" + plugins.size() + ")"));
        for (PluginContainer specificContainer : plugins) {
            PluginMetadata metadata = specificContainer.metadata();
            TextComponent.Builder builder = Component.text();
            this.createShortContainerMeta((TextComponent.Builder)builder.append(INDENT_COMPONENT), metadata);
            builder.clickEvent(SpongeComponents.executeCallback(cause -> cause.sendMessage(Identity.nil(), this.createContainerMeta(metadata))));
            context.sendMessage(Identity.nil(), (Component)builder.build());
        }
        return CommandResult.success();
    }

    private @NonNull CommandResult pluginsInfoSubcommand(CommandContext context) {
        PluginContainer pluginContainer = (PluginContainer)context.requireOne(this.pluginContainerKey);
        context.sendMessage(Identity.nil(), this.createContainerMeta(pluginContainer.metadata()));
        return CommandResult.success();
    }

    private @NonNull CommandResult pluginsRefreshSubcommandExecutor(CommandContext context) {
        Optional pluginContainer = context.one(this.pluginContainerKey);
        RefreshGameEvent event = SpongeEventFactory.createRefreshGameEvent((Cause)PhaseTracker.getInstance().currentCause(), (Game)SpongeCommon.game());
        if (pluginContainer.isPresent()) {
            context.sendMessage(Identity.nil(), (Component)Component.text((String)("Sending refresh event to " + ((PluginContainer)pluginContainer.get()).metadata().id() + ", please wait...")));
            ((SpongeEventManager)SpongeCommon.game().eventManager()).postToPlugin((Event)event, (PluginContainer)pluginContainer.get());
        } else {
            context.sendMessage(Identity.nil(), (Component)Component.text((String)"Sending refresh event to all plugins, please wait..."));
            SpongeCommon.game().eventManager().post((Event)event);
        }
        context.sendMessage(Identity.nil(), (Component)Component.text((String)"Completed plugin refresh."));
        return CommandResult.success();
    }

    private @NonNull CommandResult tpsExecutor(CommandContext context) {
        if (SpongeCommon.game().isServerAvailable()) {
            ArrayList<Object> tps = new ArrayList<Object>();
            for (ServerWorld world : Sponge.server().worldManager().worlds()) {
                TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)world.key().asString(), (TextColor)TextColor.color((int)0xC9C9C9)))).append((Component)Component.text((String)": "));
                tps.add(this.appendTickTime(((ServerLevelBridge)world).bridge$recentTickTimes(), builder).build());
            }
            tps.add(Component.newline());
            tps.add(this.appendTickTime(SpongeCommon.server().method_54835(), Component.text().content("Overall: ")).build());
            SpongeCommon.game().serviceProvider().paginationService().builder().contents(tps).title((Component)Component.text((String)"Ticks Per Second (TPS)", (TextColor)NamedTextColor.WHITE)).padding((Component)Component.text((String)"-", (TextColor)NamedTextColor.WHITE)).sendTo(context.cause().audience());
        } else {
            context.sendMessage(Identity.nil(), (Component)Component.text((String)"Server is not running."));
        }
        return CommandResult.success();
    }

    public static double getAverage(long[] $$0) {
        long $$1 = 0L;
        for (long $$2 : $$0) {
            $$1 += $$2;
        }
        return (double)$$1 / (double)$$0.length;
    }

    private TextComponent.Builder appendTickTime(long[] tickTimes, TextComponent.Builder builder) {
        double averageTickTime = SpongeCommand.getAverage(tickTimes) * 1.0E-6;
        double tps = Math.min(1000.0 / averageTickTime, 20.0);
        ((TextComponent.Builder)builder.append((Component)Component.text((String)THREE_DECIMAL_DIGITS_FORMATTER.format(tps), (TextColor)this.tpsColor(tps)))).append(Component.text((String)" (", (TextColor)NamedTextColor.GRAY).append(((TextComponent)Component.text((String)THREE_DECIMAL_DIGITS_FORMATTER.format(averageTickTime), (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"ms avg"))).append((Component)Component.text((String)")"))));
        return builder;
    }

    private TextColor tpsColor(double tps) {
        if (tps >= 18.0) {
            return GREEN;
        }
        if (tps >= 15.0) {
            return YELLOW;
        }
        if (tps >= 10.0) {
            return ORANGE;
        }
        return RED;
    }

    private @NonNull CommandResult versionExecutor(CommandContext context) {
        if (this.versionText == null) {
            PluginContainer platformPlugin = ((Launch)Launch.instance()).platformPlugin();
            TextComponent.Builder builder = (TextComponent.Builder)Component.text().append((Component)Component.text((String)((String)platformPlugin.metadata().name().get()), (Style)Style.style((TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})));
            TextComponent colon = Component.text((String)": ", (TextColor)NamedTextColor.GRAY);
            for (PluginContainer container : ((Launch)Launch.instance()).launcherPlugins()) {
                PluginMetadata metadata = container.metadata();
                Component[] componentArray = new Component[5];
                componentArray[0] = Component.newline();
                componentArray[1] = INDENT_COMPONENT;
                componentArray[2] = Component.text((String)metadata.name().orElseGet(() -> ((PluginMetadata)metadata).id()), (TextColor)NamedTextColor.GRAY);
                componentArray[3] = colon;
                componentArray[4] = Component.text((String)container.metadata().version().toString());
                builder.append(componentArray);
            }
            String arch = System.getProperty("sun.arch.data.model");
            Object javaArch = arch != null ? arch + "-bit" : "UNKNOWN";
            String javaVendor = System.getProperty("java.vendor");
            String javaVersion = System.getProperty("java.version");
            String osName = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            String osArch = System.getProperty("os.arch");
            builder.append(new Component[]{Component.newline(), INDENT_COMPONENT, Component.text((String)"JVM", (TextColor)NamedTextColor.GRAY), colon, Component.text((String)(javaVersion + "/" + (String)javaArch + " (" + javaVendor + ")")), Component.newline(), INDENT_COMPONENT, Component.text((String)"OS", (TextColor)NamedTextColor.GRAY), colon, Component.text((String)(osName + "/" + osVersion + " (" + osArch + ")"))});
            this.versionText = builder.build();
        }
        context.sendMessage(Identity.nil(), this.versionText);
        return CommandResult.success();
    }

    private @NonNull CommandResult whichExecutor(CommandContext context) {
        CommandMapping mapping = (CommandMapping)context.requireOne(this.commandMappingKey);
        context.sendMessage(Identity.nil(), (Component)((TextComponent.Builder)Component.text().append(new Component[]{this.title("Aliases: "), Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.text((String)", ")), (Iterable)mapping.allAliases().stream().map(x -> Component.text((String)x, (TextColor)NamedTextColor.YELLOW)).collect(Collectors.toList())), Component.newline(), this.title("Owned by: "), this.hl(mapping.plugin().map(x -> x.metadata().name().orElseGet(() -> x.metadata().id())).orElse("unknown"))})).build());
        return CommandResult.success();
    }

    private @NonNull CommandResult reloadGlobalExecutor(CommandContext context) {
        SpongeConfigs.getCommon().reload().whenComplete(($, error) -> {
            if (error != null) {
                context.sendMessage(Identity.nil(), (Component)Component.text((String)"Failed to reload global configuration. See the console for details.", (TextColor)NamedTextColor.RED));
                SpongeCommon.logger().error("Failed to reload global configuration", error);
            } else {
                context.sendMessage(Identity.nil(), (Component)Component.text((String)"Successfully reloaded global configuration!", (TextColor)NamedTextColor.GREEN));
            }
        });
        return CommandResult.success();
    }

    private @NonNull CommandResult reloadWorldExecutor(CommandContext context) {
        ServerWorld target = (ServerWorld)context.requireOne(this.worldKey);
        ResourceKey worldId = target.key();
        SpongeGameConfigs.getForWorld(target).reload().whenComplete(($, error) -> {
            if (error != null) {
                context.sendMessage(Identity.nil(), (Component)Component.text(b -> ((TextComponent.Builder)((TextComponent.Builder)b.content("Failed to reload configuration for world ").append((Component)Component.text((String)worldId.toString(), (Style)Style.style((TextDecoration)TextDecoration.BOLD)))).append((Component)Component.text((String)". See the console for details."))).color((TextColor)NamedTextColor.RED)));
                SpongeCommon.logger().error("Failed to reload configuration of world '{}'", (Object)worldId, error);
            } else {
                context.sendMessage(Identity.nil(), ((TextComponent)Component.text((String)"Successfully reloaded configuration for world ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)worldId.toString(), (Style)Style.style((TextDecoration)TextDecoration.BOLD)))).append((Component)Component.text((String)"!")));
            }
        });
        return CommandResult.success();
    }

    protected Component getChunksInfo(ServerWorld serverWorld) {
        if (((LevelBridge)serverWorld).bridge$isFake()) {
            return ((TextComponent.Builder)Component.text().append(new Component[]{Component.newline(), Component.text((String)(serverWorld.key().asString() + " is a fake world"))})).build();
        }
        class_3218 serverLevel = (class_3218)serverWorld;
        int entitiesToRemove = (int)serverWorld.entities().stream().filter(x -> ((class_1297)x).method_31481()).count();
        return LinearComponents.linear((ComponentBuilderApplicable[])new ComponentBuilderApplicable[]{this.key("Loaded chunks: "), this.value(serverLevel.method_14178().field_17254.method_17260()), Component.newline(), this.key("Entities: "), this.value(serverWorld.entities().size()), Component.newline(), this.key("Block Entities: "), this.value(serverWorld.blockEntities().size()), Component.newline(), this.key("Removed Entities:"), this.value(entitiesToRemove), Component.newline(), this.key("Removed Block Entities: "), this.value((int)((LevelAccessor)serverLevel).accessor$blockEntityTickers().stream().filter(class_5562::method_31704).count())});
    }

    protected Component key(String text) {
        return Component.text((String)text, (TextColor)NamedTextColor.GOLD);
    }

    protected Component value(int text) {
        return Component.text((int)text, (TextColor)NamedTextColor.GRAY);
    }

    private Component title(String title) {
        return Component.text((String)title, (TextColor)NamedTextColor.GREEN);
    }

    private Component hl(String toHighlight) {
        return Component.text((String)toHighlight, (TextColor)NamedTextColor.DARK_GREEN);
    }

    private void appendPluginMeta(TextComponent.Builder builder, String key, String value) {
        this.appendPluginMeta(builder, key, (Component)Component.text((String)value));
    }

    private void appendPluginMeta(TextComponent.Builder builder, String key, URL value) {
        String url = value.toString();
        this.appendPluginMeta(builder, key, (Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(url).clickEvent(ClickEvent.openUrl((String)url))).decoration(TextDecoration.UNDERLINED, true)).build());
    }

    private void appendPluginMeta(TextComponent.Builder builder, String key, Component value) {
        ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append(new Component[0])).append(new Component[]{INDENT_COMPONENT, this.title(key + ": "), value});
    }

    private void createShortContainerMeta(TextComponent.Builder builder, PluginMetadata pluginMetadata) {
        builder.append(this.title(pluginMetadata.name().orElse(pluginMetadata.id())));
        builder.append((Component)Component.text((String)(" v" + String.valueOf(pluginMetadata.version()))));
    }

    private Component createContainerMeta(PluginMetadata pluginMetadata) {
        TextComponent.Builder builder = Component.text();
        this.createShortContainerMeta(builder, pluginMetadata);
        this.appendPluginMeta(builder, "ID", pluginMetadata.id());
        pluginMetadata.description().ifPresent(x -> this.appendPluginMeta(builder, "Description", (String)x));
        pluginMetadata.links().homepage().ifPresent(x -> this.appendPluginMeta(builder, "Homepage", (URL)x));
        pluginMetadata.links().issues().ifPresent(x -> this.appendPluginMeta(builder, "Issues", (URL)x));
        pluginMetadata.links().source().ifPresent(x -> this.appendPluginMeta(builder, "Source", (URL)x));
        List contributors = pluginMetadata.contributors();
        if (!contributors.isEmpty()) {
            ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append(INDENT_COMPONENT)).append(this.title("Contributors:"));
            for (PluginContributor contributor : contributors) {
                ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append(LONG_INDENT_COMPONENT)).append((Component)Component.text((String)contributor.name()));
                contributor.description().ifPresent(x -> builder.append((Component)Component.text((String)(" (" + x + ")"))));
            }
        }
        this.appendPluginMeta(builder, "Entrypoint", pluginMetadata.entrypoint());
        return builder.build();
    }
}

