/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import javax.inject.Inject;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.common.data.persistence.ConfigurateTranslator;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public final class DataTranslatableTypeSerializer
implements TypeSerializer<Object> {
    private final DataManager dataManager;

    @Inject
    DataTranslatableTypeSerializer(DataManager dataManager) {
        this.dataManager = dataManager;
    }

    public boolean accepts(Type x) {
        return this.dataManager.translator(GenericTypeReflector.erase((Type)x)).isPresent();
    }

    public Object deserialize(Type type, ConfigurationNode value) throws SerializationException {
        Class clazz = GenericTypeReflector.erase((Type)type);
        DataTranslator translator = (DataTranslator)this.dataManager.translator(clazz).orElseThrow(() -> new SerializationException("Could not translate of DataTranslatable type: " + clazz.getName()));
        return translator.translate((DataView)ConfigurateTranslator.instance().translate(value));
    }

    public void serialize(Type type, Object obj, ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.raw(null);
        } else {
            Class clazz = GenericTypeReflector.erase((Type)type);
            DataTranslator translator = (DataTranslator)this.dataManager.translator(clazz).orElseThrow(() -> new SerializationException("Could not translate of DataTranslatable type: " + clazz.getName()));
            ConfigurateTranslator.instance().translateDataToNode(value, (DataView)translator.translate(obj));
        }
    }
}

