/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Singleton;
import java.io.IOException;
import javax.inject.Inject;
import org.spongepowered.api.config.ConfigManager;
import org.spongepowered.api.config.ConfigRoot;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.config.DataSerializableTypeSerializer;
import org.spongepowered.common.config.DataTranslatableTypeSerializer;
import org.spongepowered.common.config.PluginConfigRoot;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.reference.WatchServiceListener;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;
import org.spongepowered.plugin.PluginContainer;

@Singleton
public final class PluginConfigManager
implements ConfigManager {
    private final TypeSerializerCollection serializers;
    private final WatchServiceListener listener = WatchServiceListener.builder().threadFactory(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Sponge-WatchService-%d").build()).build();

    @Inject
    PluginConfigManager(DataSerializableTypeSerializer dataSerializableSerializer, DataTranslatableTypeSerializer dataTranslatableSerializer) throws IOException {
        this.serializers = TypeSerializerCollection.defaults().childBuilder().register(DataSerializableTypeSerializer::accepts, (TypeSerializer)dataSerializableSerializer).registerAll(SpongeAdventure.CONFIGURATE.serializers()).register(dataTranslatableSerializer::accepts, (TypeSerializer)dataTranslatableSerializer).build();
    }

    public ConfigRoot sharedConfig(PluginContainer container) {
        return new PluginConfigRoot(this.serializers, container.metadata().id().toLowerCase(), SpongeCommon.pluginConfigDirectory());
    }

    public ConfigRoot pluginConfig(PluginContainer container) {
        return new PluginConfigRoot(this.serializers, container.metadata().id().toLowerCase(), SpongeCommon.pluginConfigDirectory().resolve(container.metadata().id().toLowerCase()));
    }

    public TypeSerializerCollection serializers() {
        return this.serializers;
    }

    public WatchServiceListener watchServiceListener() {
        return this.listener;
    }

    public static ConfigurationOptions getOptions(TypeSerializerCollection serializers) {
        return ConfigurationOptions.defaults().serializers(serializers);
    }

    public void close() throws IOException {
        this.listener.close();
    }
}

