/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.common;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.spongepowered.common.applaunch.config.LaunchConfig;
import org.spongepowered.common.config.common.CommandsCategory;
import org.spongepowered.common.config.common.DebugCategory;
import org.spongepowered.common.config.common.ExploitCategory;
import org.spongepowered.common.config.common.GeneralCategory;
import org.spongepowered.common.config.common.IpForwardingCategory;
import org.spongepowered.common.config.common.ModuleCategory;
import org.spongepowered.common.config.common.OptimizationCategory;
import org.spongepowered.common.config.common.PhaseTrackerCategory;
import org.spongepowered.common.config.common.ServicesCategory;
import org.spongepowered.common.config.common.TeleportHelperCategory;
import org.spongepowered.common.config.common.WorldCategory;
import org.spongepowered.common.config.core.Config;
import org.spongepowered.common.config.core.IpSet;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.transformation.TransformAction;

public final class CommonConfig
implements Config {
    public static final String FILE_NAME = "sponge.conf";
    @Setting
    public final GeneralCategory general = new GeneralCategory();
    @Setting
    public final CommandsCategory commands = new CommandsCategory();
    @Setting
    public final ModuleCategory modules = new ModuleCategory();
    @Setting(value="ip-sets")
    private final Map<String, List<IpSet>> ipSets = new HashMap<String, List<IpSet>>();
    @Setting
    public final IpForwardingCategory ipForwarding = new IpForwardingCategory();
    @Setting
    public final ExploitCategory exploits = new ExploitCategory();
    @Setting
    public final OptimizationCategory optimizations = new OptimizationCategory();
    @Setting(value="phase-tracker")
    public final PhaseTrackerCategory phaseTracker = new PhaseTrackerCategory();
    @Setting(value="teleport-helper")
    @Comment(value="Blocks to blacklist for safe teleportation.")
    public final TeleportHelperCategory teleportHelper = new TeleportHelperCategory();
    @Setting
    @Comment(value="Enables server owners to require specific plugins to provide Sponge services")
    public final ServicesCategory services = new ServicesCategory();
    @Setting
    public final DebugCategory debug = new DebugCategory();
    @Setting
    public final WorldCategory world = new WorldCategory();

    public static ConfigurationTransformation transformation() {
        return ConfigurationTransformation.versionedBuilder().addVersion(3, CommonConfig.buildTwoToThree()).addVersion(2, CommonConfig.buildOneToTwo()).addVersion(1, CommonConfig.buildZeroToOne()).build();
    }

    static ConfigurationTransformation buildTwoToThree() {
        return ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"general", "plugins-dir"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"general", "config-dir"}), (path, node) -> {
            node.set((Object)LaunchConfig.convertLegacyPath(node.getString("")));
            return TransformAction.rename((Object)"plugin-config-dir").visitPath(path, node);
        }).build();
    }

    static ConfigurationTransformation buildOneToTwo() {
        return ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"commands", "enforce-permission-checks-on-non-sponge-commands"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"commands", "commands-hidden"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"debug", "thread-contention-monitoring"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"exploits", "filter-invalid-entities-on-chunk-save"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"exploits", "limit-book-size"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"exploits", "book-size-total-multiplier"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"exploits", "mark-chunks-as-dirty-on-entity-list-modification"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"exploits", "update-tracked-chunk-on-entity-move"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"exploits", "load-chunk-on-entity-position-set"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"exploits", "sync-player-positions-for-vehicle-movement"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"general", "file-io-thread-sleep"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"permissions"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"modules", "block-entity-activation"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"modules", "entity-collision"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"modules", "tracking"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"modules", "real-time"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"modules", "timings"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"optimizations", "drops-pre-merge"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"optimizations", "eigen-redstone"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"optimizations", "faster-thread-checks"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"optimizations", "optimize-maps"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"optimizations", "optimize-hoppers"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"optimizations", "optimize-block-entity-ticking"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"optimizations", "use-active-chunks-for-collisions"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"optimizations", "disable-failing-deserialization-log-spam"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"optimizations", "disable-scheduled-updates-for-persistent-leaf-blocks"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"phase-tracker", "capture-async-commands"}), TransformAction.remove()).build();
    }

    static ConfigurationTransformation buildZeroToOne() {
        return ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"modules", "bungeecord"}), TransformAction.rename((Object)"ip-forwarding")).addAction(NodePath.path((Object[])new Object[]{"bungeecord"}), TransformAction.rename((Object)"ip-forwarding")).addAction(NodePath.path((Object[])new Object[]{"bungeecord", "ip-forwarding"}), (path, node) -> {
            if (node.getBoolean()) {
                node.parent().node(new Object[]{"mode"}).set((Object)IpForwardingCategory.Mode.LEGACY);
            }
            node.set(null);
            return null;
        }).build();
    }

    public Map<String, Predicate<InetAddress>> getIpSets() {
        HashMap result = new HashMap(this.ipSets.size());
        for (Map.Entry<String, List<IpSet>> entry : this.ipSets.entrySet()) {
            result.put(entry.getKey(), CommonConfig.allOf(entry.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    public Predicate<InetAddress> getIpSet(String name) {
        return this.ipSets.containsKey(name) ? CommonConfig.allOf(this.ipSets.get(name)) : null;
    }

    private static <T> Predicate<T> allOf(List<? extends Predicate<T>> elements) {
        Predicate[] sets = elements.toArray(new Predicate[0]);
        return addr -> {
            for (Predicate set : sets) {
                if (set.test(addr)) continue;
                return false;
            }
            return true;
        };
    }
}

