/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.core;

import io.leangen.geantyref.TypeToken;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.config.core.Config;
import org.spongepowered.common.config.core.SpongeConfigs;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;

public class ConfigHandle<T extends Config> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final NodePath VERSION_PATH = NodePath.path((Object[])new Object[]{"version"});
    private static final String VERSION_COMMENT = "Active configuration version\nThis has no relation to the current Sponge version, and will be updated automatically\nManual changes may cause unpredictable results.";
    private static boolean saveSuppressed = true;
    private static final Set<ConfigHandle<?>> saveQueue = ConcurrentHashMap.newKeySet();
    protected final @Nullable ConfigurationLoader<? extends CommentedConfigurationNode> loader;
    protected final Class<T> instanceType;
    protected volatile T instance;
    protected @MonotonicNonNull CommentedConfigurationNode node;
    private final @Nullable Supplier<ConfigurationTransformation> transformer;

    public static void setSaveSuppressed(boolean suppressed) {
        saveSuppressed = suppressed;
        if (!suppressed && !saveQueue.isEmpty()) {
            Iterator<ConfigHandle<?>> it = saveQueue.iterator();
            while (it.hasNext()) {
                try {
                    it.next().doSave();
                }
                catch (ConfigurateException ex) {
                    LOGGER.error("Unable to save a Sponge configuration!", (Throwable)ex);
                }
                it.remove();
            }
        }
    }

    protected ConfigHandle(Class<T> type) {
        try {
            this.instance = (Config)BasicConfigurationNode.root((ConfigurationOptions)SpongeConfigs.OPTIONS).get(type);
        }
        catch (SerializationException ex) {
            throw new AssertionError((Object)ex);
        }
        this.instanceType = type;
        this.loader = null;
        this.transformer = null;
    }

    protected ConfigHandle(Class<T> instanceType, @Nullable Supplier<ConfigurationTransformation> versionUpdater, @Nullable ConfigurationLoader<? extends CommentedConfigurationNode> loader) {
        this.instanceType = instanceType;
        this.loader = loader;
        this.transformer = versionUpdater;
    }

    public boolean isAttached() {
        return this.loader != null;
    }

    public T get() {
        return this.instance;
    }

    public CompletableFuture<T> updateAndSave(UnaryOperator<T> updater) {
        Config updated = (Config)Objects.requireNonNull(updater, "updater").apply(this.instance);
        return ConfigHandle.asyncFailableFuture(() -> {
            this.save();
            return updated;
        }, ForkJoinPool.commonPool());
    }

    void load() throws ConfigurateException {
        if (this.loader == null) {
            return;
        }
        CommentedConfigurationNode node = (CommentedConfigurationNode)this.loader.load();
        this.doVersionUpdate(node);
        this.node = node;
        this.instance = (Config)node.get(this.instanceType);
        this.doSave();
    }

    protected final void doVersionUpdate(CommentedConfigurationNode node) throws ConfigurateException {
        if (this.transformer != null) {
            boolean wasEmpty = node.empty();
            CommentedConfigurationNode versionNode = (CommentedConfigurationNode)node.node((Iterable)VERSION_PATH);
            int existingVersion = versionNode.getInt(-1);
            this.transformer.get().apply((ConfigurationNode)node);
            int newVersion = versionNode.getInt(-1);
            if (!wasEmpty && newVersion > existingVersion) {
                LOGGER.info("Updated {} from version {} to {}", this.instance, (Object)existingVersion, (Object)newVersion);
            }
            versionNode.commentIfAbsent(VERSION_COMMENT);
            ((CommentedConfigurationNode)node.node((Iterable)VERSION_PATH)).set((Object)versionNode);
        }
    }

    public CompletableFuture<?> reload() {
        return ConfigHandle.asyncFailableFuture(() -> {
            this.load();
            return null;
        }, ForkJoinPool.commonPool());
    }

    public final void save() {
        if (saveSuppressed) {
            saveQueue.add(this);
        } else {
            try {
                this.doSave();
            }
            catch (ConfigurateException ex) {
                LOGGER.error("Unable to save configuration to {}", this.loader, (Object)ex);
            }
        }
    }

    protected void doSave() throws ConfigurateException {
        if (this.loader == null) {
            return;
        }
        if (this.node == null) {
            this.node = (CommentedConfigurationNode)this.loader.createNode();
        }
        T instance = this.instance;
        CommentedConfigurationNode node = this.node;
        if (instance != null && node != null) {
            node.set(this.instanceType, instance);
        }
        this.loader.save((ConfigurationNode)node);
    }

    private @Nullable CommentedConfigurationNode getSetting(String key) {
        if (key.equalsIgnoreCase("config-enabled")) {
            return (CommentedConfigurationNode)this.node.node(new Object[]{key});
        }
        if (!key.contains(".") || key.indexOf(46) == key.length() - 1) {
            return null;
        }
        CommentedConfigurationNode node = this.node;
        String[] split = key.split("\\.");
        return (CommentedConfigurationNode)node.node((Object[])split);
    }

    public CompletableFuture<CommentedConfigurationNode> updateSetting(String key, Object value) {
        return ConfigHandle.asyncFailableFuture(() -> {
            CommentedConfigurationNode upd = this.getSetting(key);
            upd.set(value);
            this.instance = (Config)this.node.get(this.instanceType);
            this.save();
            return upd;
        }, ForkJoinPool.commonPool());
    }

    public <V> CompletableFuture<CommentedConfigurationNode> updateSetting(String key, V value, TypeToken<V> token) {
        return ConfigHandle.asyncFailableFuture(() -> {
            CommentedConfigurationNode upd = this.getSetting(key);
            upd.set(token, value);
            this.instance = (Config)this.node.get(this.instanceType);
            this.save();
            return upd;
        }, ForkJoinPool.commonPool());
    }

    private static <T> CompletableFuture<T> asyncFailableFuture(Callable<T> action, Executor executor) {
        CompletableFuture future = new CompletableFuture();
        executor.execute(() -> {
            try {
                future.complete(action.call());
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
            }
        });
        return future;
    }

    public ConfigurationNode getNode() {
        return this.node;
    }
}

