/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.core;

import com.google.common.collect.ImmutableSet;
import io.leangen.geantyref.GenericTypeReflector;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.common.config.common.CommonConfig;
import org.spongepowered.common.config.core.Config;
import org.spongepowered.common.config.core.ConfigHandle;
import org.spongepowered.common.config.core.FileMovingConfigurationTransformation;
import org.spongepowered.common.config.core.IpSet;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.objectmapping.meta.NodeResolver;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;

public final class SpongeConfigs {
    public static final String GLOBAL_NAME = "global.conf";
    public static final String METRICS_NAME = "metrics.conf";
    static final String HEADER = "# If you need help with the configuration or have any questions related to Sponge,\n# join us on Discord or drop by our forums and leave a post.\n\n# Discord: https://discord.gg/sponge\n# Forums: https://forums.spongepowered.org/\n";
    public static final ObjectMapper.Factory OBJECT_MAPPERS = ObjectMapper.factoryBuilder().addNodeResolver(NodeResolver.onlyWithSetting()).build();
    public static final ConfigurationOptions OPTIONS = ConfigurationOptions.defaults().header("# If you need help with the configuration or have any questions related to Sponge,\n# join us on Discord or drop by our forums and leave a post.\n\n# Discord: https://discord.gg/sponge\n# Forums: https://forums.spongepowered.org/\n").serializers(collection -> collection.register(type -> {
        Class erasure = GenericTypeReflector.erase((Type)type);
        return erasure.isAnnotationPresent(ConfigSerializable.class) || Config.class.isAssignableFrom(erasure);
    }, OBJECT_MAPPERS.asTypeSerializer()).register((ScalarSerializer)IpSet.Serializer.INSTANCE));
    static final Logger LOGGER = LogManager.getLogger();
    public static final Lock initLock = new ReentrantLock();
    private static Path configDir;
    private static ConfigHandle<CommonConfig> sponge;
    private static final NodePath PATH_PREFIX;
    private static final Set<NodePath> MIGRATE_SPONGE_PATHS;
    private static final Set<NodePath> MIGRATE_METRICS_PATHS;

    public static Path getDirectory() {
        if (configDir == null) {
            configDir = AppLaunch.pluginPlatform().configDirectory().resolve("sponge");
        }
        return configDir;
    }

    public static ConfigHandle<CommonConfig> getCommon() {
        if (sponge == null) {
            initLock.lock();
            try {
                if (sponge == null) {
                    SpongeConfigs.splitFiles();
                    sponge = SpongeConfigs.create(CommonConfig.class, CommonConfig::transformation, "sponge.conf");
                }
            }
            finally {
                initLock.unlock();
            }
        }
        return sponge;
    }

    public static HoconConfigurationLoader createLoader(Path path) throws IOException {
        return SpongeConfigs.createLoader(path, OPTIONS);
    }

    public static HoconConfigurationLoader createLoader(Path path, ConfigurationOptions options) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        return ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(path)).defaultOptions(options)).build();
    }

    public static <T extends Config> ConfigHandle<T> create(Class<T> instance, @Nullable Supplier<ConfigurationTransformation> versionModifier, String fileName) {
        try {
            HoconConfigurationLoader loader = SpongeConfigs.createLoader(SpongeConfigs.getDirectory().resolve(fileName));
            ConfigHandle<T> handle = new ConfigHandle<T>(instance, versionModifier, (ConfigurationLoader<? extends CommentedConfigurationNode>)loader);
            handle.load();
            return handle;
        }
        catch (IOException ex) {
            LOGGER.error("Unable to load configuration {}. Sponge will operate in fallback mode, with default configuration options and will not write to the invalid file", (Object)fileName, (Object)ex);
            return new ConfigHandle<T>(instance);
        }
    }

    private static void splitFiles() {
        Path commonFile = SpongeConfigs.getDirectory().resolve("sponge.conf");
        Path metricsFile = SpongeConfigs.getDirectory().resolve(METRICS_NAME);
        Path oldGlobalFile = SpongeConfigs.getDirectory().resolve(GLOBAL_NAME);
        if (!Files.exists(oldGlobalFile, new LinkOption[0]) || Files.exists(commonFile, new LinkOption[0]) || Files.exists(metricsFile, new LinkOption[0])) {
            return;
        }
        try {
            ConfigurationTransformation xform = ConfigurationTransformation.chain((ConfigurationTransformation[])new ConfigurationTransformation[]{new FileMovingConfigurationTransformation(MIGRATE_SPONGE_PATHS, (ConfigurationLoader<?>)SpongeConfigs.createLoader(commonFile), true), new FileMovingConfigurationTransformation(MIGRATE_METRICS_PATHS, (ConfigurationLoader<?>)SpongeConfigs.createLoader(metricsFile), true)});
            HoconConfigurationLoader globalLoader = SpongeConfigs.createLoader(oldGlobalFile);
            Files.copy(oldGlobalFile, oldGlobalFile.resolveSibling("global.conf.old-backup"), new CopyOption[0]);
            CommentedConfigurationNode source = (CommentedConfigurationNode)globalLoader.load();
            xform.apply((ConfigurationNode)source);
            globalLoader.save((ConfigurationNode)source);
            LOGGER.info("Migrated Sponge configuration to 1.15+ split-file layout");
        }
        catch (IOException ex) {
            LOGGER.error("An error occurred while trying to migrate to a split-file configuration layout", (Throwable)ex);
        }
    }

    private SpongeConfigs() {
    }

    static {
        PATH_PREFIX = NodePath.path((Object[])new Object[]{"sponge"});
        MIGRATE_SPONGE_PATHS = (Set)Stream.of(NodePath.path((Object[])new Object[]{"world", "auto-player-save-interval"}), NodePath.path((Object[])new Object[]{"world", "leaf-decay"}), NodePath.path((Object[])new Object[]{"world", "game-profile-query-task-interval"}), NodePath.path((Object[])new Object[]{"world", "invalid-lookup-uuids"}), NodePath.path((Object[])new Object[]{"general"}), NodePath.path((Object[])new Object[]{"sql"}), NodePath.path((Object[])new Object[]{"commands"}), NodePath.path((Object[])new Object[]{"permission"}), NodePath.path((Object[])new Object[]{"modules"}), NodePath.path((Object[])new Object[]{"ip-sets"}), NodePath.path((Object[])new Object[]{"bungeecord"}), NodePath.path((Object[])new Object[]{"exploits"}), NodePath.path((Object[])new Object[]{"optimizations"}), NodePath.path((Object[])new Object[]{"cause-tracker"}), NodePath.path((Object[])new Object[]{"teleport-helper"}), NodePath.path((Object[])new Object[]{"broken-mods"}), NodePath.path((Object[])new Object[]{"service-registration"}), NodePath.path((Object[])new Object[]{"debug"})).map(arg_0 -> ((NodePath)PATH_PREFIX).plus(arg_0)).collect(ImmutableSet.toImmutableSet());
        MIGRATE_METRICS_PATHS = ImmutableSet.of((Object)NodePath.path((Object[])new Object[]{"sponge", "metrics"}));
    }
}

