/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.inheritable;

import org.spongepowered.common.config.core.Config;
import org.spongepowered.common.config.inheritable.EntityActivationRangeCategory;
import org.spongepowered.common.config.inheritable.EntityCategory;
import org.spongepowered.common.config.inheritable.MovementChecksCategory;
import org.spongepowered.common.config.inheritable.SpawnerCategory;
import org.spongepowered.common.config.inheritable.WorldCategory;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.transformation.TransformAction;

public abstract class BaseConfig
implements Config {
    @Setting
    public final EntityCategory entity = new EntityCategory();
    @Setting(value="entity-activation-range")
    public final EntityActivationRangeCategory entityActivationRange = new EntityActivationRangeCategory();
    @Setting(value="spawner")
    @Comment(value="Used to control spawn limits around a player's view distance.")
    public final SpawnerCategory spawner = new SpawnerCategory();
    @Setting(value="movement-checks")
    public final MovementChecksCategory movementChecks = new MovementChecksCategory();
    @Setting
    public final WorldCategory world = new WorldCategory();

    public static ConfigurationTransformation transformation() {
        return ConfigurationTransformation.versionedBuilder().addVersion(3, BaseConfig.buildTwoToThree()).addVersion(2, BaseConfig.buildOneToTwo()).addVersion(1, BaseConfig.buildInitialToOne()).build();
    }

    static ConfigurationTransformation buildTwoToThree() {
        return ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"player-block-tracker"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"entity-collision"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"block-entity-activation"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"entity", "max-bounding-box-size"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"entity", "max-speed"}), TransformAction.remove()).build();
    }

    static ConfigurationTransformation buildOneToTwo() {
        return ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"world", "portal-agents"}), TransformAction.remove()).build();
    }

    static ConfigurationTransformation buildInitialToOne() {
        return ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"sponge"}), (path, value) -> new Object[0]).build();
    }
}

