/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.inheritable;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.config.core.Config;
import org.spongepowered.common.config.core.ConfigHandle;
import org.spongepowered.common.config.core.SpongeConfigs;
import org.spongepowered.common.config.inheritable.BaseConfig;
import org.spongepowered.common.config.inheritable.DuplicateRemovalVisitor;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;

public final class InheritableConfigHandle<T extends BaseConfig>
extends ConfigHandle<T> {
    private final @Nullable InheritableConfigHandle<?> parent;
    private CommentedConfigurationNode mergedNode;

    public InheritableConfigHandle(Class<T> instanceType, @Nullable InheritableConfigHandle<?> parent) {
        super(instanceType);
        this.parent = parent;
    }

    public InheritableConfigHandle(Class<T> instanceType, @Nullable Supplier<ConfigurationTransformation> versionUpdater, ConfigurationLoader<? extends CommentedConfigurationNode> loader, @Nullable InheritableConfigHandle<?> parent) {
        super(instanceType, versionUpdater, loader);
        this.parent = parent;
    }

    public <V> V getOrCreateValue(Function<T, V> getter, Consumer<BaseConfig> setter, boolean populate) {
        V ret = getter.apply((BaseConfig)this.get());
        if (ret == null && populate) {
            setter.accept((BaseConfig)this.get());
            if (this.parent != null) {
                setter.accept((BaseConfig)this.parent.get());
            }
            ret = getter.apply((BaseConfig)this.get());
        }
        return ret;
    }

    public void load() throws ConfigurateException {
        CommentedConfigurationNode mergedNode;
        CommentedConfigurationNode node;
        if (this.isAttached()) {
            node = (CommentedConfigurationNode)this.loader.load();
            this.doVersionUpdate(node);
            mergedNode = (CommentedConfigurationNode)node.copy();
        } else {
            node = null;
            mergedNode = CommentedConfigurationNode.root((ConfigurationOptions)SpongeConfigs.OPTIONS);
        }
        if (this.parent != null && this.parent.mergedNode != null) {
            mergedNode.mergeFrom((ConfigurationNode)this.parent.mergedNode);
        }
        this.instance = (Config)mergedNode.get(this.instanceType);
        this.node = node;
        this.mergedNode = mergedNode;
        this.doSave();
    }

    @Override
    public void doSave() throws ConfigurateException {
        if (!this.isAttached()) {
            return;
        }
        this.node.set(this.instanceType, (Object)((BaseConfig)this.instance));
        if (this.parent != null) {
            this.removeDuplicates(this.node);
        }
        this.loader.save((ConfigurationNode)this.node);
        if (this.parent != null) {
            this.parent.doSave();
        }
    }

    private void removeDuplicates(CommentedConfigurationNode root) {
        if (!this.isAttached()) {
            return;
        }
        if (this.parent == null) {
            throw new IllegalStateException("parent is null");
        }
        DuplicateRemovalVisitor.visit((ConfigurationNode)root, (ConfigurationNode)this.parent.mergedNode);
    }
}

