/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.tracker;

import java.util.HashMap;
import java.util.Map;
import org.spongepowered.common.config.tracker.NamespacedCategory;
import org.spongepowered.common.config.tracker.TrackerCategory;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public final class EntityTrackerCategory
implements TrackerCategory {
    @Setting(value="auto-populate")
    @Comment(value="If 'true', newly discovered entities will be added to this config with default settings.")
    public boolean autoPopulate = false;
    @Setting
    @Comment(value="Per-mod entity id mappings for controlling tracking behavior")
    public final Map<String, NamespacedCategory> mods = new HashMap<String, NamespacedCategory>();

    public EntityTrackerCategory() {
        NamespacedCategory vanilla = this.namespacedOrCreate("minecraft");
        vanilla.valueOrCreate("item").setCaptureBlocksInBulk(false);
        vanilla.valueOrCreate("experience_orb").setCaptureBlocksInBulk(false);
        vanilla.valueOrCreate("leash_hitch").setCaptureBlocksInBulk(false);
        vanilla.valueOrCreate("painting").setCaptureBlocksInBulk(false);
        vanilla.valueOrCreate("armor_stand").setCaptureBlocksInBulk(false);
        vanilla.valueOrCreate("llama_spit").setCaptureBlocksInBulk(false);
    }

    @Override
    public boolean autoPopulate() {
        return this.autoPopulate;
    }

    @Override
    public NamespacedCategory namespacedOrCreate(String namespace) {
        return this.mods.computeIfAbsent(namespace, k -> new NamespacedCategory());
    }
}

