/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.StringJoiner;
import net.minecraft.class_2487;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.world.Archetype;
import org.spongepowered.api.world.LocatableSnapshot;
import org.spongepowered.common.data.holder.SpongeMutableDataHolder;
import org.spongepowered.common.data.nbt.validation.DelegateDataValidator;
import org.spongepowered.common.data.nbt.validation.RawDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.provider.DataProviderLookup;

public abstract class AbstractArchetype<T, S extends LocatableSnapshot<S>, E>
implements Archetype<S, E>,
SpongeMutableDataHolder {
    protected final T type;
    protected class_2487 compound;

    protected AbstractArchetype(T type, class_2487 compound) {
        this.type = type;
        this.compound = compound;
    }

    public abstract DataProviderLookup getLookup();

    protected abstract ValidationType getValidationType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractArchetype)) {
            return false;
        }
        AbstractArchetype that = (AbstractArchetype)o;
        return this.type.equals(that.type) && this.compound.equals((Object)that.compound);
    }

    public void setRawData(DataView container) throws InvalidDataException {
        Objects.requireNonNull(container, "Raw data cannot be null!");
        class_2487 copy = NBTTranslator.INSTANCE.translate(container);
        boolean valid = this.getValidator().validate(copy);
        if (!valid) {
            throw new InvalidDataException("Invalid data for " + String.valueOf(this.getValidationType()));
        }
        this.compound = copy;
    }

    public boolean validateRawData(DataView container) {
        return this.getValidator().validate(container);
    }

    private DelegateDataValidator getValidator() {
        return new DelegateDataValidator(this.getValidators(), this.getValidationType());
    }

    protected abstract ImmutableList<RawDataValidator> getValidators();

    public int hashCode() {
        return Objects.hash(this.type, this.compound);
    }

    public String toString() {
        return new StringJoiner(", ", AbstractArchetype.class.getSimpleName() + "[", "]").add("type=" + String.valueOf(this.type)).add("data=" + String.valueOf(this.compound)).toString();
    }

    public class_2487 getCompound() {
        return this.compound;
    }
}

