/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.common.data.MemoryDataContainer;
import org.spongepowered.common.data.MemoryDataView;
import org.spongepowered.common.data.SpongeDataManager;

public class DataSerializer {
    public static Object serialize(DataView.SafetyMode safetyMode, Object value) {
        if (value instanceof DataView) {
            switch (safetyMode) {
                case ALL_DATA_CLONED: 
                case CLONED_ON_SET: {
                    MemoryDataContainer view = new MemoryDataContainer(safetyMode);
                    for (Map.Entry entry : ((DataView)value).values(false).entrySet()) {
                        ((MemoryDataView)view).set((DataQuery)entry.getKey(), entry.getValue());
                    }
                    return view;
                }
            }
            return value;
        }
        if (value instanceof DataSerializable) {
            return ((DataSerializable)value).toContainer();
        }
        Optional<DataTranslator<?>> translator = SpongeDataManager.INSTANCE.translator(value.getClass());
        if (translator.isPresent()) {
            DataTranslator<?> serializer = translator.get();
            return serializer.translate(value);
        }
        Optional optRegistryType = SpongeDataManager.INSTANCE.findRegistryTypeFor(value.getClass());
        if (optRegistryType.isPresent()) {
            ResourceKey valueKey = Sponge.game().registry(optRegistryType.get()).valueKey(value);
            return valueKey.toString();
        }
        if (value instanceof ResourceKey) {
            return value.toString();
        }
        if (value instanceof Collection) {
            return DataSerializer.serializeCollection(safetyMode, (Collection)value);
        }
        if (value instanceof Map) {
            return DataSerializer.serializeMap((Map)value);
        }
        if (value.getClass().isArray()) {
            return DataSerializer.serializeArray(safetyMode, value);
        }
        return value;
    }

    private static DataContainer serializeMap(Map<?, ?> value) {
        DataContainer map = DataContainer.createNew();
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            DataQuery mapKey = DataSerializer.serializeMapKey(entry.getKey());
            map.set(mapKey, entry.getValue());
        }
        return map;
    }

    private static ImmutableList<Object> serializeCollection(DataView.SafetyMode safetyMode, Collection<?> value) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object object : value) {
            builder.add(DataSerializer.serialize(safetyMode, object));
        }
        return builder.build();
    }

    private static DataQuery serializeMapKey(Object value) {
        if (value instanceof DataQuery) {
            return (DataQuery)value;
        }
        if (value.getClass().isEnum()) {
            return DataQuery.of((String[])new String[]{((Enum)value).name()});
        }
        if (value instanceof UUID) {
            return DataQuery.of((String[])new String[]{value.toString()});
        }
        if (value instanceof ResourceKey) {
            return DataQuery.of((String[])new String[]{value.toString()});
        }
        if (value instanceof String) {
            return DataQuery.of((String[])new String[]{value.toString()});
        }
        if (value instanceof Integer) {
            return DataQuery.of((String[])new String[]{value.toString()});
        }
        Optional registryTypeFor = SpongeDataManager.INSTANCE.findRegistryTypeFor(value.getClass());
        if (registryTypeFor.isPresent()) {
            return DataQuery.of((String[])new String[]{((Registry)Sponge.game().findRegistry(registryTypeFor.get()).get()).valueKey(value).toString()});
        }
        throw new UnsupportedOperationException("Unsupported map-key type " + String.valueOf(value.getClass()));
    }

    private static @NonNull Object serializeArray(DataView.SafetyMode safetyMode, Object value) {
        switch (safetyMode) {
            case ALL_DATA_CLONED: 
            case CLONED_ON_SET: {
                break;
            }
            default: {
                return value;
            }
        }
        if (value instanceof byte[]) {
            return ArrayUtils.clone((byte[])((byte[])value));
        }
        if (value instanceof short[]) {
            return ArrayUtils.clone((short[])((short[])value));
        }
        if (value instanceof int[]) {
            return ArrayUtils.clone((int[])((int[])value));
        }
        if (value instanceof long[]) {
            return ArrayUtils.clone((long[])((long[])value));
        }
        if (value instanceof float[]) {
            return ArrayUtils.clone((float[])((float[])value));
        }
        if (value instanceof double[]) {
            return ArrayUtils.clone((double[])((double[])value));
        }
        if (value instanceof boolean[]) {
            return ArrayUtils.clone((boolean[])((boolean[])value));
        }
        return ArrayUtils.clone((Object[])((Object[])value));
    }
}

