/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.collect.ImmutableList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataView;

public final class DataUpdaterDelegate
implements DataContentUpdater {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ImmutableList<DataContentUpdater> updaters;
    private final int from;
    private final int to;

    public DataUpdaterDelegate(ImmutableList<DataContentUpdater> updaters, int from, int to) {
        this.updaters = updaters;
        this.from = from;
        this.to = to;
    }

    public int inputVersion() {
        return this.from;
    }

    public int outputVersion() {
        return this.to;
    }

    public DataView update(DataView content) {
        DataContainer copied;
        DataContainer updated = copied = content.copy();
        for (DataContentUpdater updater : this.updaters) {
            try {
                updated = (DataView)updater.update((Object)updated);
            }
            catch (Exception e) {
                LOGGER.error("There was error attempting to update some data for the content updater: {}\nThe original data is being returned, possibly causing issues later on, \nbut the original data should not be lost. Please notify the developer of this exception with the stacktrace.", (Object)updater.getClass().getName(), (Object)e);
                return copied;
            }
        }
        return updated;
    }
}

