/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.class_2487;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataStore;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.persistence.datastore.SpongeDataStore;
import org.spongepowered.common.util.Constants;

public final class DataUtil {
    public static void syncTagToData(Object dataHolder) {
        if (dataHolder instanceof SpongeDataHolderBridge && dataHolder instanceof DataCompoundHolder) {
            DataUtil.deserializeSpongeData((SpongeDataHolderBridge)((Object)((DataCompoundHolder)dataHolder)));
        }
    }

    public static boolean syncDataToTag(Object dataHolder) {
        if (dataHolder instanceof DataCompoundHolder) {
            return DataUtil.serializeSpongeData((DataCompoundHolder)((Object)((SpongeDataHolderBridge)dataHolder)));
        }
        return false;
    }

    public static <T extends SpongeDataHolderBridge & DataCompoundHolder> void deserializeSpongeData(T dataHolder) {
        class_2487 compound = ((DataCompoundHolder)dataHolder).data$getCompound();
        if (compound == null) {
            return;
        }
        DataContainer allData = NBTTranslator.INSTANCE.translate(compound);
        DataUtil.upgradeDataVersion(compound, allData);
        Class<DataHolder> typeToken = dataHolder.getClass().asSubclass(DataHolder.class);
        allData.getView(Constants.Sponge.Data.V3.SPONGE_DATA_ROOT).ifPresent(customData -> {
            for (DataQuery keyNamespace : customData.keys(false)) {
                DataView keyedData = (DataView)customData.getView(keyNamespace).get();
                for (DataQuery keyValue : keyedData.keys(false)) {
                    ResourceKey dataStoreKey = ResourceKey.of((String)keyNamespace.asString("."), (String)keyValue.asString("."));
                    DataView dataStoreData = (DataView)keyedData.getView(keyValue).get();
                    Integer contentVersion = dataStoreData.getInt(Constants.Sponge.Data.V3.CONTENT_VERSION).orElse(1);
                    Optional<DataStore> dataStore = SpongeDataManager.getDatastoreRegistry().getDataStore(dataStoreKey, (Type)typeToken);
                    if (dataStore.isPresent()) {
                        if (!(dataStore.get() instanceof SpongeDataStore)) continue;
                        ((SpongeDataStore)dataStore.get()).getUpdaterFor(contentVersion).ifPresent(updater -> {
                            dataStoreData.set(Constants.Sponge.Data.V3.CONTENT, updater.update((Object)((DataView)dataStoreData.getView(Constants.Sponge.Data.V3.CONTENT).get())));
                            SpongeCommon.logger().info("Updated datastore {} from {} to {} ", (Object)dataStoreKey.asString(), (Object)contentVersion, (Object)((SpongeDataStore)dataStore.get()).getVersion());
                        });
                        continue;
                    }
                    dataHolder.bridge$addFailedData(keyNamespace.then(keyValue), dataStoreData);
                }
            }
        });
        dataHolder.bridge$mergeDeserialized(DataManipulator.mutableOf());
        for (DataStore dataStore : SpongeDataManager.getDatastoreRegistry().getDataStoresForType(typeToken)) {
            DataManipulator.Mutable deserialized = dataStore.deserialize((DataView)allData);
            try {
                dataHolder.bridge$mergeDeserialized(deserialized);
            }
            catch (Exception e) {
                SpongeCommon.logger().error("Could not merge data from datastore: {}", (Object)deserialized, (Object)e);
            }
        }
    }

    public static void upgradeDataVersion(class_2487 compound, DataContainer allData) {
        allData.getView(Constants.Forge.FORGE_DATA_ROOT).flatMap(forgeData -> forgeData.getView(Constants.Sponge.Data.V2.SPONGE_DATA_ROOT)).ifPresent(spongeDataV2 -> DataUtil.upgradeV2CustomData(compound, allData, spongeDataV2));
    }

    private static void upgradeV2CustomData(class_2487 compound, DataContainer allData, DataView spongeDataV2) {
        DataContainer spongeDataV3 = DataContainer.createNew();
        for (DataView customDataV2 : spongeDataV2.getViewList(Constants.Sponge.Data.V2.CUSTOM_MANIPULATOR_LIST).orElse(Collections.emptyList())) {
            try {
                String id = (String)customDataV2.getString(Constants.Sponge.Data.V2.MANIPULATOR_ID).get();
                Object data = customDataV2.get(Constants.Sponge.Data.V2.MANIPULATOR_DATA).get();
                Integer contentVersion = (Integer)customDataV2.getInt(Queries.CONTENT_VERSION).get();
                ResourceKey key = SpongeDataManager.INSTANCE.getLegacyRegistration(id).orElse(ResourceKey.resolve((String)id));
                DataView dataStoreData = spongeDataV3.createView(DataQuery.of((String[])new String[]{key.namespace(), key.value()}));
                dataStoreData.set(Constants.Sponge.Data.V3.CONTENT_VERSION, (Object)contentVersion);
                dataStoreData.set(Constants.Sponge.Data.V3.CONTENT, data);
                SpongeCommon.logger().info("Upgraded custom data for datastore: {}", (Object)key);
            }
            catch (Exception e) {
                SpongeCommon.logger().error("Error when upgrading V2 custom data", (Throwable)e);
            }
        }
        spongeDataV2.remove(Constants.Sponge.Data.V2.CUSTOM_MANIPULATOR_LIST);
        for (DataQuery spongeDataKey : spongeDataV2.keys(false)) {
            DataQuery query = SpongeDataManager.INSTANCE.legacySpongeDataQuery(spongeDataKey.toString());
            if (query == null) {
                SpongeCommon.logger().error("Missing legacy sponge data query mapping {}", (Object)spongeDataKey.toString());
                continue;
            }
            Object value = spongeDataV2.get(spongeDataKey).get();
            SpongeCommon.logger().info("Upgraded sponge data: {}->{} type {}", (Object)spongeDataKey.toString(), (Object)query.toString(), (Object)value.getClass().getSimpleName());
            spongeDataV3.set(query, value);
        }
        allData.set(Constants.Sponge.Data.V3.SPONGE_DATA_ROOT, (Object)spongeDataV3);
        allData.getView(Constants.Forge.FORGE_DATA_ROOT).ifPresent(forgeData -> {
            forgeData.remove(Constants.Sponge.Data.V2.SPONGE_DATA_ROOT);
            if (forgeData.isEmpty()) {
                allData.remove(Constants.Forge.FORGE_DATA_ROOT);
            }
        });
        if (compound.method_10545("ForgeData")) {
            class_2487 forgeData2 = compound.method_10562("ForgeData");
            forgeData2.method_10551("SpongeData");
            if (forgeData2.method_33133()) {
                compound.method_10551("ForgeData");
            }
        }
    }

    public static <T extends SpongeDataHolderBridge & DataCompoundHolder> boolean serializeSpongeData(T dataHolder) {
        class_2487 compound = ((DataCompoundHolder)dataHolder).data$getCompound();
        compound = compound == null ? new class_2487() : compound.method_10553();
        ((DataCompoundHolder)dataHolder).data$setCompound(compound);
        compound.method_10551(Constants.Sponge.Data.V3.SPONGE_DATA_ROOT.asString("."));
        DataContainer allData = NBTTranslator.INSTANCE.translate(compound);
        DataView customDataRoot = allData.createView(Constants.Sponge.Data.V3.SPONGE_DATA_ROOT);
        dataHolder.bridge$getFailedData().forEach((arg_0, arg_1) -> ((DataView)customDataRoot).set(arg_0, arg_1));
        DataManipulator.Mutable manipulator = dataHolder.bridge$getManipulator();
        Class<?> dataHolderType = dataHolder.getClass();
        manipulator.getKeys().stream().map(key -> SpongeDataManager.getDatastoreRegistry().getDataStore((Key<?>)key, (Type)dataHolderType)).forEach(dataStore -> dataStore.serialize((DataManipulator)manipulator, (DataView)allData));
        if (DataUtil.cleanupEmptySpongeData(allData)) {
            compound.method_10543(NBTTranslator.INSTANCE.translate((DataView)allData));
        }
        if (compound.method_33133()) {
            ((DataCompoundHolder)dataHolder).data$setCompound(null);
            return false;
        }
        return true;
    }

    private static boolean cleanupEmptySpongeData(DataContainer allData) {
        return allData.getView(Constants.Sponge.Data.V3.SPONGE_DATA_ROOT).map(spongeData -> {
            if (spongeData.isEmpty()) {
                allData.remove(Constants.Sponge.Data.V3.SPONGE_DATA_ROOT);
                return false;
            }
            return true;
        }).orElse(false);
    }

    public static void setSpongeData(DataView allData, DataQuery dataStoreKey, DataView pluginData, int version) {
        DataQuery dataStoreDataQuery = Constants.Sponge.Data.V3.SPONGE_DATA_ROOT.then(dataStoreKey);
        DataView dataStoreDataView = allData.getView(dataStoreDataQuery).orElseGet(() -> allData.createView(dataStoreDataQuery));
        dataStoreDataView.set(Constants.Sponge.Data.V3.CONTENT_VERSION, (Object)version);
        dataStoreDataView.set(Constants.Sponge.Data.V3.CONTENT, (Object)pluginData);
    }

    public static Optional<DataView> getSpongeData(DataView allData, DataQuery dataStoreKey, int version) {
        return allData.getView(Constants.Sponge.Data.V3.SPONGE_DATA_ROOT.then(dataStoreKey).then(Constants.Sponge.Data.V3.CONTENT));
    }
}

