/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataHolderBuilder;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.meta.BannerPatternLayer;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataStore;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.event.EventListenerRegistration;
import org.spongepowered.api.event.data.ChangeDataHolderEvent;
import org.spongepowered.api.fluid.FluidStack;
import org.spongepowered.api.fluid.FluidStackSnapshot;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.merchant.TradeOffer;
import org.spongepowered.api.map.MapCanvas;
import org.spongepowered.api.map.decoration.MapDecoration;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.util.RespawnLocation;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockStateBuilder;
import org.spongepowered.common.block.entity.SpongeBlockEntityArchetypeBuilder;
import org.spongepowered.common.data.DataUpdaterDelegate;
import org.spongepowered.common.data.MemoryDataContainer;
import org.spongepowered.common.data.SpongeDataRegistration;
import org.spongepowered.common.data.builder.item.SpongeFireworkEffectDataBuilder;
import org.spongepowered.common.data.builder.item.SpongeItemStackSnapshotDataBuilder;
import org.spongepowered.common.data.builder.meta.SpongePatternLayerBuilder;
import org.spongepowered.common.data.builder.util.weighted.BaseAndAdditionBuilder;
import org.spongepowered.common.data.builder.util.weighted.BaseAndVarianceBuilder;
import org.spongepowered.common.data.builder.util.weighted.FixedBuilder;
import org.spongepowered.common.data.builder.util.weighted.OptionalVarianceBuilder;
import org.spongepowered.common.data.datasync.entity.EntityAirSupplyConverter;
import org.spongepowered.common.data.datasync.entity.EntityBabyConverter;
import org.spongepowered.common.data.datasync.entity.EntityCustomNameConverter;
import org.spongepowered.common.data.datasync.entity.EntityCustomNameVisibleConverter;
import org.spongepowered.common.data.datasync.entity.EntityFlagsConverter;
import org.spongepowered.common.data.datasync.entity.EntityNoGravityConverter;
import org.spongepowered.common.data.datasync.entity.EntitySilentConverter;
import org.spongepowered.common.data.datasync.entity.LivingEntityArrowCountConverter;
import org.spongepowered.common.data.datasync.entity.LivingHealthConverter;
import org.spongepowered.common.data.datasync.entity.MobEntityAIFlagsConverter;
import org.spongepowered.common.data.key.KeyBasedDataListener;
import org.spongepowered.common.data.persistence.datastore.DataStoreRegistry;
import org.spongepowered.common.data.provider.CustomDataProvider;
import org.spongepowered.common.data.provider.DataProviderRegistry;
import org.spongepowered.common.effect.particle.SpongeParticleEffectBuilder;
import org.spongepowered.common.effect.potion.SpongePotionBuilder;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;
import org.spongepowered.common.fluid.SpongeFluidStackBuilder;
import org.spongepowered.common.fluid.SpongeFluidStackSnapshotBuilder;
import org.spongepowered.common.item.SpongeItemStack;
import org.spongepowered.common.item.enchantment.SpongeEnchantmentBuilder;
import org.spongepowered.common.item.merchant.SpongeTradeOfferBuilder;
import org.spongepowered.common.map.canvas.SpongeMapCanvasDataBuilder;
import org.spongepowered.common.map.decoration.SpongeMapDecorationDataBuilder;
import org.spongepowered.common.profile.SpongeGameProfileDataBuilder;
import org.spongepowered.common.profile.SpongeProfilePropertyDataBuilder;
import org.spongepowered.common.registry.provider.DataTranslatorProvider;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;
import org.spongepowered.common.world.server.SpongeServerLocationBuilder;

@Singleton
public final class SpongeDataManager
implements DataManager {
    public static SpongeDataManager INSTANCE;
    private final DataStoreRegistry dataStoreRegistry;
    private final DataProviderRegistry dataProviderRegistry;
    private final Map<Class<?>, DataBuilder<?>> builders;
    private final Map<Class<? extends DataHolder.Immutable<?>>, DataHolderBuilder.Immutable<?, ?>> immutableDataBuilderMap;
    private final Map<Class<? extends DataSerializable>, List<DataContentUpdater>> updatersMap;
    private final List<DataContentUpdater> customDataUpdaters;
    private final Map<String, ResourceKey> legacyRegistrations;
    private final List<KeyBasedDataListener<?>> keyListeners;
    private final Map<String, DataQuery> legacySpongeData = new HashMap<String, DataQuery>();
    private Map<Class<?>, RegistryType<?>> registryTypeMap;

    @Inject
    private SpongeDataManager() {
        INSTANCE = this;
        this.dataStoreRegistry = new DataStoreRegistry();
        this.dataProviderRegistry = new DataProviderRegistry();
        this.builders = new HashMap();
        this.immutableDataBuilderMap = new MapMaker().concurrencyLevel(4).makeMap();
        this.updatersMap = new IdentityHashMap<Class<? extends DataSerializable>, List<DataContentUpdater>>();
        this.customDataUpdaters = new ArrayList<DataContentUpdater>();
        this.legacyRegistrations = new HashMap<String, ResourceKey>();
        this.keyListeners = new ArrayList();
        this.updatersMap.put((Class<? extends DataSerializable>)ItemStack.class, (List<DataContentUpdater>)SpongeItemStack.STACK_UPDATERS);
        this.updatersMap.put((Class<? extends DataSerializable>)ItemStackSnapshot.class, (List<DataContentUpdater>)SpongeItemStack.STACK_UPDATERS);
    }

    public <T extends DataSerializable> void registerBuilder(Class<T> clazz, DataBuilder<T> builder) {
        Objects.requireNonNull(builder);
        if (this.builders.putIfAbsent(clazz, builder) != null) {
            SpongeCommon.logger().warn("A DataBuilder has already been registered for {}. Attempted to register {} instead.", clazz, (Object)builder.getClass());
        } else if (!(builder instanceof AbstractDataBuilder)) {
            SpongeCommon.logger().warn("A custom DataBuilder is not extending AbstractDataBuilder! It is recommended that the custom data builder does extend it to gain automated content versioning updates and maintain simplicity. The offending builder's class is: {}", (Object)builder.getClass());
        }
    }

    public <T extends DataSerializable> void registerContentUpdater(Class<T> clazz, DataContentUpdater updater) {
        Objects.requireNonNull(updater);
        List updaters = this.updatersMap.computeIfAbsent(clazz, k -> new ArrayList());
        updaters.add(updater);
        updaters.sort(Constants.Functional.DATA_CONTENT_UPDATER_COMPARATOR);
    }

    public void registerCustomDataContentUpdater(DataContentUpdater updater) {
        this.customDataUpdaters.add(updater);
    }

    public <T extends DataSerializable> Optional<DataContentUpdater> wrappedContentUpdater(Class<T> clazz, int fromVersion, int toVersion) {
        if (fromVersion == toVersion) {
            throw new IllegalArgumentException("Attempting to convert to the same version!");
        }
        if (fromVersion > toVersion) {
            throw new IllegalArgumentException("Attempting to backwards convert data! This isn't supported! " + fromVersion + " -> " + toVersion);
        }
        List<DataContentUpdater> updaters = this.updatersMap.get(clazz);
        if (updaters == null) {
            return Optional.empty();
        }
        return SpongeDataManager.getWrappedContentUpdater(clazz, fromVersion, toVersion, updaters);
    }

    public Optional<DataContentUpdater> getWrappedCustomContentUpdater(Class<DataManipulator.Mutable> mutableClass, int version, int currentCustomData) {
        return SpongeDataManager.getWrappedContentUpdater(mutableClass, version, currentCustomData, this.customDataUpdaters);
    }

    private static Optional<DataContentUpdater> getWrappedContentUpdater(Class<?> clazz, int fromVersion, int toVersion, List<DataContentUpdater> updaters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int version = fromVersion;
        for (DataContentUpdater updater : updaters) {
            if (updater.inputVersion() != version || updater.outputVersion() > toVersion) continue;
            version = updater.outputVersion();
            builder.add((Object)updater);
        }
        if (version < fromVersion || version > toVersion) {
            SpongeCommon.logger().warn("The requested content version for: {} was requested, \nhowever, the versions supplied: from {} to {} is impossible\nas the latest version registered is: {}. Please notify the developer of\nthe requested consumed DataSerializable of this error.", (Object)clazz.getSimpleName(), (Object)fromVersion, (Object)toVersion, (Object)version);
            return Optional.empty();
        }
        return Optional.of(new DataUpdaterDelegate((ImmutableList<DataContentUpdater>)builder.build(), fromVersion, toVersion));
    }

    public <T extends DataSerializable> Optional<DataBuilder<T>> builder(Class<T> clazz) {
        DataBuilder<?> dataBuilder = this.builders.get(clazz);
        if (dataBuilder != null) {
            return Optional.of(dataBuilder);
        }
        return Optional.ofNullable((DataBuilder)this.immutableDataBuilderMap.get(clazz));
    }

    public <T extends DataSerializable> Optional<T> deserialize(Class<T> clazz, DataView dataView) {
        Objects.requireNonNull(dataView);
        return this.builder(clazz).flatMap(builder -> builder.build(dataView));
    }

    public <T extends DataHolder.Immutable<T>, B extends DataHolderBuilder.Immutable<T, B>> void register(Class<T> holderClass, B builder) {
        Objects.requireNonNull(builder);
        DataHolderBuilder.Immutable<?, ?> previous = this.immutableDataBuilderMap.putIfAbsent(holderClass, builder);
        if (previous != null) {
            throw new IllegalStateException("Already registered the DataUtil for " + holderClass.getCanonicalName());
        }
    }

    public <T extends DataHolder.Immutable<T>, B extends DataHolderBuilder.Immutable<T, B>> Optional<B> immutableBuilder(Class<T> holderClass) {
        return Optional.ofNullable(this.immutableDataBuilderMap.get(Objects.requireNonNull(holderClass)));
    }

    public <T> Optional<DataTranslator<T>> translator(Class<T> objectClass) {
        return DataTranslatorProvider.INSTANCE.getSerializer(objectClass);
    }

    public <T> void registerTranslator(Class<T> objectClass, DataTranslator<T> translator) {
        DataTranslatorProvider.INSTANCE.register(objectClass, translator);
    }

    public void registerKeyListeners() {
        this.keyListeners.forEach(this::registerKeyListener0);
        this.keyListeners.clear();
    }

    private void registerKeyListener0(KeyBasedDataListener<?> listener) {
        Sponge.eventManager().registerListener(EventListenerRegistration.builder(ChangeDataHolderEvent.ValueChange.class).plugin(listener.getOwner()).listener(listener).build());
    }

    public void registerLegacyManipulatorIds(String legacyId, ResourceKey dataStoreKey) {
        Objects.requireNonNull(legacyId);
        Objects.requireNonNull(dataStoreKey);
        ResourceKey previous = this.legacyRegistrations.putIfAbsent(legacyId, dataStoreKey);
        if (previous != null) {
            throw new IllegalStateException("Legacy registration id already registered: id" + legacyId + " for registration: " + String.valueOf(dataStoreKey));
        }
    }

    public Optional<ResourceKey> getLegacyRegistration(String id) {
        return Optional.ofNullable(this.legacyRegistrations.get(id));
    }

    public DataContainer createContainer() {
        return new MemoryDataContainer();
    }

    public DataContainer createContainer(DataView.SafetyMode safety) {
        return new MemoryDataContainer(safety);
    }

    public <E extends DataHolder> void registerKeyListener(KeyBasedDataListener<E> keyListener) {
        Objects.requireNonNull(keyListener);
        this.keyListeners.add(keyListener);
    }

    public void registerCustomDataRegistration(SpongeDataRegistration registration) {
        for (DataStore dataStore : registration.getDataStores()) {
            this.dataStoreRegistry.register(dataStore, registration.keys());
        }
        for (Key key : registration.keys()) {
            this.registerCustomDataProviderForKey(registration, key);
        }
    }

    private <V extends Value<E>, E> void registerCustomDataProviderForKey(SpongeDataRegistration registration, Key<V> key) {
        Collection providers = registration.providersFor(key);
        HashSet<Type> dataStoreSupportedTokens = new HashSet<Type>();
        this.dataStoreRegistry.getDataStores(key).stream().map(DataStore::supportedTypes).forEach(dataStoreSupportedTokens::addAll);
        for (DataProvider provider : providers) {
            this.dataProviderRegistry.register(provider);
            dataStoreSupportedTokens.removeIf(arg_0 -> provider.isSupported(arg_0));
        }
        if (!dataStoreSupportedTokens.isEmpty()) {
            this.dataProviderRegistry.register(new CustomDataProvider(key, dataStoreSupportedTokens));
        }
    }

    public void registerDataRegistration(SpongeDataRegistration registration) {
        for (DataStore dataStore : registration.getDataStores()) {
            this.dataStoreRegistry.register(dataStore, registration.keys());
        }
        for (Key key : registration.keys()) {
            Collection providers = registration.providersFor(key);
            for (DataProvider provider : providers) {
                this.dataProviderRegistry.register(provider);
            }
        }
    }

    public void registerDefaultProviders() {
        this.dataProviderRegistry.registerDefaultProviders();
        new EntityAirSupplyConverter();
        new EntityBabyConverter();
        new EntityCustomNameConverter();
        new EntityCustomNameVisibleConverter();
        new EntityFlagsConverter();
        new EntityNoGravityConverter();
        new EntitySilentConverter();
        new LivingEntityArrowCountConverter();
        new LivingHealthConverter();
        new MobEntityAIFlagsConverter();
    }

    public static DataStoreRegistry getDatastoreRegistry() {
        return SpongeDataManager.INSTANCE.dataStoreRegistry;
    }

    public static DataProviderRegistry getProviderRegistry() {
        return SpongeDataManager.INSTANCE.dataProviderRegistry;
    }

    public void registerDefaultBuilders() {
        this.registerBuilder((Class)ItemStack.class, (DataBuilder)new SpongeItemStack.BuilderImpl());
        this.registerBuilder(ItemStackSnapshot.class, new SpongeItemStackSnapshotDataBuilder());
        this.registerBuilder((Class)EntitySnapshot.class, (DataBuilder)new SpongeEntitySnapshotBuilder());
        this.registerBuilder((Class)EntityArchetype.class, (DataBuilder)SpongeEntityArchetypeBuilder.unpooled());
        this.registerBuilder((Class)BlockState.class, (DataBuilder)new SpongeBlockStateBuilder());
        this.registerBuilder((Class)MapDecoration.class, (DataBuilder)new SpongeMapDecorationDataBuilder());
        this.registerBuilder((Class)MapCanvas.class, (DataBuilder)new SpongeMapCanvasDataBuilder());
        this.registerBuilder((Class)ServerLocation.class, (DataBuilder)new SpongeServerLocationBuilder());
        this.registerBuilder((Class)GameProfile.class, (DataBuilder)new SpongeGameProfileDataBuilder());
        this.registerBuilder((Class)ProfileProperty.class, (DataBuilder)new SpongeProfilePropertyDataBuilder());
        this.registerBuilder((Class)Color.class, (DataBuilder)new Color.Builder());
        this.registerBuilder((Class)RespawnLocation.class, (DataBuilder)new RespawnLocation.Builder());
        this.registerBuilder((Class)BlockSnapshot.class, (DataBuilder)SpongeBlockSnapshot.BuilderImpl.unpooled());
        this.registerBuilder((Class)BlockEntityArchetype.class, (DataBuilder)SpongeBlockEntityArchetypeBuilder.unpooled());
        this.registerBuilder(FireworkEffect.class, new SpongeFireworkEffectDataBuilder());
        this.registerBuilder(BannerPatternLayer.class, new SpongePatternLayerBuilder());
        this.registerBuilder((Class)VariableAmount.BaseAndAddition.class, (DataBuilder)new BaseAndAdditionBuilder());
        this.registerBuilder((Class)VariableAmount.BaseAndVariance.class, (DataBuilder)new BaseAndVarianceBuilder());
        this.registerBuilder((Class)VariableAmount.Fixed.class, (DataBuilder)new FixedBuilder());
        this.registerBuilder((Class)VariableAmount.OptionalAmount.class, (DataBuilder)new OptionalVarianceBuilder());
        this.registerBuilder((Class)ParticleEffect.class, (DataBuilder)new SpongeParticleEffectBuilder());
        this.registerBuilder((Class)PotionEffect.class, (DataBuilder)new SpongePotionBuilder());
        this.registerBuilder((Class)FluidStack.class, (DataBuilder)new SpongeFluidStackBuilder());
        this.registerBuilder((Class)FluidStackSnapshot.class, (DataBuilder)new SpongeFluidStackSnapshotBuilder());
        this.registerBuilder((Class)Enchantment.class, (DataBuilder)new SpongeEnchantmentBuilder());
        this.registerBuilder(TradeOffer.class, new SpongeTradeOfferBuilder());
        this.registerBuilder((Class)LocatableBlock.class, (DataBuilder)new SpongeLocatableBlockBuilder());
    }

    public Optional<DataStore> getDataStore(ResourceKey key, Class<? extends DataHolder> typeToken) {
        return this.dataStoreRegistry.getDataStore(key, typeToken);
    }

    public <T> Optional<RegistryType<T>> findRegistryTypeFor(Class type) {
        RegistryType<?> directMatch;
        if (this.registryTypeMap == null) {
            this.registryTypeMap = new HashMap();
            this.registryTypeMap.put(ItemType.class, (RegistryType<?>)RegistryTypes.ITEM_TYPE);
            this.registryTypeMap.put(ParticleType.class, (RegistryType<?>)RegistryTypes.PARTICLE_TYPE);
            this.registryTypeMap.put(ParticleOption.class, (RegistryType<?>)RegistryTypes.PARTICLE_OPTION);
            this.registryTypeMap.put(PotionEffectType.class, (RegistryType<?>)RegistryTypes.POTION_EFFECT_TYPE);
        }
        if ((directMatch = this.registryTypeMap.get(type)) != null) {
            return Optional.of(directMatch);
        }
        for (Map.Entry<Class<?>, RegistryType<?>> entry : this.registryTypeMap.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            this.registryTypeMap.put(type, entry.getValue());
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public void registerLegacySpongeData(String nbtKey, ResourceKey dataStoreKey, Key<? extends Value<?>> dataKey) {
        this.legacySpongeData.put(nbtKey, DataQuery.of((String[])new String[]{dataStoreKey.namespace(), dataStoreKey.value()}).then(Constants.Sponge.Data.V3.CONTENT).then(dataKey.key().value()));
    }

    public @Nullable DataQuery legacySpongeDataQuery(String nbtKey) {
        return this.legacySpongeData.get(nbtKey);
    }
}

