/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.KeyValueMatcher;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.data.SpongeKeyValueMatcher;
import org.spongepowered.common.util.Constants;

public final class SpongeKeyValueMatcherBuilder<V>
implements KeyValueMatcher.Builder<V> {
    private KeyValueMatcher.Operator operator = KeyValueMatcher.Operator.EQUAL;
    private @Nullable Key<? extends Value<V>> key;
    private @Nullable V value;

    public <NV> KeyValueMatcher.Builder<NV> key(Key<? extends Value<NV>> key) {
        Objects.requireNonNull(key, "key");
        this.key = key;
        return this;
    }

    public KeyValueMatcher.Builder<V> operator(KeyValueMatcher.Operator operator) {
        Objects.requireNonNull(operator, "operator");
        this.operator = operator;
        return this;
    }

    public KeyValueMatcher.Builder<V> value(@Nullable V value) {
        this.value = value;
        return this;
    }

    public KeyValueMatcher.Builder<V> value(@Nullable Value<? extends V> value) {
        this.value = value == null ? null : value.get();
        return this;
    }

    public KeyValueMatcher.Builder<V> from(KeyValueMatcher<V> value) {
        this.key = value.key();
        this.value = value.value().orElse(null);
        this.operator = value.operator();
        return this;
    }

    public KeyValueMatcher.Builder<V> reset() {
        this.key = null;
        this.operator = KeyValueMatcher.Operator.EQUAL;
        this.value = null;
        return this;
    }

    public KeyValueMatcher<V> build() {
        Objects.requireNonNull(this.key, "The key must be set");
        return new SpongeKeyValueMatcher<V>(this.key, this.operator, this.value);
    }

    public Optional<KeyValueMatcher<V>> build(DataView container) throws InvalidDataException {
        Objects.requireNonNull(container, "container");
        Optional optKey = container.getDataKey(Constants.KeyValueMatcher.KEY);
        if (!optKey.isPresent()) {
            return Optional.empty();
        }
        Key key = (Key)optKey.get();
        Optional<KeyValueMatcher.Operator> operator = container.getString(Constants.KeyValueMatcher.OPERATOR).map(s -> KeyValueMatcher.Operator.valueOf((String)s.toUpperCase()));
        if (!operator.isPresent()) {
            return Optional.empty();
        }
        Optional value = container.getObject(Constants.KeyValueMatcher.VALUE, GenericTypeReflector.erase((Type)key.elementType()));
        if (!value.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new SpongeKeyValueMatcher<Object>(key, operator.get(), value.orElse(null)));
    }
}

