/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.meta;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1767;
import net.minecraft.class_2582;
import net.minecraft.class_6880;
import net.minecraft.class_9307;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.meta.BannerPatternLayer;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.type.BannerPatternShape;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.Preconditions;

public final class SpongePatternLayerBuilder
extends AbstractDataBuilder<BannerPatternLayer>
implements BannerPatternLayer.Builder,
DataBuilder<BannerPatternLayer> {
    private DyeColor color;
    private BannerPatternShape shape;

    public SpongePatternLayerBuilder() {
        super(BannerPatternLayer.class, 1);
    }

    protected Optional<BannerPatternLayer> buildContent(DataView container) throws InvalidDataException {
        Objects.requireNonNull(container);
        if (!container.contains(Constants.TileEntity.Banner.SHAPE) || !container.contains(Constants.TileEntity.Banner.COLOR)) {
            return Optional.empty();
        }
        BannerPatternShape shape = (BannerPatternShape)container.getRegistryValue(Constants.TileEntity.Banner.SHAPE, (RegistryType)RegistryTypes.BANNER_PATTERN_SHAPE, (RegistryHolder)Sponge.game()).orElseThrow(() -> new InvalidDataException("The provided container has an invalid banner pattern shape entry!"));
        DyeColor color = (DyeColor)container.getRegistryValue(Constants.TileEntity.Banner.COLOR, (RegistryType)RegistryTypes.DYE_COLOR, (RegistryHolder)Sponge.game()).orElseThrow(() -> new InvalidDataException("The provided container has an invalid dye color entry!"));
        class_6880 mcPattern = class_6880.method_40223((Object)((class_2582)shape));
        return Optional.of((BannerPatternLayer)new class_9307.class_9308(mcPattern, (class_1767)color));
    }

    public SpongePatternLayerBuilder reset() {
        this.shape = null;
        this.color = null;
        return this;
    }

    public BannerPatternLayer.Builder pattern(BannerPatternShape shape) {
        this.shape = Objects.requireNonNull(shape);
        return this;
    }

    public BannerPatternLayer.Builder color(DyeColor color) {
        this.color = Objects.requireNonNull(color);
        return this;
    }

    public BannerPatternLayer.Builder from(BannerPatternLayer value) {
        this.shape = value.shape();
        this.color = value.color();
        return this;
    }

    public BannerPatternLayer build() {
        Preconditions.checkState(this.shape != null);
        Preconditions.checkState(this.color != null);
        class_6880 mcPattern = class_6880.method_40223((Object)((class_2582)this.shape));
        return (BannerPatternLayer)new class_9307.class_9308(mcPattern, (class_1767)this.color);
    }
}

