/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.datasync.entity;

import java.util.Optional;
import net.minecraft.class_1297;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.accessor.world.entity.MobAccessor;
import org.spongepowered.common.data.datasync.DataParameterConverter;

public final class MobEntityAIFlagsConverter
extends DataParameterConverter<Byte> {
    public static final int NO_AI_MASK = 1;
    public static final int LEFT_HANDED_MASK = 2;
    public static final int AGGRESSIVE_MASK = 4;

    public MobEntityAIFlagsConverter() {
        super(MobAccessor.accessor$DATA_MOB_FLAGS_ID());
    }

    @Override
    public Optional<DataTransactionResult> createTransaction(class_1297 entity, Byte currentValue, Byte value) {
        boolean noAi = this.getFlag(currentValue, 1);
        boolean leftHanded = this.getFlag(currentValue, 2);
        boolean aggressive = this.getFlag(currentValue, 4);
        boolean newNoAi = this.getFlag(value, 1);
        boolean newLeftHanded = this.getFlag(value, 2);
        boolean newAggressive = this.getFlag(value, 4);
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        boolean changed = false;
        if (noAi != newNoAi) {
            builder.replace(Value.immutableOf((Key)Keys.IS_AI_ENABLED, (Object)(!noAi ? 1 : 0)));
            builder.success(Value.immutableOf((Key)Keys.IS_AI_ENABLED, (Object)(!newNoAi ? 1 : 0)));
            changed = true;
        }
        builder.result(DataTransactionResult.Type.SUCCESS);
        return changed ? Optional.of(builder.build()) : Optional.empty();
    }

    @Override
    public Byte getValueFromEvent(Byte originalValue, DataTransactionResult result) {
        if (result.successfulData().isEmpty()) {
            return originalValue;
        }
        boolean noAi = result.successfulValue(Keys.IS_AI_ENABLED).map(v -> (Boolean)v.get() == false).orElseGet(() -> this.getFlag(originalValue, 1));
        boolean leftHanded = this.getFlag(originalValue, 2);
        boolean aggressive = this.getFlag(originalValue, 4);
        byte newValue = (byte)(noAi ? 1 : 0);
        newValue = (byte)(newValue | (byte)(leftHanded ? 2 : 0));
        newValue = (byte)(newValue | (byte)(aggressive ? 4 : 0));
        return newValue;
    }

    private boolean getFlag(byte value, int mask) {
        return (value & mask) != 0;
    }
}

