/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.fixer.world;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import net.minecraft.class_1208;

public final class SpongeLevelFixer
extends DataFix {
    public SpongeLevelFixer(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public TypeRewriteRule makeRule() {
        Type levelType = this.getOutputSchema().getType(class_1208.field_5710);
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("FixWorldUniqueId", levelType, SpongeLevelFixer::updateUUIDIn), (TypeRewriteRule)this.fixTypeEverywhereTyped("FixPlayerIdTable", levelType, type -> this.fixPlayerIdTable((Typed<?>)type, (Type<?>)levelType)));
    }

    private Typed<?> fixPlayerIdTable(Typed<?> typed, Type<?> levelType) {
        Type fieldType = levelType.findFieldType("PlayerIdTable");
        OpticFinder listFinder = DSL.fieldFinder((String)"PlayerIdTable", (Type)((List.ListType)fieldType));
        Typed listTyped = typed.getTyped(listFinder);
        return listTyped.updateRecursiveTyped(DSL.remainderFinder(), SpongeLevelFixer::updateUUIDIn);
    }

    public static Typed<?> updateUUIDIn(Typed<?> typed) {
        return typed.update(DSL.remainderFinder(), data -> {
            long least = data.get("uuid_least").asLong(0L);
            long most = data.get("uuid_most").asLong(0L);
            if (least != 0L && most != 0L) {
                return data.remove("uuid_least").remove("uuid_most").set("UUIDMost", data.createLong(most)).set("UUIDLeast", data.createLong(least));
            }
            return data;
        });
    }
}

