/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.holder;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.CollectionDataProvider;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.CollectionValue;
import org.spongepowered.api.data.value.MapValue;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.common.data.holder.SpongeDataHolder;
import org.spongepowered.common.data.key.SpongeKey;
import org.spongepowered.common.util.DataUtil;

public interface SpongeMutableDataHolder
extends SpongeDataHolder,
DataHolder.Mutable {
    default public List<DataHolder.Mutable> impl$mutableDelegateDataHolder() {
        return this.impl$delegateDataHolder().stream().filter(dh -> dh instanceof DataHolder.Mutable).map(DataHolder.Mutable.class::cast).collect(Collectors.toList());
    }

    default public <E, V extends Value<E>> DataTransactionResult impl$applyTransaction(Key<V> key, BiFunction<DataProvider<V, E>, DataHolder.Mutable, DataTransactionResult> function, Supplier<DataTransactionResult> defaultResult) {
        for (DataHolder.Mutable dataHolder : this.impl$mutableDelegateDataHolder()) {
            DataProvider dataProvider = this.impl$getProviderFor(key, (DataHolder)dataHolder);
            if (!dataProvider.isSupported((DataHolder)dataHolder)) continue;
            return function.apply(dataProvider, dataHolder);
        }
        return defaultResult.get();
    }

    default public <E> DataTransactionResult offer(Key<? extends Value<E>> key, E value) {
        return this.impl$applyTransaction(key, (p, m) -> p.offer(m, value), () -> DataTransactionResult.failResult((Value.Immutable)Value.immutableOf((Key)key, (Object)value)));
    }

    default public DataTransactionResult offer(Value<?> value) {
        return this.impl$applyTransaction(value.key(), (p, m) -> p.offerValue(m, value), () -> DataTransactionResult.failResult((Value.Immutable)value.asImmutable()));
    }

    default public <E> DataTransactionResult offerSingle(Key<? extends CollectionValue<E, ?>> key, E element) {
        SpongeKey key0 = (SpongeKey)key;
        return this.impl$applyTransaction(key0, (p, m) -> {
            if (p instanceof CollectionDataProvider) {
                return ((CollectionDataProvider)p).offerSingle(m, element);
            }
            Collection collection = p.get((DataHolder)m).map(DataUtil::ensureMutable).orElseGet(key0.getDefaultValueSupplier());
            if (!collection.add(element)) {
                return DataTransactionResult.failNoData();
            }
            return p.offer(m, (Object)collection);
        }, DataTransactionResult::failNoData);
    }

    default public <E> DataTransactionResult offerAll(Key<? extends CollectionValue<E, ?>> key, Collection<? extends E> elements) {
        SpongeKey key0 = (SpongeKey)key;
        return this.impl$applyTransaction(key0, (p, m) -> {
            Collection collection = p.get((DataHolder)m).map(DataUtil::ensureMutable).orElseGet(key0.getDefaultValueSupplier());
            if (!collection.addAll(elements)) {
                return DataTransactionResult.failNoData();
            }
            return p.offer(m, (Object)collection);
        }, DataTransactionResult::failNoData);
    }

    default public <K, V> DataTransactionResult offerSingle(Key<? extends MapValue<K, V>> key, K valueKey, V value) {
        return this.impl$applyTransaction(key, (p, m) -> {
            Map kvMap = p.get((DataHolder)m).map(DataUtil::ensureMutable).orElseGet(((SpongeKey)key).getDefaultValueSupplier());
            kvMap.put(valueKey, value);
            return p.offer(m, (Object)kvMap);
        }, DataTransactionResult::failNoData);
    }

    default public <K, V> DataTransactionResult offerAll(Key<? extends MapValue<K, V>> key, Map<? extends K, ? extends V> values) {
        if (values.isEmpty()) {
            return DataTransactionResult.failNoData();
        }
        return this.impl$applyTransaction(key, (p, m) -> {
            Map kvMap = p.get((DataHolder)m).map(DataUtil::ensureMutable).orElseGet(((SpongeKey)key).getDefaultValueSupplier());
            kvMap.putAll(values);
            return p.offer(m, (Object)kvMap);
        }, DataTransactionResult::failNoData);
    }

    default public <E> DataTransactionResult removeSingle(Key<? extends CollectionValue<E, ?>> key, E element) {
        SpongeKey key0 = (SpongeKey)key;
        return this.impl$applyTransaction(key0, (p, m) -> {
            if (p instanceof CollectionDataProvider) {
                return ((CollectionDataProvider)p).removeSingle(m, element);
            }
            Optional<Collection> optCollection = p.get((DataHolder)m).map(DataUtil::ensureMutable);
            if (!optCollection.isPresent()) {
                return DataTransactionResult.failNoData();
            }
            Collection collection = optCollection.get();
            if (!collection.remove(element)) {
                return DataTransactionResult.failNoData();
            }
            return p.offer(m, (Object)collection);
        }, DataTransactionResult::failNoData);
    }

    default public <E> DataTransactionResult removeAll(Key<? extends CollectionValue<E, ?>> key, Collection<? extends E> elements) {
        if (elements.isEmpty()) {
            return DataTransactionResult.failNoData();
        }
        SpongeKey key0 = (SpongeKey)key;
        return this.impl$applyTransaction(key0, (p, m) -> {
            Optional<Collection> optCollection = p.get((DataHolder)m).map(DataUtil::ensureMutable);
            if (!optCollection.isPresent()) {
                return DataTransactionResult.failNoData();
            }
            Collection collection = optCollection.get();
            if (!collection.removeAll(elements)) {
                return DataTransactionResult.failNoData();
            }
            return p.offer(m, (Object)collection);
        }, DataTransactionResult::failNoData);
    }

    default public <K> DataTransactionResult removeKey(Key<? extends MapValue<K, ?>> key, K mapKey) {
        SpongeKey key0 = (SpongeKey)key;
        return this.impl$applyTransaction(key0, (p, m) -> {
            Optional<Map> optMap = p.get((DataHolder)m).map(DataUtil::ensureMutable);
            if (!optMap.isPresent() || !optMap.get().containsKey(mapKey)) {
                return DataTransactionResult.failNoData();
            }
            Map map = optMap.get();
            map.remove(mapKey);
            return p.offer(m, (Object)map);
        }, DataTransactionResult::failNoData);
    }

    default public <K, V> DataTransactionResult removeAll(Key<? extends MapValue<K, V>> key, Map<? extends K, ? extends V> values) {
        if (values.isEmpty()) {
            return DataTransactionResult.failNoData();
        }
        return this.impl$applyTransaction(key, (p, m) -> {
            Optional<Map> optMap = p.get((DataHolder)m).map(DataUtil::ensureMutable);
            if (!optMap.isPresent()) {
                return DataTransactionResult.failNoData();
            }
            Map map = optMap.get();
            for (Map.Entry entry : values.entrySet()) {
                map.remove(entry.getKey(), entry.getValue());
            }
            return p.offer(m, (Object)map);
        }, DataTransactionResult::failNoData);
    }

    default public DataTransactionResult remove(Key<?> key) {
        return this.impl$applyTransaction(key, DataProvider::remove, DataTransactionResult::failNoData);
    }

    default public DataTransactionResult remove(Value<?> value) {
        return this.impl$applyTransaction(value.key(), (p, m) -> {
            Optional opt = p.get((DataHolder)m);
            if (opt.isPresent() && opt.get().equals(value.get())) {
                return p.remove(m);
            }
            return DataTransactionResult.failNoData();
        }, DataTransactionResult::failNoData);
    }

    default public DataTransactionResult copyFrom(ValueContainer that, MergeFunction function) {
        Objects.requireNonNull(that, "that");
        Objects.requireNonNull(function, "function");
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        boolean success = false;
        if (function == MergeFunction.REPLACEMENT_PREFERRED) {
            for (Value replacement : that.getValues()) {
                DataTransactionResult result = this.offer(replacement);
                builder.absorbResult(result);
                if (!result.isSuccessful()) continue;
                success = true;
            }
        } else if (function == MergeFunction.ORIGINAL_PREFERRED) {
            for (Value replacement : that.getValues()) {
                Key key = replacement.key();
                if (this.get(key).isPresent()) continue;
                Value merged = function.merge(null, replacement);
                DataTransactionResult result = this.offer(merged);
                builder.absorbResult(result);
                if (!result.isSuccessful()) continue;
                success = true;
            }
        } else {
            for (Value replacement : that.getValues()) {
                Key key = replacement.key();
                @Nullable Value original = this.getValue(key).map(Value::asImmutable).orElse(null);
                Value merged = function.merge(original, replacement);
                DataTransactionResult result = this.offer(merged);
                builder.absorbResult(result);
                if (!result.isSuccessful()) continue;
                success = true;
            }
        }
        if (success) {
            builder.result(DataTransactionResult.Type.SUCCESS);
        } else {
            builder.result(DataTransactionResult.Type.FAILURE);
        }
        return builder.build();
    }

    default public DataTransactionResult undo(DataTransactionResult result) {
        if (result.replacedData().isEmpty() && result.successfulData().isEmpty()) {
            return DataTransactionResult.successNoData();
        }
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        for (Value value : result.replacedData()) {
            builder.absorbResult(this.offer(value));
        }
        for (Value value : result.successfulData()) {
            builder.absorbResult(this.remove(value));
        }
        return DataTransactionResult.failNoData();
    }

    default public <E> DataTransactionResult tryOffer(Key<? extends Value<E>> key, E value) {
        DataTransactionResult result = this.offer(key, value);
        if (!result.isSuccessful()) {
            throw new IllegalArgumentException("Failed offer transaction!");
        }
        return result;
    }

    default public DataTransactionResult offerAll(CollectionValue<?, ?> value) {
        return this.offerAll(value.key(), (Collection)value.get());
    }

    default public DataTransactionResult offerAll(MapValue<?, ?> value) {
        return this.offerAll(value.key(), (Map)value.get());
    }

    default public DataTransactionResult removeAll(CollectionValue<?, ?> value) {
        return this.removeAll(value.key(), (Collection)value.get());
    }

    default public DataTransactionResult removeAll(MapValue<?, ?> value) {
        return this.removeAll(value.key(), (Map)value.get());
    }
}

