/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.util.CopyHelper;

abstract class SpongeDataManipulator
implements DataManipulator {
    protected final Map<Key<?>, Object> values;

    SpongeDataManipulator(Map<Key<?>, Object> values) {
        this.values = values;
    }

    Map<Key<?>, Object> copyMap() {
        HashMap copy = new HashMap();
        for (Map.Entry<Key<?>, Object> entry : this.values.entrySet()) {
            copy.put(entry.getKey(), CopyHelper.copy(entry.getValue()));
        }
        return copy;
    }

    public <E> Optional<E> get(Key<? extends Value<E>> key) {
        Objects.requireNonNull(key, "key");
        return Optional.ofNullable(CopyHelper.copy(this.values.get(key)));
    }

    public <E, V extends Value<E>> Optional<V> getValue(Key<V> key) {
        Objects.requireNonNull(key, "key");
        Object element = CopyHelper.copy(this.values.get(key));
        return element == null ? Optional.empty() : Optional.of(Value.genericMutableOf(key, (Object)element));
    }

    public boolean supports(Key<?> key) {
        return true;
    }

    public Set<Value.Immutable<?>> getValues() {
        return (Set)this.values.entrySet().stream().map(entry -> Value.immutableOf((Key)((Key)entry.getKey()), CopyHelper.copy(entry.getValue())).asImmutable()).collect(ImmutableSet.toImmutableSet());
    }

    public String toString() {
        StringJoiner builder = new StringJoiner(", ", SpongeDataManipulator.class.getSimpleName() + "[", "]");
        for (Map.Entry<Key<?>, Object> entry : this.values.entrySet()) {
            builder.add(String.valueOf(entry.getKey().key()) + "= " + String.valueOf(entry.getValue()));
        }
        return builder.toString();
    }
}

