/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.leangen.geantyref.TypeToken;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.ConfigurationVisitor;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public final class ConfigurateTranslator
implements DataTranslator<ConfigurationNode> {
    private static final ConfigurateTranslator INSTANCE = new ConfigurateTranslator();
    private static final TypeToken<ConfigurationNode> TOKEN = TypeToken.get(ConfigurationNode.class);
    private static final ConfigurationOptions DEFAULT_OPTS = ConfigurationOptions.defaults().nativeTypes((Set)ImmutableSet.of(Map.class, List.class, Double.class, Long.class, Integer.class, Boolean.class, (Object[])new Class[]{String.class})).serializers(coll -> coll.registerAll(SpongeAdventure.CONFIGURATE.serializers()));

    public static ConfigurateTranslator instance() {
        return INSTANCE;
    }

    private ConfigurateTranslator() {
    }

    public TypeToken<ConfigurationNode> token() {
        return TOKEN;
    }

    public void translateDataToNode(ConfigurationNode node, DataView view) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(view, "container");
        Map originalMap = node.childrenMap();
        if (originalMap.isEmpty()) {
            node.raw((Object)ImmutableMap.of());
        }
        HashSet unvisitedKeys = new HashSet(originalMap.keySet());
        for (DataQuery key : view.keys(false)) {
            this.valueToNode(node.node((Iterable)key), view.get(key).orElse(null));
            unvisitedKeys.remove(key.parts().get(0));
        }
        for (Object unusedChild : unvisitedKeys) {
            node.removeChild(unusedChild);
        }
    }

    private void valueToNode(ConfigurationNode node, @Nullable Object value) {
        if (value instanceof DataView) {
            this.translateDataToNode(node, (DataView)value);
        } else if (value instanceof Collection) {
            node.raw((Object)ImmutableList.of());
            for (Object child : (Collection)value) {
                this.valueToNode(node.appendListNode(), child);
            }
        } else if (value == null) {
            node.raw(null);
        } else {
            Class<?> vClazz = value.getClass();
            if (node.options().acceptsType(vClazz)) {
                node.raw(value);
            } else {
                @Nullable TypeSerializer serial = node.options().serializers().get(vClazz);
                if (serial != null) {
                    try {
                        serial.serialize(vClazz, value, node);
                    }
                    catch (SerializationException e) {
                        throw new IllegalArgumentException(e);
                    }
                } else {
                    throw new IllegalArgumentException("DataView value type of " + String.valueOf(vClazz) + " is not supported by the provided ConfigurationNode");
                }
            }
        }
    }

    public ConfigurationNode translate(DataView view) throws InvalidDataException {
        BasicConfigurationNode node = BasicConfigurationNode.root((ConfigurationOptions)DEFAULT_OPTS);
        this.translateDataToNode((ConfigurationNode)node, view);
        return node;
    }

    public DataContainer translate(ConfigurationNode obj) throws InvalidDataException {
        DataView view = (DataView)obj.visit((ConfigurationVisitor.Safe)ToDataView.INSTANCE);
        if (!(view instanceof DataContainer)) {
            throw new IllegalStateException("Returned data view was not the original container!");
        }
        return (DataContainer)view;
    }

    public DataView addTo(ConfigurationNode node, DataView dataView) {
        VisitState state = new VisitState();
        state.add(dataView);
        node.visit((ConfigurationVisitor.Safe)ToDataView.INSTANCE, (Object)state);
        return dataView;
    }

    static class ToDataView
    implements ConfigurationVisitor.Safe<VisitState, DataView> {
        static final ToDataView INSTANCE = new ToDataView();

        private ToDataView() {
        }

        private DataQuery queryFrom(ConfigurationNode node) {
            Object key = node.key();
            if (key == null) {
                throw new IllegalArgumentException("Null keys are not supported in data views (at " + String.valueOf(node.path()) + ")");
            }
            return DataQuery.of((String[])new String[]{key.toString()});
        }

        public VisitState newState() {
            VisitState ret = new VisitState();
            ret.add(DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.NO_DATA_CLONED));
            return ret;
        }

        public void beginVisit(ConfigurationNode node, VisitState state) {
            if (!node.empty() && !node.isMap()) {
                throw new IllegalArgumentException("Only mapping nodes can be represented in DataViews");
            }
            state.start = node;
        }

        public void enterNode(ConfigurationNode node, VisitState state) {
        }

        public void enterMappingNode(ConfigurationNode node, VisitState state) {
            DataView ret;
            if (state.start == node) {
                state.addFirst(state.getFirst());
                return;
            }
            Object peek = state.getFirst();
            if (peek instanceof DataView) {
                ret = ((DataView)peek).createView(this.queryFrom(node));
            } else if (peek instanceof List) {
                ret = DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.NO_DATA_CLONED);
                ((List)peek).add(ret);
            } else {
                throw new IllegalArgumentException("Unknown peek type of " + String.valueOf(peek.getClass()));
            }
            state.addFirst(ret);
        }

        public void enterListNode(ConfigurationNode node, VisitState state) {
            state.addFirst(new LinkedList());
        }

        public void enterScalarNode(ConfigurationNode node, VisitState state) {
            this.addToFirst(state, node, node.raw());
        }

        public void exitMappingNode(ConfigurationNode node, VisitState state) {
            if (!(state.removeFirst() instanceof DataView)) {
                throw new IllegalStateException("Exited a mapping node but the top value was not a DataView");
            }
        }

        public void exitListNode(ConfigurationNode node, VisitState state) {
            Object popped = state.removeFirst();
            this.addToFirst(state, node, popped);
        }

        private void addToFirst(Deque<Object> stack, ConfigurationNode keySource, Object value) {
            Object peek = stack.getFirst();
            if (peek instanceof DataView) {
                ((DataView)peek).set(this.queryFrom(keySource), value);
            } else if (peek instanceof List) {
                ((List)peek).add(value);
            }
        }

        public DataView endVisit(VisitState state) {
            state.start = null;
            return (DataView)state.remove();
        }
    }

    static class VisitState
    extends LinkedList<Object> {
        @Nullable ConfigurationNode start;

        VisitState() {
        }
    }
}

