/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import com.google.common.collect.Lists;
import io.leangen.geantyref.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.util.Preconditions;

public final class NBTTranslator
implements DataTranslator<class_2487> {
    public static final NBTTranslator INSTANCE = new NBTTranslator();
    private static final TypeToken<class_2487> TOKEN = TypeToken.get(class_2487.class);
    public static final String BOOLEAN_IDENTIFIER = "$Boolean";

    private static class_2487 containerToCompound(DataView container) {
        Objects.requireNonNull(container);
        class_2487 compound = new class_2487();
        NBTTranslator.containerToCompound(container, compound);
        return compound;
    }

    private static void containerToCompound(DataView container, class_2487 compound) {
        Objects.requireNonNull(container);
        Objects.requireNonNull(compound);
        for (Map.Entry entry : container.values(false).entrySet()) {
            Object value = entry.getValue();
            String key = ((DataQuery)entry.getKey()).asString('.');
            if (value instanceof DataView) {
                class_2487 inner = new class_2487();
                NBTTranslator.containerToCompound((DataView)container.getView((DataQuery)entry.getKey()).get(), inner);
                compound.method_10566(key, (class_2520)inner);
                continue;
            }
            if (value instanceof Boolean) {
                compound.method_10566(key + BOOLEAN_IDENTIFIER, (class_2520)class_2481.method_23234((boolean)((Boolean)value)));
                continue;
            }
            compound.method_10566(key, NBTTranslator.getBaseFromObject(value));
        }
    }

    private static class_2520 getBaseFromObject(Object value) {
        Objects.requireNonNull(value);
        if (value instanceof Boolean) {
            return class_2481.method_23234((boolean)((Boolean)value));
        }
        if (value instanceof Byte) {
            return class_2481.method_23233((byte)((Byte)value));
        }
        if (value instanceof Short) {
            return class_2516.method_23254((short)((Short)value));
        }
        if (value instanceof Integer) {
            return class_2497.method_23247((int)((Integer)value));
        }
        if (value instanceof Long) {
            return class_2503.method_23251((long)((Long)value));
        }
        if (value instanceof Float) {
            return class_2494.method_23244((float)((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return class_2489.method_23241((double)((Double)value));
        }
        if (value instanceof String) {
            return class_2519.method_23256((String)((String)value));
        }
        if (value.getClass().isArray()) {
            if (value instanceof byte[]) {
                return new class_2479((byte[])value);
            }
            if (value instanceof Byte[]) {
                byte[] array = new byte[((Byte[])value).length];
                int counter = 0;
                for (Byte data : (Byte[])value) {
                    array[counter++] = data;
                }
                return new class_2479(array);
            }
            if (value instanceof int[]) {
                return new class_2495((int[])value);
            }
            if (value instanceof Integer[]) {
                int[] array = new int[((Integer[])value).length];
                int counter = 0;
                for (Integer data : (Integer[])value) {
                    array[counter++] = data;
                }
                return new class_2495(array);
            }
            if (value instanceof long[]) {
                return new class_2501((long[])value);
            }
            if (value instanceof Long[]) {
                long[] array = new long[((Long[])value).length];
                int counter = 0;
                for (Long data : (Long[])value) {
                    array[counter++] = data;
                }
                return new class_2501(array);
            }
        } else {
            if (value instanceof List) {
                class_2499 list = new class_2499();
                for (Object object : (List)value) {
                    list.add((Object)NBTTranslator.getBaseFromObject(object));
                }
                return list;
            }
            if (value instanceof Map) {
                class_2487 compound = new class_2487();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    if (entry.getKey() instanceof DataQuery) {
                        if (entry.getValue() instanceof Boolean) {
                            compound.method_10556(((DataQuery)entry.getKey()).asString('.') + BOOLEAN_IDENTIFIER, ((Boolean)entry.getValue()).booleanValue());
                            continue;
                        }
                        compound.method_10566(((DataQuery)entry.getKey()).asString('.'), NBTTranslator.getBaseFromObject(entry.getValue()));
                        continue;
                    }
                    if (entry.getKey() instanceof String) {
                        compound.method_10566((String)entry.getKey(), NBTTranslator.getBaseFromObject(entry.getValue()));
                        continue;
                    }
                    compound.method_10566(entry.getKey().toString(), NBTTranslator.getBaseFromObject(entry.getValue()));
                }
                return compound;
            }
            if (value instanceof DataSerializable) {
                return NBTTranslator.containerToCompound((DataView)((DataSerializable)value).toContainer());
            }
            if (value instanceof DataView) {
                return NBTTranslator.containerToCompound((DataView)value);
            }
        }
        throw new IllegalArgumentException("Unable to translate object to NBTBase: " + String.valueOf(value));
    }

    private static DataContainer getViewFromCompound(class_2487 compound) {
        Objects.requireNonNull(compound);
        DataContainer container = DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.NO_DATA_CLONED);
        INSTANCE.addTo(compound, (DataView)container);
        return container;
    }

    private static void setInternal(class_2520 base, byte type, DataView view, String key) {
        Objects.requireNonNull(base, "base");
        Objects.requireNonNull(view, "view");
        Objects.requireNonNull(key, "key");
        Preconditions.checkArgument(!key.isEmpty(), "key is empty");
        switch (type) {
            case 1: {
                if (key.contains(BOOLEAN_IDENTIFIER)) {
                    view.set(DataQuery.of((String[])new String[]{key.replace(BOOLEAN_IDENTIFIER, "")}), (Object)(((class_2481)base).method_10698() != 0 ? 1 : 0));
                    break;
                }
                view.set(DataQuery.of((String[])new String[]{key}), (Object)((class_2481)base).method_10698());
                break;
            }
            case 2: {
                view.set(DataQuery.of((String[])new String[]{key}), (Object)((class_2516)base).method_10696());
                break;
            }
            case 3: {
                view.set(DataQuery.of((String[])new String[]{key}), (Object)((class_2497)base).method_10701());
                break;
            }
            case 4: {
                view.set(DataQuery.of((String[])new String[]{key}), (Object)((class_2503)base).method_10699());
                break;
            }
            case 5: {
                view.set(DataQuery.of((String[])new String[]{key}), (Object)Float.valueOf(((class_2494)base).method_10700()));
                break;
            }
            case 6: {
                view.set(DataQuery.of((String[])new String[]{key}), (Object)((class_2489)base).method_10697());
                break;
            }
            case 7: {
                view.set(DataQuery.of((String[])new String[]{key}), (Object)((class_2479)base).method_10521());
                break;
            }
            case 8: {
                view.set(DataQuery.of((String[])new String[]{key}), (Object)base.method_10714());
                break;
            }
            case 9: {
                class_2499 list = (class_2499)base;
                byte listType = list.method_10601();
                int count = list.size();
                ArrayList objectList = Lists.newArrayListWithCapacity((int)count);
                for (class_2520 inbt : list) {
                    objectList.add(NBTTranslator.fromTagBase(inbt, listType));
                }
                view.set(DataQuery.of((String[])new String[]{key}), (Object)objectList);
                break;
            }
            case 10: {
                DataView internalView = view.createView(DataQuery.of((String[])new String[]{key}));
                class_2487 compound = (class_2487)base;
                for (String internalKey : compound.method_10541()) {
                    class_2520 internalBase = compound.method_10580(internalKey);
                    byte internalType = internalBase.method_10711();
                    NBTTranslator.setInternal(internalBase, internalType, internalView, internalKey);
                }
                break;
            }
            case 11: {
                view.set(DataQuery.of((String[])new String[]{key}), (Object)((class_2495)base).method_10588());
                break;
            }
            case 12: {
                view.set(DataQuery.of((String[])new String[]{key}), (Object)((class_2501)base).method_10615());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown NBT type " + type);
            }
        }
    }

    private static Object fromTagBase(class_2520 base, byte type) {
        switch (type) {
            case 1: {
                return ((class_2481)base).method_10698();
            }
            case 2: {
                return ((class_2516)base).method_10696();
            }
            case 3: {
                return ((class_2497)base).method_10701();
            }
            case 4: {
                return ((class_2503)base).method_10699();
            }
            case 5: {
                return Float.valueOf(((class_2494)base).method_10700());
            }
            case 6: {
                return ((class_2489)base).method_10697();
            }
            case 7: {
                return ((class_2479)base).method_10521();
            }
            case 8: {
                return base.method_10714();
            }
            case 9: {
                class_2499 list = (class_2499)base;
                byte listType = list.method_10601();
                int count = list.size();
                ArrayList objectList = Lists.newArrayListWithCapacity((int)count);
                for (class_2520 inbt : list) {
                    objectList.add(NBTTranslator.fromTagBase(inbt, listType));
                }
                return objectList;
            }
            case 10: {
                return NBTTranslator.getViewFromCompound((class_2487)base);
            }
            case 11: {
                return ((class_2495)base).method_10588();
            }
            case 12: {
                return ((class_2501)base).method_10615();
            }
        }
        return null;
    }

    public void translateContainerToData(class_2487 node, DataView container) {
        NBTTranslator.containerToCompound(container, node);
    }

    public DataContainer translateFrom(class_2487 node) {
        return NBTTranslator.getViewFromCompound(node);
    }

    public TypeToken<class_2487> token() {
        return TOKEN;
    }

    public class_2487 translate(DataView view) throws InvalidDataException {
        return NBTTranslator.containerToCompound(view);
    }

    public DataContainer translate(class_2487 obj) throws InvalidDataException {
        return NBTTranslator.getViewFromCompound(obj);
    }

    public DataView addTo(class_2487 compound, DataView container) {
        for (String key : compound.method_10541()) {
            class_2520 base = compound.method_10580(key);
            byte type = base.method_10711();
            NBTTranslator.setInternal(base, type, container, key);
        }
        return container;
    }
}

