/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import net.minecraft.class_2522;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.InvalidDataFormatException;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.common.data.persistence.NBTTranslator;

public final class SNBTDataFormat
implements StringDataFormat {
    private static BufferedReader createBufferedReader(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    public DataContainer read(String input) throws InvalidDataException, IOException {
        try {
            return NBTTranslator.INSTANCE.translate(class_2522.method_10718((String)input));
        }
        catch (CommandSyntaxException e) {
            throw new InvalidDataException((Throwable)e);
        }
    }

    public DataContainer readFrom(Reader input) throws InvalidDataException {
        try {
            return NBTTranslator.INSTANCE.translate(class_2522.method_10718((String)SNBTDataFormat.createBufferedReader(input).lines().collect(Collectors.joining("\n"))));
        }
        catch (CommandSyntaxException e) {
            throw new InvalidDataException((Throwable)e);
        }
    }

    public DataContainer readFrom(InputStream input) throws InvalidDataFormatException {
        try {
            return NBTTranslator.INSTANCE.translate(class_2522.method_10718((String)new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"))));
        }
        catch (CommandSyntaxException e) {
            throw new InvalidDataException((Throwable)e);
        }
    }

    public String write(DataView data) throws IOException {
        return NBTTranslator.INSTANCE.translate(data).toString();
    }

    public void writeTo(Writer output, DataView data) throws IOException {
        output.write(NBTTranslator.INSTANCE.translate(data).toString());
    }

    public void writeTo(OutputStream output, DataView data) throws IOException {
        output.write(NBTTranslator.INSTANCE.translate(data).toString().getBytes(StandardCharsets.UTF_8));
    }
}

