/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import com.google.common.collect.ImmutableList;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.persistence.DataView;

public final class SerializedDataTransaction {
    public final ImmutableList<DataView> failedData;
    public final ImmutableList<DataManipulator.Mutable> deserializedManipulators;

    public static Builder builder() {
        return new Builder();
    }

    private SerializedDataTransaction(Builder builder) {
        this.failedData = builder.serializedData.build();
        this.deserializedManipulators = builder.deserializedManipulators.build();
    }

    public static final class Builder {
        private final ImmutableList.Builder<DataView> serializedData = ImmutableList.builder();
        private final ImmutableList.Builder<DataManipulator.Mutable> deserializedManipulators = ImmutableList.builder();

        Builder() {
        }

        public void failedData(DataView serializedData) {
            this.serializedData.add((Object)serializedData);
        }

        public void successfulData(DataManipulator.Mutable success) {
            this.deserializedManipulators.add((Object)success);
        }

        public SerializedDataTransaction build() {
            return new SerializedDataTransaction(this);
        }
    }
}

