/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence.datastore;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataStore;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.util.Tuple;

public class VanillaDataStore
implements DataStore {
    private Map<Key<?>, Tuple<BiConsumer<DataView, ?>, Function<DataView, Optional<?>>>> queriesByKey;
    private Collection<Type> tokens;

    public VanillaDataStore(Map<Key<?>, Tuple<BiConsumer<DataView, ?>, Function<DataView, Optional<?>>>> queriesByKey, Collection<Type> tokens) {
        this.queriesByKey = queriesByKey;
        this.tokens = tokens;
    }

    public Collection<Type> supportedTypes() {
        return this.tokens;
    }

    public DataView serialize(DataManipulator dataManipulator, DataView view) {
        for (Map.Entry<Key<?>, Tuple<BiConsumer<DataView, ?>, Function<DataView, Optional<?>>>> entry : this.queriesByKey.entrySet()) {
            BiConsumer serializer = (BiConsumer)entry.getValue().first();
            dataManipulator.get(entry.getKey()).ifPresent(value -> serializer.accept(view, value));
        }
        return view;
    }

    public void deserialize(DataManipulator.Mutable dataManipulator, DataView view) {
        for (Map.Entry<Key<?>, Tuple<BiConsumer<DataView, ?>, Function<DataView, Optional<?>>>> entry : this.queriesByKey.entrySet()) {
            Function deserializer = (Function)entry.getValue().second();
            ((Optional)deserializer.apply(view)).ifPresent(value -> dataManipulator.set((Key)entry.getKey(), value));
        }
    }
}

