/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence.schematic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_7924;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.schematic.MutableBimapPalette;
import org.spongepowered.common.world.schematic.SchematicTranslator;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.ByteArrayMutableBiomeBuffer;
import org.spongepowered.math.vector.Vector3i;

public final class SchematicUpdater2_to_3
implements DataContentUpdater {
    public int inputVersion() {
        return 2;
    }

    public int outputVersion() {
        return 3;
    }

    public DataView update(DataView content) {
        content.getView(Constants.Sponge.Schematic.Versions.V2_BLOCK_PALETTE).ifPresent(dataView -> {
            content.remove(Constants.Sponge.Schematic.Versions.V2_BLOCK_PALETTE);
            byte[] blockData = (byte[])content.get(Constants.Sponge.Schematic.Versions.V2_BLOCK_DATA).orElseThrow(() -> new InvalidDataException("Missing BlockData for Schematic"));
            content.remove(Constants.Sponge.Schematic.Versions.V2_BLOCK_DATA);
            List blockEntities = content.getViewList(Constants.Sponge.Schematic.BLOCKENTITY_CONTAINER).orElse(Collections.emptyList());
            for (DataView blockEntity : blockEntities) {
                for (Map.Entry entry : blockEntity.values(false).entrySet()) {
                    DataQuery key = (DataQuery)entry.getKey();
                    if (key.equals((Object)Constants.Sponge.Schematic.BLOCKENTITY_POS) || key.equals((Object)Constants.Sponge.Schematic.BLOCKENTITY_ID)) continue;
                    blockEntity.remove(key);
                    blockEntity.set(Constants.Sponge.Schematic.BLOCKENTITY_DATA.then(key), entry.getValue());
                }
            }
            content.remove(Constants.Sponge.Schematic.BLOCKENTITY_CONTAINER);
            DataView blockContainer = content.createView(Constants.Sponge.Schematic.BLOCK_CONTAINER);
            blockContainer.set(Constants.Sponge.Schematic.BLOCK_DATA, (Object)blockData);
            blockContainer.set(Constants.Sponge.Schematic.BLOCK_PALETTE, dataView);
            blockContainer.set(Constants.Sponge.Schematic.BLOCKENTITY_CONTAINER, blockEntities);
        });
        content.get(Constants.Sponge.Schematic.Versions.V2_BIOME_DATA).ifPresent(biomeData -> {
            int y;
            content.remove(Constants.Sponge.Schematic.Versions.V2_BIOME_DATA);
            int[] offset = content.get(Constants.Sponge.Schematic.OFFSET).orElse(new int[3]);
            if (offset.length != 3) {
                throw new InvalidDataException("Schematic offset was not of length 3");
            }
            int xOffset = offset[0];
            int yOffset = offset[1];
            int zOffset = offset[2];
            DataView palette = (DataView)content.getView(Constants.Sponge.Schematic.Versions.V2_BIOME_PALETTE).orElseThrow(() -> new InvalidDataException("Missing Biome Palette for schematic"));
            int width = ((Short)content.getShort(Constants.Sponge.Schematic.WIDTH).orElseThrow(() -> new InvalidDataException("Missing value for: " + String.valueOf(Constants.Sponge.Schematic.WIDTH)))).shortValue();
            int height = ((Short)content.getShort(Constants.Sponge.Schematic.HEIGHT).orElseThrow(() -> new InvalidDataException("Missing value for: " + String.valueOf(Constants.Sponge.Schematic.HEIGHT)))).shortValue();
            int length = ((Short)content.getShort(Constants.Sponge.Schematic.LENGTH).orElseThrow(() -> new InvalidDataException("Missing value for: " + String.valueOf(Constants.Sponge.Schematic.LENGTH)))).shortValue();
            Set biomeKeys = palette.keys(false);
            Registry biomeRegistry = VolumeStreamUtils.nativeToSpongeRegistry(SpongeCommon.vanillaRegistry(class_7924.field_41236));
            MutableBimapPalette<Biome, Biome> biomePalette = new MutableBimapPalette<Biome, Biome>((PaletteType<Biome, Biome>)((PaletteType)PaletteTypes.BIOME_PALETTE.get()), (Registry<Biome>)biomeRegistry, (RegistryType<Biome>)RegistryTypes.BIOME, biomeKeys.size());
            ByteArrayMutableBiomeBuffer biomeBuffer = new ByteArrayMutableBiomeBuffer((Palette<Biome, Biome>)biomePalette, new Vector3i(-xOffset, -yOffset, -zOffset), new Vector3i(width, height, length));
            DataView biomeView = content.createView(Constants.Sponge.Schematic.BIOME_CONTAINER);
            biomeView.set(Constants.Sponge.Schematic.BLOCK_PALETTE, (Object)palette);
            byte[] biomes = (byte[])biomeData;
            int biomeIndex = 0;
            int biomeJ = 0;
            int bVal = 0;
            int varIntLength = 0;
            int yMin = biomeBuffer.min().y();
            int yMax = biomeBuffer.max().y();
            while (biomeJ < biomes.length) {
                bVal = 0;
                varIntLength = 0;
                while (true) {
                    bVal |= (biomes[biomeJ] & 0x7F) << varIntLength++ * 7;
                    if (varIntLength > 5) {
                        throw new RuntimeException("VarInt too big (probably corrupted data)");
                    }
                    if ((biomes[biomeJ] & 0x80) != 128) {
                        ++biomeJ;
                        break;
                    }
                    ++biomeJ;
                }
                int z = biomeIndex % (width * length) / width;
                int x = biomeIndex % (width * length) % width;
                Biome type = (Biome)biomePalette.get(bVal, (RegistryHolder)Sponge.server()).get();
                for (y = yMin; y <= yMax; ++y) {
                    biomeBuffer.setBiome(x - xOffset, y, z - zOffset, type);
                }
                ++biomeIndex;
            }
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream(width * height * length);){
                int xMin = biomeBuffer.min().x();
                int zMin = biomeBuffer.min().z();
                for (y = 0; y < height; ++y) {
                    int y0 = yMin + y;
                    for (int z = 0; z < length; ++z) {
                        int z0 = zMin + z;
                        for (int x = 0; x < width; ++x) {
                            int x0 = xMin + x;
                            Biome biome = biomeBuffer.biome(x0, y0, z0);
                            SchematicTranslator.writeIdToBuffer(buffer, biomePalette.orAssign(biome));
                        }
                    }
                }
                content.set(Constants.Sponge.Schematic.BIOME_DATA, (Object)buffer.toByteArray());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            content.remove(Constants.Sponge.Schematic.Versions.V2_BIOME_PALETTE);
        });
        content.set(Constants.Sponge.Schematic.VERSION, (Object)3);
        return content;
    }
}

