/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.data.provider.MutableDataProvider;

public class CustomDataProvider<V extends Value<E>, E>
extends MutableDataProvider<V, E> {
    private final Set<Type> supportedTokens;

    public CustomDataProvider(Key<V> key, Set<Type> supportedTokens) {
        super(key);
        this.supportedTokens = supportedTokens;
    }

    public Optional<E> get(DataHolder dataHolder) {
        if (this.isSupported(dataHolder)) {
            SpongeDataHolderBridge customDataHolder = CustomDataProvider.getCustomDataHolder(dataHolder);
            return customDataHolder.bridge$get(this.key());
        }
        return Optional.empty();
    }

    private static SpongeDataHolderBridge getCustomDataHolder(DataHolder dataHolder) {
        SpongeDataHolderBridge customDataHolder = dataHolder instanceof ServerLocation ? (SpongeDataHolderBridge)((ServerLocation)dataHolder).blockEntity().get() : (SpongeDataHolderBridge)dataHolder;
        return customDataHolder;
    }

    public boolean isSupported(DataHolder dataHolder) {
        if (dataHolder instanceof ServerLocation) {
            if (!((ServerLocation)dataHolder).hasBlockEntity()) {
                return false;
            }
            for (Type type : this.supportedTokens) {
                if (!GenericTypeReflector.erase((Type)type).isAssignableFrom(BlockEntity.class)) continue;
                return true;
            }
            return false;
        }
        if (!(dataHolder instanceof SpongeDataHolderBridge)) {
            return false;
        }
        for (Type type : this.supportedTokens) {
            if (!GenericTypeReflector.erase((Type)type).isAssignableFrom(dataHolder.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean isSupported(Type dataHolder) {
        if (!SpongeDataHolderBridge.class.isAssignableFrom(GenericTypeReflector.erase((Type)dataHolder))) {
            return true;
        }
        for (Type token : this.supportedTokens) {
            if (!GenericTypeReflector.isSuperType((Type)token, (Type)dataHolder)) continue;
            return true;
        }
        return false;
    }

    public DataTransactionResult offer(DataHolder.Mutable dataHolder, E element) {
        if (this.isSupported((DataHolder)dataHolder)) {
            return CustomDataProvider.getCustomDataHolder((DataHolder)dataHolder).bridge$offer(this.key(), element);
        }
        return DataTransactionResult.failNoData();
    }

    public DataTransactionResult remove(DataHolder.Mutable dataHolder) {
        if (this.isSupported((DataHolder)dataHolder)) {
            return CustomDataProvider.getCustomDataHolder((DataHolder)dataHolder).bridge$remove(this.key());
        }
        return DataTransactionResult.failNoData();
    }
}

