/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.CollectionDataProvider;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.ImmutableDataProviderBuilder;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.MutableDataProviderBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataStore;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.value.CollectionValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.util.OptBool;
import org.spongepowered.common.bridge.data.DataContainerHolder;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.SpongeDataRegistration;
import org.spongepowered.common.data.SpongeDataRegistrationBuilder;
import org.spongepowered.common.data.persistence.datastore.SpongeDataStoreBuilder;
import org.spongepowered.common.data.provider.GenericImmutableDataProvider;
import org.spongepowered.common.data.provider.GenericMutableDataProvider;
import org.spongepowered.common.util.CopyHelper;
import org.spongepowered.common.util.TypeTokenUtil;

public class DataProviderRegistrator {
    private static final Class<DataContainerHolder.Mutable> MUTABLE = DataContainerHolder.Mutable.class;
    private static final Class<DataContainerHolder.Immutable> IMMUTABLE = DataContainerHolder.Immutable.class;
    SpongeDataRegistrationBuilder registrationBuilder;
    SpongeDataStoreBuilder dataStoreBuilder;

    public DataProviderRegistrator() {
        this.registrationBuilder = (SpongeDataRegistrationBuilder)DataRegistration.builder();
        this.dataStoreBuilder = (SpongeDataStoreBuilder)DataStore.builder().vanillaData();
    }

    public DataProviderRegistrator(SpongeDataRegistrationBuilder registrationBuilder) {
        this.registrationBuilder = registrationBuilder;
    }

    @SafeVarargs
    public final DataProviderRegistrator newDataStore(Class<? extends DataHolder> ... dataHolders) {
        if (!this.dataStoreBuilder.isEmpty()) {
            this.registrationBuilder.store(this.dataStoreBuilder.buildVanillaDataStore());
        }
        this.dataStoreBuilder.reset();
        this.dataStoreBuilder.holder((Class[])dataHolders);
        return this;
    }

    public void spongeDataStore(ResourceKey datastoreKey, Class dataHolder, Key<? extends Value<?>> ... dataKeys) {
        this.spongeDataStore(datastoreKey, 1, new DataContentUpdater[0], dataHolder, dataKeys);
    }

    public void spongeDataStore(ResourceKey datastoreKey, int version, DataContentUpdater[] contentUpdater, Class dataHolder, Key<? extends Value<?>> ... dataKeys) {
        this.spongeDataStore(datastoreKey, version, dataHolder, (SpongeDataStoreBuilder builder) -> {
            builder.updater(contentUpdater);
            for (Key dataKey : dataKeys) {
                builder.key(dataKey, new String[]{dataKey.key().value()});
            }
        }, dataKeys);
    }

    public void spongeDataStore(ResourceKey datastoreKey, int version, Class dataHolder, Consumer<SpongeDataStoreBuilder> consumer, Key<? extends Value<?>> ... dataKeys) {
        SpongeDataStoreBuilder builder = ((SpongeDataStoreBuilder)DataStore.builder()).pluginData(datastoreKey, version);
        builder.holder(new Class[]{dataHolder});
        consumer.accept(builder);
        SpongeDataManager.getDatastoreRegistry().register(builder.build(), Arrays.asList(dataKeys));
    }

    public <K, V extends Value<K>> DataProviderRegistrator dataStore(Key<V> key, BiConsumer<DataView, K> serializer, Function<DataView, Optional<K>> deserializer) {
        this.dataStoreBuilder.key((Key)key, serializer, deserializer);
        this.dataStoreBuilder.getDataHolderTypes().forEach(typeToken -> this.registerDataStoreDelegatingProvider(key, (Type)typeToken));
        return this;
    }

    public <H extends DataHolder, K, V extends Value<K>> void registerDataStoreDelegatingProvider(Key<V> key, Type typeToken) {
        if (GenericTypeReflector.isSuperType(MUTABLE, (Type)typeToken)) {
            ((MutableRegistration)this.asMutable(GenericTypeReflector.erase((Type)typeToken)).create(key).get(holder -> {
                DataContainer dataContainer = ((DataContainerHolder)holder).data$getDataContainer();
                return SpongeDataManager.getDatastoreRegistry().getDataStore(key, typeToken).deserialize((DataView)dataContainer).get(key).orElse(null);
            })).set((holder, v) -> {
                DataContainer dataContainer = ((DataContainerHolder)holder).data$getDataContainer();
                DataManipulator.Mutable manipulator = DataManipulator.mutableOf();
                manipulator.set(key, v);
                SpongeDataManager.getDatastoreRegistry().getDataStore(key, typeToken).serialize((DataManipulator)manipulator, (DataView)dataContainer);
                ((DataContainerHolder.Mutable)holder).data$setDataContainer(dataContainer);
            });
        } else if (GenericTypeReflector.isSuperType(IMMUTABLE, (Type)typeToken)) {
            ((ImmutableRegistration)this.asImmutable(GenericTypeReflector.erase((Type)typeToken)).create(key).get(holder -> {
                DataContainer dataContainer = ((DataContainerHolder)holder).data$getDataContainer();
                return SpongeDataManager.getDatastoreRegistry().getDataStore(key, typeToken).deserialize((DataView)dataContainer).get(key).orElse(null);
            })).set((holder, v) -> {
                DataContainer dataContainer = ((DataContainerHolder)holder).data$getDataContainer();
                DataManipulator.Mutable manipulator = DataManipulator.mutableOf();
                manipulator.set(key, v);
                SpongeDataManager.getDatastoreRegistry().getDataStore(key, typeToken).serialize((DataManipulator)manipulator, (DataView)dataContainer);
                return ((DataContainerHolder.Immutable)holder).data$withDataContainer(dataContainer);
            });
        }
    }

    public <T> MutableRegistrator<T> asMutable(Class<T> target) {
        return new MutableRegistrator<T>(this.registrationBuilder, target);
    }

    public <T> ImmutableRegistrator<T> asImmutable(Class<T> target) {
        return new ImmutableRegistrator<T>(this.registrationBuilder, target);
    }

    public void buildAndRegister() {
        if (!this.dataStoreBuilder.isEmpty()) {
            this.registrationBuilder.store(this.dataStoreBuilder.buildVanillaDataStore());
        }
        ((SpongeDataManager)Sponge.game().dataManager()).registerDataRegistration((SpongeDataRegistration)this.registrationBuilder.build());
    }

    public static final class MutableRegistrator<T>
    extends DataProviderRegistrator {
        private final Class<T> target;

        public MutableRegistrator(SpongeDataRegistrationBuilder builder, Class<T> target) {
            super(builder);
            this.target = target;
        }

        public <K, V extends Value<K>> MutableRegistration<T, K, V> create(Supplier<? extends Key<V>> suppliedKey) {
            return this.create(suppliedKey.get());
        }

        public <K, V extends Value<K>> MutableRegistration<T, K, V> create(Key<V> key) {
            MutableRegistration registration = new MutableRegistration(this, key);
            this.register(registration);
            return registration;
        }

        protected <K, V extends Value<K>> MutableRegistrator<T> register(AbstractMutableRegistration<T, K, ?, ?> registration) {
            DataProvider provider = registration.build((Class)this.target);
            this.registrationBuilder.dataKey(provider.key()).provider(provider);
            return this;
        }
    }

    public static final class MutableRegistration<H, E, V extends Value<E>>
    extends AbstractMutableRegistration<H, E, V, MutableRegistration<H, E, V>> {
        MutableRegistration(MutableRegistrator<H> registrator, Key<V> key) {
            super(registrator, key);
        }
    }

    private static class MutableRegistrationBase<H, E, V extends Value<E>, R extends MutableRegistrationBase<H, E, V, R>> {
        final Key<V> key;
        private @Nullable BiFunction<H, E, V> constructValue;
        private @Nullable Function<H, @Nullable E> get;
        private @Nullable BiFunction<H, E, Boolean> setAnd;
        private @Nullable BiConsumer<H, E> set;
        private @Nullable Function<H, Boolean> deleteAnd;
        private @Nullable Consumer<H> delete;
        private @Nullable Function<H, DataTransactionResult> deleteAndGet;
        private @Nullable Function<H, E> resetOnDelete;
        private @Nullable BiFunction<H, E, DataTransactionResult> setAndGet;
        private @Nullable Function<H, Boolean> supports;

        public MutableRegistrationBase(Key<V> key) {
            this.key = key;
        }

        public R constructValue(BiFunction<H, E, V> constructValue) {
            this.constructValue = constructValue;
            return (R)this;
        }

        public R get(Function<H, @Nullable E> get) {
            this.get = get;
            return (R)this;
        }

        public R set(BiConsumer<H, E> set) {
            this.set = set;
            return (R)this;
        }

        public R setAnd(BiFunction<H, E, Boolean> setAnd) {
            this.setAnd = setAnd;
            return (R)this;
        }

        public R delete(Consumer<H> delete) {
            this.delete = delete;
            return (R)this;
        }

        public R deleteAnd(Function<H, Boolean> deleteAnd) {
            this.deleteAnd = deleteAnd;
            return (R)this;
        }

        public R deleteAndGet(Function<H, DataTransactionResult> deleteAndGet) {
            this.deleteAndGet = deleteAndGet;
            return (R)this;
        }

        public R resetOnDelete(E value) {
            return this.resetOnDelete(CopyHelper.createSupplier(value));
        }

        public R resetOnDelete(Supplier<E> resetOnDeleteTo) {
            return this.resetOnDelete((H h) -> resetOnDeleteTo.get());
        }

        public R resetOnDelete(Function<H, E> resetOnDeleteTo) {
            this.resetOnDelete = resetOnDeleteTo;
            return (R)this;
        }

        public R setAndGet(BiFunction<H, E, DataTransactionResult> setAndGet) {
            this.setAndGet = setAndGet;
            return (R)this;
        }

        public R supports(Function<H, Boolean> supports) {
            this.supports = supports;
            return (R)this;
        }

        public DataProvider<?, ?> build(Class<H> target) {
            return new SpongeMutableDataProvider(this.key, target);
        }

        protected class SpongeMutableDataProvider
        extends GenericMutableDataProvider<H, E, V> {
            private final boolean isBooleanKey;

            SpongeMutableDataProvider(Key<V> key, Class<H> holderType) {
                super(key, holderType);
                this.isBooleanKey = MutableRegistrationBase.this.key.elementType() == Boolean.class;
            }

            @Override
            protected V constructValue(H dataHolder, E element) {
                if (MutableRegistrationBase.this.constructValue != null) {
                    return (Value)MutableRegistrationBase.this.constructValue.apply(dataHolder, element);
                }
                return super.constructValue(dataHolder, element);
            }

            @Override
            protected Optional<E> getFrom(H dataHolder) {
                if (MutableRegistrationBase.this.get == null) {
                    return Optional.empty();
                }
                if (this.isBooleanKey) {
                    return OptBool.of((Boolean)((Boolean)MutableRegistrationBase.this.get.apply(dataHolder)));
                }
                return Optional.ofNullable(MutableRegistrationBase.this.get.apply(dataHolder));
            }

            @Override
            protected boolean set(H dataHolder, E value) {
                if (MutableRegistrationBase.this.setAnd != null) {
                    return MutableRegistrationBase.this.setAnd.apply(dataHolder, value);
                }
                if (MutableRegistrationBase.this.set != null) {
                    MutableRegistrationBase.this.set.accept(dataHolder, value);
                    return true;
                }
                return super.set(dataHolder, value);
            }

            @Override
            protected boolean delete(H dataHolder) {
                if (MutableRegistrationBase.this.deleteAnd != null) {
                    return MutableRegistrationBase.this.deleteAnd.apply(dataHolder);
                }
                if (MutableRegistrationBase.this.delete != null) {
                    MutableRegistrationBase.this.delete.accept(dataHolder);
                    return true;
                }
                if (MutableRegistrationBase.this.resetOnDelete != null) {
                    return this.set(dataHolder, MutableRegistrationBase.this.resetOnDelete.apply(dataHolder));
                }
                return super.delete(dataHolder);
            }

            @Override
            protected DataTransactionResult setAndGetResult(H dataHolder, E value) {
                if (MutableRegistrationBase.this.setAndGet != null) {
                    return MutableRegistrationBase.this.setAndGet.apply(dataHolder, value);
                }
                return super.setAndGetResult(dataHolder, value);
            }

            @Override
            protected DataTransactionResult deleteAndGetResult(H dataHolder) {
                if (MutableRegistrationBase.this.deleteAndGet != null) {
                    return MutableRegistrationBase.this.deleteAndGet.apply(dataHolder);
                }
                if (MutableRegistrationBase.this.resetOnDelete != null) {
                    return this.setAndGetResult(dataHolder, MutableRegistrationBase.this.resetOnDelete.apply(dataHolder));
                }
                return super.deleteAndGetResult(dataHolder);
            }

            @Override
            protected boolean supports(H dataHolder) {
                if (MutableRegistrationBase.this.supports != null) {
                    return MutableRegistrationBase.this.supports.apply(dataHolder);
                }
                return super.supports(dataHolder);
            }
        }
    }

    public static final class ImmutableRegistrator<T>
    extends DataProviderRegistrator {
        private final Class<T> target;

        public ImmutableRegistrator(SpongeDataRegistrationBuilder builder, Class<T> target) {
            super(builder);
            this.target = target;
        }

        public <K> ImmutableRegistration<T, K> create(Supplier<? extends Key<? extends Value<K>>> suppliedKey) {
            return this.create(suppliedKey.get());
        }

        public <K> ImmutableRegistration<T, K> create(Key<? extends Value<K>> key) {
            ImmutableRegistration registration = new ImmutableRegistration(this, key);
            this.register(registration);
            return registration;
        }

        protected <K, V> ImmutableRegistrator<T> register(ImmutableRegistration<T, K> registration) {
            DataProvider provider = registration.build((Class)this.target);
            this.registrationBuilder.dataKey(provider.key()).provider(provider);
            return this;
        }
    }

    public static final class ImmutableRegistration<H, E>
    extends ImmutableRegistrationBase<H, E, ImmutableRegistration<H, E>> {
        private final ImmutableRegistrator<H> registrator;

        private ImmutableRegistration(ImmutableRegistrator<H> registrator, Key<? extends Value<E>> key) {
            super(key);
            this.registrator = registrator;
        }

        public <NE> ImmutableRegistration<H, NE> create(DefaultedRegistryReference<? extends Key<? extends Value<NE>>> suppliedKey) {
            return this.create((Key)suppliedKey.get());
        }

        public <NE> ImmutableRegistration<H, NE> create(Key<? extends Value<NE>> key) {
            ImmutableRegistration<H, E> registration = new ImmutableRegistration<H, E>(this.registrator, key);
            this.registrator.register(registration);
            return registration;
        }

        public <NT> MutableRegistrator<NT> asMutable(Class<NT> target) {
            return new MutableRegistrator<NT>(this.registrator.registrationBuilder, target);
        }

        public <NT> ImmutableRegistrator<NT> asImmutable(Class<NT> target) {
            return new ImmutableRegistrator<NT>(this.registrator.registrationBuilder, target);
        }
    }

    private static class ImmutableRegistrationBase<H, E, R extends ImmutableRegistrationBase<H, E, R>> {
        private final Key<? extends Value<E>> key;
        private @Nullable BiFunction<H, E, Value<E>> constructValue;
        private @Nullable Function<H, E> get;
        private @Nullable BiFunction<H, E, H> set;
        private @Nullable Function<H, Boolean> supports;

        public ImmutableRegistrationBase(Key<? extends Value<E>> key) {
            this.key = key;
        }

        public R constructValue(BiFunction<H, E, Value<E>> constructValue) {
            this.constructValue = constructValue;
            return (R)this;
        }

        public R get(Function<H, E> get) {
            this.get = get;
            return (R)this;
        }

        public R set(BiFunction<H, E, H> set) {
            this.set = set;
            return (R)this;
        }

        public R supports(Function<H, Boolean> supports) {
            this.supports = supports;
            return (R)this;
        }

        public DataProvider<?, ?> build(Class<H> target) {
            final ImmutableRegistrationBase registration = this;
            return new GenericImmutableDataProvider<H, E>(this, registration.key, target){
                final boolean isBooleanKey;
                {
                    super(key, target);
                    this.isBooleanKey = GenericTypeReflector.erase((Type)registration.key.elementType()) == Boolean.class;
                }

                @Override
                protected Value<E> constructValue(H dataHolder, E element) {
                    if (registration.constructValue != null) {
                        return registration.constructValue.apply(dataHolder, element);
                    }
                    return super.constructValue(dataHolder, element);
                }

                @Override
                protected Optional<E> getFrom(H dataHolder) {
                    if (registration.get == null) {
                        return Optional.empty();
                    }
                    if (this.isBooleanKey) {
                        return OptBool.of((Boolean)((Boolean)registration.get.apply(dataHolder)));
                    }
                    return Optional.ofNullable(registration.get.apply(dataHolder));
                }

                @Override
                protected Optional<H> set(H dataHolder, E value) {
                    if (registration.set == null) {
                        return Optional.empty();
                    }
                    return Optional.ofNullable(registration.set.apply(dataHolder, value));
                }

                @Override
                protected boolean supports(H dataHolder) {
                    if (registration.supports != null) {
                        return registration.supports.apply(dataHolder);
                    }
                    return super.supports(dataHolder);
                }
            };
        }
    }

    public static class SpongeMutableDataProviderBuilder<H extends DataHolder.Mutable, V extends Value<E>, E, S, R extends MutableRegistrationBase<H, E, V, R>>
    implements MutableDataProviderBuilder<H, V, E> {
        private MutableRegistrationBase<H, E, V, R> registration;
        private Type holder;

        public <NV extends Value<NE>, NE> MutableDataProviderBuilder<H, NV, NE> key(Key<NV> key) {
            this.registration = new MutableRegistrationBase(key);
            return this;
        }

        public <NH extends H> MutableDataProviderBuilder<NH, V, E> dataHolder(TypeToken<NH> holder) {
            this.holder = holder.getType();
            return this;
        }

        public <NH extends H> MutableDataProviderBuilder<NH, V, E> dataHolder(Class<NH> holder) {
            this.holder = TypeTokenUtil.requireCompleteGenerics(holder);
            return this;
        }

        public MutableDataProviderBuilder<H, V, E> get(Function<H, E> get) {
            this.registration.get(get);
            return this;
        }

        public MutableDataProviderBuilder<H, V, E> set(BiConsumer<H, E> set) {
            this.registration.set(set);
            return this;
        }

        public MutableDataProviderBuilder<H, V, E> setAnd(BiFunction<H, E, Boolean> setAnd) {
            this.registration.setAnd(setAnd);
            return this;
        }

        public MutableDataProviderBuilder<H, V, E> delete(Consumer<H> delete) {
            this.registration.delete(delete);
            return this;
        }

        public MutableDataProviderBuilder<H, V, E> deleteAnd(Function<H, Boolean> delete) {
            this.registration.deleteAnd(delete);
            return this;
        }

        public MutableDataProviderBuilder<H, V, E> deleteAndGet(Function<H, DataTransactionResult> delete) {
            this.registration.deleteAndGet(delete);
            return this;
        }

        public MutableDataProviderBuilder<H, V, E> resetOnDelete(Supplier<E> resetOnDeleteTo) {
            this.registration.resetOnDelete(resetOnDeleteTo);
            return this;
        }

        public MutableDataProviderBuilder<H, V, E> resetOnDelete(Function<H, E> resetOnDeleteTo) {
            this.registration.resetOnDelete(resetOnDeleteTo);
            return this;
        }

        public MutableDataProviderBuilder<H, V, E> setAndGet(BiFunction<H, E, DataTransactionResult> setAndGet) {
            this.registration.setAndGet(setAndGet);
            return this;
        }

        public MutableDataProviderBuilder<H, V, E> supports(Function<H, Boolean> supports) {
            this.registration.supports(supports);
            return this;
        }

        public MutableDataProviderBuilder<H, V, E> reset() {
            this.registration = null;
            return this;
        }

        public DataProvider<V, E> build() {
            return this.registration.build(GenericTypeReflector.erase((Type)this.holder));
        }
    }

    public static class SpongeImmutableDataProviderBuilder<H extends DataHolder, V extends Value<E>, E, R extends ImmutableRegistrationBase<H, E, R>>
    implements ImmutableDataProviderBuilder<H, V, E> {
        private ImmutableRegistrationBase<H, E, R> registration;
        private Type holder;

        public <NV extends Value<NE>, NE> ImmutableDataProviderBuilder<H, NV, NE> key(Key<NV> key) {
            this.registration = new ImmutableRegistrationBase(key);
            return this;
        }

        public <NH extends H> ImmutableDataProviderBuilder<NH, V, E> dataHolder(TypeToken<NH> holder) {
            this.holder = holder.getType();
            return this;
        }

        public <NH extends H> ImmutableDataProviderBuilder<NH, V, E> dataHolder(Class<NH> holder) {
            this.holder = TypeTokenUtil.requireCompleteGenerics(holder);
            return this;
        }

        public ImmutableDataProviderBuilder<H, V, E> get(Function<H, E> get) {
            this.registration.get(get);
            return this;
        }

        public ImmutableDataProviderBuilder<H, V, E> set(BiFunction<H, E, H> set) {
            this.registration.set(set);
            return this;
        }

        public ImmutableDataProviderBuilder<H, V, E> supports(Function<H, Boolean> supports) {
            this.registration.supports(supports);
            return this;
        }

        public ImmutableDataProviderBuilder<H, V, E> reset() {
            this.registration = null;
            return this;
        }

        public DataProvider<? extends Value<E>, E> build() {
            return this.registration.build(GenericTypeReflector.erase((Type)this.holder));
        }
    }

    public static final class MutableCollectionRegistration<H, E extends Collection<S>, S>
    extends AbstractMutableCollectionRegistration<H, E, S, MutableCollectionRegistration<H, E, S>> {
        MutableCollectionRegistration(MutableRegistrator<H> registrator, Key<CollectionValue<S, E>> key) {
            super(registrator, key);
        }
    }

    public static class AbstractMutableCollectionRegistration<H, E extends Collection<S>, S, R extends AbstractMutableCollectionRegistration<H, E, S, R>>
    extends AbstractMutableRegistration<H, E, CollectionValue<S, E>, R> {
        private @Nullable BiFunction<H, S, Boolean> offerSingleAnd;
        private @Nullable BiFunction<H, S, Boolean> removeSingleAnd;

        AbstractMutableCollectionRegistration(MutableRegistrator<H> registrator, Key<CollectionValue<S, E>> key) {
            super(registrator, key);
        }

        public R offerSingleAnd(BiFunction<H, S, Boolean> offerSingleAnd) {
            this.offerSingleAnd = offerSingleAnd;
            return (R)this;
        }

        public R removeSingleAnd(BiFunction<H, S, Boolean> removeSingleAnd) {
            this.removeSingleAnd = removeSingleAnd;
            return (R)this;
        }

        @Override
        public DataProvider<?, ?> build(Class<H> target) {
            return new SpongeMutableCollectionDataProvider(this.key, target);
        }

        private class SpongeMutableCollectionDataProvider
        extends MutableRegistrationBase.SpongeMutableDataProvider
        implements CollectionDataProvider<S, E, CollectionValue<S, E>> {
            SpongeMutableCollectionDataProvider(Key<CollectionValue<S, E>> key, Class<H> holderType) {
                super(key, holderType);
            }

            public DataTransactionResult offerSingle(DataHolder.Mutable dataHolder, S element) {
                return this.modifyCollection(dataHolder, element, AbstractMutableCollectionRegistration.this.offerSingleAnd);
            }

            public DataTransactionResult removeSingle(DataHolder.Mutable dataHolder, S element) {
                return this.modifyCollection(dataHolder, element, AbstractMutableCollectionRegistration.this.removeSingleAnd);
            }

            private DataTransactionResult modifyCollection(H dataHolder, S element, BiFunction<H, S, Boolean> operation) {
                Optional<Value.Immutable> originalValue = this.getFrom(dataHolder).map(e -> ((CollectionValue)this.constructValue(dataHolder, e)).asImmutable());
                if (operation.apply(dataHolder, element).booleanValue()) {
                    DataTransactionResult.Builder builder = DataTransactionResult.builder();
                    originalValue.ifPresent(arg_0 -> ((DataTransactionResult.Builder)builder).replace(arg_0));
                    Optional<Value.Immutable> replacementValue = this.getFrom(dataHolder).map(e -> ((CollectionValue)this.constructValue(dataHolder, e)).asImmutable());
                    return builder.result(DataTransactionResult.Type.SUCCESS).success(replacementValue.orElseThrow()).build();
                }
                return DataTransactionResult.failNoData();
            }
        }
    }

    public static class AbstractMutableRegistration<H, E, V extends Value<E>, R extends AbstractMutableRegistration<H, E, V, R>>
    extends MutableRegistrationBase<H, E, V, R> {
        private final MutableRegistrator<H> registrator;

        AbstractMutableRegistration(MutableRegistrator<H> registrator, Key<V> key) {
            super(key);
            this.registrator = registrator;
        }

        public <NE, NV extends Value<NE>> MutableRegistration<H, NE, NV> create(DefaultedRegistryReference<? extends Key<NV>> suppliedKey) {
            return this.create((Key)suppliedKey.get());
        }

        public <NE, NV extends Value<NE>> MutableRegistration<H, NE, NV> create(Key<NV> key) {
            MutableRegistration registration = new MutableRegistration(this.registrator, key);
            this.registrator.register(registration);
            return registration;
        }

        public <NE extends Collection<NS>, NV extends CollectionValue<NS, NE>, NS> MutableCollectionRegistration<H, NE, NS> createCollection(Key<NV> key) {
            MutableCollectionRegistration registration = new MutableCollectionRegistration(this.registrator, key);
            this.registrator.register(registration);
            return registration;
        }

        public <NT> MutableRegistrator<NT> asMutable(Class<NT> target) {
            return new MutableRegistrator<NT>(this.registrator.registrationBuilder, target);
        }

        public <NT> ImmutableRegistrator<NT> asImmutable(Class<NT> target) {
            return new ImmutableRegistrator<NT>(this.registrator.registrationBuilder, target);
        }
    }
}

