/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider;

import java.lang.reflect.Type;
import java.util.Optional;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;

public final class EmptyDataProvider<V extends Value<E>, E>
implements DataProvider<V, E> {
    private final Key<V> key;

    public EmptyDataProvider(Key<V> key) {
        this.key = key;
    }

    public Key<V> key() {
        return this.key;
    }

    public boolean allowsAsynchronousAccess(DataHolder dataHolder) {
        return false;
    }

    public Optional<E> get(DataHolder dataHolder) {
        return Optional.empty();
    }

    public boolean isSupported(DataHolder dataHolder) {
        return false;
    }

    public boolean isSupported(Type dataHolder) {
        return false;
    }

    public DataTransactionResult offer(DataHolder.Mutable dataHolder, E element) {
        return DataTransactionResult.failResult((Value.Immutable)Value.immutableOf(this.key, element));
    }

    public DataTransactionResult remove(DataHolder.Mutable dataHolder) {
        return DataTransactionResult.failNoData();
    }

    public <I extends DataHolder.Immutable<I>> Optional<I> with(I immutable, E element) {
        return Optional.empty();
    }

    public <I extends DataHolder.Immutable<I>> Optional<I> without(I immutable) {
        return Optional.of(immutable);
    }
}

